/**
 * @module     theme_remui/feedback
 * @copyright (c) 2023 WisdmLabs (https://wisdmlabs.com/)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_remui/feedback",["jquery","core/ajax"],(function($,Ajax){$.feedback=function(options){var settings=$.extend({ajaxURL:"",postBrowserInfo:!0,postHTML:!0,postURL:!0,proxy:void 0,letterRendering:!1,initButtonText:"Send feedback",strokeStyle:"black",shadowColor:"black",shadowOffsetX:1,shadowOffsetY:1,shadowBlur:10,lineJoin:"bevel",lineWidth:3,html2canvasURL:"html2canvas.js",feedbackButton:".feedback-btn",showDescriptionModal:!0,isDraggable:!0,onScreenshotTaken:function(){},tpl:{description:'<div id="feedback-welcome"><div class="feedback-logo">Feedback</div><p>Feedback lets you send us suggestions about our products. We welcome problem reports, feature ideas and general comments.</p><p>Start by writing a brief description:</p><textarea id="feedback-note-tmp"></textarea><p>Next we\'ll let you identify areas of the page related to your description.</p><button id="feedback-welcome-next" class="feedback-next-btn feedback-btn-gray">Next</button><div id="feedback-welcome-error">Please enter a description.</div><div class="feedback-wizard-close"></div></div>',highlighter:'<div id="feedback-highlighter"><div class="feedback-logo">Feedback</div><p>Click and drag on the page to help us better understand your feedback. You can move this dialog if it\'s in the way.</p><button class="feedback-sethighlight feedback-active"><div class="ico"></div><span>Highlight</span></button><label>Highlight areas relevant to your feedback.</label><button class="feedback-setblackout"><div class="ico"></div><span>Black out</span></button><label class="lower">Black out any personal information.</label><div class="feedback-buttons"><button id="feedback-highlighter-next" class="feedback-next-btn feedback-btn-gray">Next</button><button id="feedback-highlighter-back" class="feedback-back-btn feedback-btn-gray">Back</button></div><div class="feedback-wizard-close"></div></div>',overview:'<div id="feedback-overview"><div class="feedback-logo">Feedback</div><div id="feedback-overview-description"><div id="feedback-overview-description-text"><h3>Description</h3><h3 class="feedback-additional">Additional info</h3><div id="feedback-additional-none"><span>None</span></div><div id="feedback-browser-info"><span>Browser Info</span></div><div id="feedback-page-info"><span>Page Info</span></div><div id="feedback-page-structure"><span>Page Structure</span></div></div></div><div id="feedback-overview-screenshot"><h3>Screenshot</h3></div><div class="feedback-buttons"><button id="feedback-submit" class="feedback-submit-btn feedback-btn-blue">Submit</button><button id="feedback-overview-back" class="feedback-back-btn feedback-btn-gray">Back</button></div><div id="feedback-overview-error">Please enter a description.</div><div class="feedback-wizard-close"></div></div>',submitLoading:'<div id="feedback-submit-loading"><div class="feedback-logo">Feedback</div><p>Loading...</p></div>',submitSuccess:'<div id="feedback-submit-success"><div class="feedback-logo">Feedback</div><p>Thank you for your feedback. We value every piece of feedback we receive.</p></p><button class="feedback-close-btn feedback-btn-blue">OK</button><div class="feedback-wizard-close"></div></div>',submitError:'<div id="feedback-submit-error"><div class="feedback-logo">Feedback</div><p>Sadly an error occured while sending your feedback. Please try again.</p><button class="feedback-close-btn feedback-btn-blue">OK</button><div class="feedback-wizard-close"></div></div>'},onClose:function(){},onTrigger:function(){},screenshotStroke:!0,highlightElement:!0,initialBox:!1},options),supportedBrowser=!!window.HTMLCanvasElement,isFeedbackButtonNative=".feedback-btn"==settings.feedbackButton,_html2canvas=!1;function close(){$(document).off("mouseenter.feedback mouseleave.feedback",".feedback-helper"),$(document).off("mouseup.feedback keyup.feedback"),$(document).off("mousedown.feedback",".feedback-setblackout"),$(document).off("mousedown.feedback",".feedback-sethighlight"),$(document).off("mousedown.feedback click.feedback","#feedback-close"),$(document).off("mousedown.feedback","#feedback-canvas"),$(document).off("click.feedback","#feedback-highlighter-next"),$(document).off("click.feedback","#feedback-highlighter-back"),$(document).off("click.feedback","#feedback-welcome-next"),$(document).off("click.feedback","#feedback-overview-back"),$(document).off("mouseleave.feedback","body"),$(document).off("mouseenter.feedback",".feedback-helper"),$(document).off("selectstart.feedback dragstart.feedback"),$("#feedback-module").off("click.feedback",".feedback-wizard-close,.feedback-close-btn"),$(document).off("click.feedback","#feedback-submit"),settings.highlightElement&&($(document).off("click.feedback","#feedback-canvas"),$(document).off("mousemove.feedback","#feedback-canvas")),$('[data-highlighted="true"]').removeAttr("data-highlight-id").removeAttr("data-highlighted"),$("#feedback-module").remove(),$(".feedback-btn").show(),settings.onClose.call(this)}function redraw(ctx,border){border=void 0===border||border,ctx.clearRect(0,0,$("#feedback-canvas").width(),$("#feedback-canvas").height()),ctx.fillStyle="rgba(102,102,102,0.5)",ctx.fillRect(0,0,$("#feedback-canvas").width(),$("#feedback-canvas").height()),$(".feedback-helper").each((function(){"highlight"==$(this).attr("data-type")&&border&&drawlines(ctx,parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height())})),$(".feedback-helper").each((function(){"highlight"==$(this).attr("data-type")&&ctx.clearRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height())})),$(".feedback-helper").each((function(){"blackout"==$(this).attr("data-type")&&(ctx.fillStyle="rgba(0,0,0,1)",ctx.fillRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height()))}))}function drawlines(ctx,x,y,w,h){ctx.strokeStyle=settings.strokeStyle,ctx.shadowColor=settings.shadowColor,ctx.shadowOffsetX=settings.shadowOffsetX,ctx.shadowOffsetY=settings.shadowOffsetY,ctx.shadowBlur=settings.shadowBlur,ctx.lineJoin=settings.lineJoin,ctx.lineWidth=settings.lineWidth,ctx.strokeRect(x,y,w,h),ctx.shadowOffsetX=0,ctx.shadowOffsetY=0,ctx.shadowBlur=0,ctx.lineWidth=1}function validateFeedbackEmail(sEmail){return!!sEmail.match(/^(?:[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+\.)*[\w\!\#\$\%\&\'\*\+\-\/\=\?\^\`\{\|\}\~]+@(?:(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!\.)){0,61}[a-zA-Z0-9]?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9\-](?!$)){0,61}[a-zA-Z0-9]?)|(?:\[(?:(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\.){3}(?:[01]?\d{1,2}|2[0-4]\d|25[0-5])\]))$/)}supportedBrowser&&(isFeedbackButtonNative&&$("body").append('<button class="feedback-btn feedback-btn-gray feedback-btn-native">'+settings.initButtonText+"</button>"),$(document).on("click.feedback",settings.feedbackButton,(function(){settings.onTrigger.call(this),isFeedbackButtonNative&&$(this).hide(),_html2canvas||$.getScript(settings.html2canvasURL,(function(){_html2canvas=!0}));var canDraw=!1,img="",h=$(document).height(),w=$(document).width(),tpl='<div id="feedback-module">';settings.initialBox&&(tpl+=settings.tpl.description),tpl+=settings.tpl.highlighter+settings.tpl.overview+'<canvas id="feedback-canvas"></canvas><div id="feedback-helpers"></div><input id="feedback-note" name="feedback-note" type="hidden"></div>',$("body").append(tpl);var canvasAttr={width:w,height:h};$("#feedback-module").css({position:"absolute",left:"0px",top:"0px"}),$("#feedback-canvas").attr(canvasAttr).css("z-index","30000"),settings.initialBox||($("#feedback-highlighter-back").remove(),canDraw=!0,$("#feedback-canvas").css("cursor","crosshair"),$("#feedback-helpers").show(),$("#feedback-welcome").hide(),$("#feedback-highlighter").show()),settings.isDraggable&&$("#feedback-highlighter").on("mousedown.feedback",(function(e){var $d=$(this).addClass("feedback-draggable"),drag_h=$d.outerHeight(),drag_w=$d.outerWidth(),pos_y=$d.offset().top+drag_h-e.pageY,pos_x=$d.offset().left+drag_w-e.pageX;$d.css("z-index",4e4).parents().on("mousemove.feedback",(function(e){_top=e.pageY+pos_y-drag_h,_left=e.pageX+pos_x-drag_w,_bottom=drag_h-e.pageY,_right=drag_w-e.pageX,_left<0&&(_left=0),_top<0&&(_top=0),_right>$(window).width()&&(_left=$(window).width()-drag_w),_left>$(window).width()-drag_w&&(_left=$(window).width()-drag_w),_bottom>$(document).height()&&(_top=$(document).height()-drag_h),_top>$(document).height()-drag_h&&(_top=$(document).height()-drag_h),$(".feedback-draggable").offset({top:_top,left:_left}).on("mouseup",(function(){$(this).removeClass("feedback-draggable")}))})),e.preventDefault()})).on("mouseup.feedback",(function(){$(this).removeClass("feedback-draggable"),$(this).parents().off("mousemove mousedown")}));var ctx=$("#feedback-canvas")[0].getContext("2d");if(ctx.fillStyle="rgba(102,102,102,0.5)",ctx.fillRect(0,0,$("#feedback-canvas").width(),$("#feedback-canvas").height()),rect={},drag=!1,highlight=0,post={},settings.postBrowserInfo&&(post.browser={},post.browser.appCodeName=navigator.appCodeName,post.browser.appName=navigator.appName,post.browser.appVersion=navigator.appVersion,post.browser.cookieEnabled=navigator.cookieEnabled,post.browser.onLine=navigator.onLine,post.browser.platform=navigator.platform,post.browser.userAgent=navigator.userAgent,post.browser.plugins=[],$.each(navigator.plugins,(function(i){post.browser.plugins.push(navigator.plugins[i].name)})),$("#feedback-browser-info").show()),settings.postURL&&(post.url=document.URL,$("#feedback-page-info").show()),settings.postHTML&&(post.html=$("html").html(),$("#feedback-page-structure").show()),settings.postBrowserInfo||settings.postURL||settings.postHTML||$("#feedback-additional-none").show(),$(document).on("mousedown.feedback","#feedback-canvas",(function(e){canDraw&&(rect.startX=e.pageX-$(this).offset().left,rect.startY=e.pageY-$(this).offset().top,rect.w=0,rect.h=0,drag=!0)})),$(document).on("mouseup.feedback",(function(){if(canDraw){drag=!1;var dtop=rect.startY,dleft=rect.startX,dwidth=rect.w,dheight=rect.h;if(dtype="highlight",0==dwidth||0==dheight)return;dwidth<0&&(dleft+=dwidth,dwidth*=-1),dheight<0&&(dtop+=dheight,dheight*=-1),dtop+dheight>$(document).height()&&(dheight=$(document).height()-dtop),dleft+dwidth>$(document).width()&&(dwidth=$(document).width()-dleft),0==highlight&&(dtype="blackout"),$("#feedback-helpers").append('<div class="feedback-helper" data-type="'+dtype+'" data-time="'+Date.now()+'" style="position:absolute;top:'+dtop+"px;left:"+dleft+"px;width:"+dwidth+"px;height:"+dheight+'px;z-index:30000;"></div>'),redraw(ctx),rect.w=0}})),$(document).on("mousemove.feedback",(function(e){canDraw&&drag&&($("#feedback-highlighter").css("cursor","default"),rect.w=e.pageX-$("#feedback-canvas").offset().left-rect.startX,rect.h=e.pageY-$("#feedback-canvas").offset().top-rect.startY,ctx.clearRect(0,0,$("#feedback-canvas").width(),$("#feedback-canvas").height()),ctx.fillStyle="rgba(102,102,102,0.5)",ctx.fillRect(0,0,$("#feedback-canvas").width(),$("#feedback-canvas").height()),$(".feedback-helper").each((function(){"highlight"==$(this).attr("data-type")&&drawlines(ctx,parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height())})),1==highlight&&(drawlines(ctx,rect.startX,rect.startY,rect.w,rect.h),ctx.clearRect(rect.startX,rect.startY,rect.w,rect.h)),$(".feedback-helper").each((function(){"highlight"==$(this).attr("data-type")&&ctx.clearRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height())})),$(".feedback-helper").each((function(){"blackout"==$(this).attr("data-type")&&(ctx.fillStyle="rgba(0,0,0,1)",ctx.fillRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height()))})),0==highlight&&(ctx.fillStyle="rgba(0,0,0,0.5)",ctx.fillRect(rect.startX,rect.startY,rect.w,rect.h)))})),settings.highlightElement){var highlighted=[],tmpHighlighted=[],hidx=0;$(document).on("click.feedback","#feedback-canvas",(function(e){if(canDraw){redraw(ctx),tmpHighlighted=[],$("#feedback-canvas").css("cursor","crosshair"),$("* :not(body,script,iframe,div,section,.feedback-btn,#feedback-module *)").each((function(){"true"!==$(this).attr("data-highlighted")&&e.pageX>$(this).offset().left&&e.pageX<$(this).offset().left+$(this).width()&&e.pageY>$(this).offset().top+parseInt($(this).css("padding-top"),10)&&e.pageY<$(this).offset().top+$(this).height()+parseInt($(this).css("padding-top"),10)&&tmpHighlighted.push($(this))}));var $toHighlight=tmpHighlighted[tmpHighlighted.length-1];if($toHighlight&&!drag){$("#feedback-canvas").css("cursor","pointer");var _x=$toHighlight.offset().left-2,_y=$toHighlight.offset().top-2,_w=$toHighlight.width()+parseInt($toHighlight.css("padding-left"),10)+parseInt($toHighlight.css("padding-right"),10)+6,_h=$toHighlight.height()+parseInt($toHighlight.css("padding-top"),10)+parseInt($toHighlight.css("padding-bottom"),10)+6;1==highlight&&(drawlines(ctx,_x,_y,_w,_h),ctx.clearRect(_x,_y,_w,_h),dtype="highlight"),$(".feedback-helper").each((function(){"highlight"==$(this).attr("data-type")&&ctx.clearRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height())})),0==highlight&&(dtype="blackout",ctx.fillStyle="rgba(0,0,0,0.5)",ctx.fillRect(_x,_y,_w,_h)),$(".feedback-helper").each((function(){"blackout"==$(this).attr("data-type")&&(ctx.fillStyle="rgba(0,0,0,1)",ctx.fillRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height()))})),"click"==e.type&&e.pageX==rect.startX&&e.pageY==rect.startY&&($("#feedback-helpers").append('<div class="feedback-helper" data-highlight-id="'+hidx+'" data-type="'+dtype+'" data-time="'+Date.now()+'" style="position:absolute;top:'+_y+"px;left:"+_x+"px;width:"+_w+"px;height:"+_h+'px;z-index:30000;"></div>'),highlighted.push(hidx),++hidx,redraw(ctx))}}}))}$(document).on("mouseleave.feedback","body,#feedback-canvas",(function(){redraw(ctx)})),$(document).on("mouseenter.feedback",".feedback-helper",(function(){redraw(ctx)})),$(document).on("click.feedback","#feedback-welcome-next",(function(){$("#feedback-note").val().length>0?(canDraw=!0,$("#feedback-canvas").css("cursor","crosshair"),$("#feedback-helpers").show(),$("#feedback-welcome").hide(),$("#feedback-highlighter").show()):$("#feedback-welcome-error").show()})),$(document).on("mouseenter.feedback mouseleave.feedback",".feedback-helper",(function(e){drag||(rect.w=0,rect.h=0,"mouseenter"===e.type?($(this).css("z-index","30001"),$(this).append('<div class="feedback-helper-inner" style="width:'+($(this).width()-2)+"px;height:"+($(this).height()-2)+'px;position:absolute;margin:1px;"></div>'),$(this).append('<div id="feedback-close"></div>'),$(this).find("#feedback-close").css({top:$(this).find("#feedback-close").height()/2*-1+"px",left:$(this).width()-$(this).find("#feedback-close").width()/2+"px"}),"blackout"==$(this).attr("data-type")&&(ctx.clearRect(0,0,$("#feedback-canvas").width(),$("#feedback-canvas").height()),ctx.fillStyle="rgba(102,102,102,0.5)",ctx.fillRect(0,0,$("#feedback-canvas").width(),$("#feedback-canvas").height()),$(".feedback-helper").each((function(){"highlight"==$(this).attr("data-type")&&drawlines(ctx,parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height())})),$(".feedback-helper").each((function(){"highlight"==$(this).attr("data-type")&&ctx.clearRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height())})),ctx.clearRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height()),ctx.fillStyle="rgba(0,0,0,0.75)",ctx.fillRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height()),ignore=$(this).attr("data-time"),$(".feedback-helper").each((function(){if($(this).attr("data-time")==ignore)return!0;"blackout"==$(this).attr("data-type")&&(ctx.fillStyle="rgba(0,0,0,1)",ctx.fillRect(parseInt($(this).css("left"),10),parseInt($(this).css("top"),10),$(this).width(),$(this).height()))})))):($(this).css("z-index","30000"),$(this).children().remove(),"blackout"==$(this).attr("data-type")&&redraw(ctx)))})),$(document).on("click.feedback","#feedback-close",(function(){if(settings.highlightElement&&$(this).parent().attr("data-highlight-id"))var _hidx=$(this).parent().attr("data-highlight-id");$(this).parent().remove(),settings.highlightElement&&_hidx&&$('[data-highlight-id="'+_hidx+'"]').removeAttr("data-highlighted").removeAttr("data-highlight-id"),redraw(ctx)})),$("#feedback-module").on("click.feedback",".feedback-wizard-close,.feedback-close-btn",(function(){close()})),$(document).on("keyup.feedback",(function(e){27==e.keyCode&&close()})),$(document).on("selectstart.feedback dragstart.feedback",(function(e){e.preventDefault()})),$(document).on("click.feedback","#feedback-highlighter-back",(function(){canDraw=!1,$("#feedback-canvas").css("cursor","default"),$("#feedback-helpers").hide(),$("#feedback-highlighter").hide(),$("#feedback-welcome-error").hide(),$("#feedback-welcome").show()})),$(document).on("mousedown.feedback",".feedback-sethighlight",(function(){highlight=1,$(this).addClass("feedback-active"),$(".feedback-setblackout").removeClass("feedback-active")})),$(document).on("mousedown.feedback",".feedback-setblackout",(function(){highlight=0,$(this).addClass("feedback-active"),$(".feedback-sethighlight").removeClass("feedback-active")})),$(document).on("click.feedback","#feedback-highlighter-next",(function(){canDraw=!1,$("#feedback-canvas").css("cursor","default");var sy=$(document).scrollTop(),dh=$(window).height();$("#feedback-helpers").hide(),$("#feedback-highlighter").hide(),$("#feedback-loading-icon").show(),settings.screenshotStroke||redraw(ctx,!1),html2canvas($("body"),{onrendered:function(canvas){settings.screenshotStroke||redraw(ctx),_canvas=$('<canvas id="feedback-canvas-tmp" width="'+w+'" height="'+dh+'"/>').hide().appendTo("body"),_ctx=_canvas.get(0).getContext("2d"),_ctx.drawImage(canvas,0,sy,w,dh,0,0,w,dh),img=_canvas.get(0).toDataURL(),$(document).scrollTop(sy),post.img=img,settings.onScreenshotTaken(post.img),settings.showDescriptionModal?($("#feedback-canvas-tmp").remove(),$("#feedback-loading-icon").hide(),$("#feedback-overview").show(),$("#feedback-overview-description-text>textarea").remove(),$("#feedback-overview-screenshot>img").remove(),$('<textarea class="form-control" id="feedback-overview-note">'+$("#feedback-note").val()+"</textarea>").insertAfter("#feedback-overview-description-text h3:eq(0)"),$("#feedback-overview-screenshot").append('<img class="feedback-screenshot border-0" src="'+img+'" />')):($("#feedback-module").remove(),close(),_canvas.remove())},proxy:settings.proxy,letterRendering:settings.letterRendering})})),$(document).on("click.feedback","#feedback-skiphighlighter-next",(function(){canDraw=!1,$("#feedback-canvas").css("cursor","default"),img="",post.img="",$("#feedback-helpers").hide(),$("#feedback-highlighter").hide(),$("#feedback-loading-icon").show(),$("#feedback-canvas-tmp").remove(),$("#feedback-loading-icon").hide(),$("#feedback-overview").show(),$("#feedback-overview-description-text>textarea").remove(),$("#feedback-overview-screenshot>img").remove(),$('<textarea class="form-control" id="feedback-overview-note">'+$("#feedback-note").val()+"</textarea>").insertAfter("#feedback-overview-description-text h3:eq(0)"),$("#feedback-overview-screenshot").append('<img class="feedback-screenshot border-0" src="'+M.util.image_url("no_screenshot","theme_remui")+'" />')})),$(document).on("click.feedback","#feedback-overview-back",(function(){canDraw=!0,$("#feedback-canvas").css("cursor","crosshair"),$("#feedback-overview").hide(),$("#feedback-helpers").show(),$("#feedback-highlighter").show(),$("#feedback-overview-error").hide(),$("#feedback-email-error").hide()})),$(document).on("keyup.feedback","#feedback-note-tmp,#feedback-overview-note",(function(e){var tx;"feedback-note-tmp"===e.target.id?tx=$("#feedback-note-tmp").val():(tx=$("#feedback-overview-note").val(),$("#feedback-note-tmp").val(tx)),$("#feedback-note").val(tx)})),$(document).on("click.feedback","#feedback-submit",(function(){(canDraw=!1,$("#feedback-overview-error").hide(),$("#feedback-email-error").hide(),$("#feedback-note").val().length>0&&!1!==validateFeedbackEmail($("#feedback_person_email_id_field").val()))?($("#feedback-submit-success,#feedback-submit-error").remove(),$("#feedback-overview").hide(),$("#feedback-module").append(settings.tpl.submitLoading),post.img=img,post.note=$("#feedback-note").val(),post.customer_email=$("#feedback_person_email_id_field").val(),Ajax.call([{methodname:settings.ajaxURL,args:{feedbackdata:JSON.stringify(post)}}])[0].done((function(response){if(0!=response&&response>0){var success='<div id="feedback-submit-success"><div class="feedback-logo">Feedback</div><p>Thank you for your feedback. We value every piece of feedback we receive.</p>';success+="<p><b>Feedback Reference ID : "+response+" </b></p>",success+='<button class="feedback-close-btn feedback-btn-blue">OK</button><div class="feedback-wizard-close"></div></div>',$("#feedback-module").append(success)}else $("#feedback-module").append(settings.tpl.submitError)})).fail((function(){$("#feedback-module").append(settings.tpl.submitError)}))):($("#feedback-note").val().length<=0&&$("#feedback-overview-error").show(),!1===validateFeedbackEmail($("#feedback_person_email_id_field").val())&&$("#feedback-email-error").show())}))})))}}));

//# sourceMappingURL=feedback.min.js.map