<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_remui
 * @copyright (c) 2023 WisdmLabs (https://wisdmlabs.com/) <support@wisdmlabs.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();




$string['advancedsettings'] = 'Configurações avançadas';
$string['backgroundimage'] = 'Imagem de fundo';
$string['backgroundimage_desc'] = 'A imagem para exibir como plano de fundo do site. A imagem de fundo que você carrega aqui substituirá a imagem de fundo nos arquivos de tema predefinidos.';
$string['brandcolor'] = 'Cor da marca';
$string['brandcolor_desc'] = 'A cor da marca.';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'Um bootswatch é um conjunto de variáveis e css do Bootstrap para estilizar o Bootstrap.';
$string['choosereadme'] = 'Edwiser RemUI é um tema personalizável para Moodle, projetado para aprimorar sua experiência de eLearning, abordando desafios como personalização limitada e problemas de interface do usuário. Com seu design moderno e intuitivo e recursos abrangentes, você pode facilmente criar um site visualmente impressionante e personalizado que aumente o engajamento dos alunos e ofereça uma experiência que os alunos irão adorar!';
$string['currentinparentheses'] = '(atual)';
$string['configtitle'] = 'Edwiser RemUI';
$string['generalsettings'] = 'básico';
$string['loginbackgroundimage'] = 'Imagem de fundo da página de login';
$string['loginbackgroundimage_desc'] = 'A imagem para exibir como plano de fundo da página de login.';
$string['nobootswatch'] = 'Nenhum';
$string['pluginname'] = 'Edwiser RemUI';
$string['presetfiles'] = 'Arquivos predefinidos adicionais do tema';
$string['presetfiles_desc'] = 'Os arquivos predefinidos podem ser usados para alterar drasticamente a aparência do tema. Consulte <a href="https://docs.moodle.org/dev/remui_Presets">predefinições remui</a> para obter informações sobre como criar e compartilhar seus próprios arquivos predefinidos e consulte o <a href="https://archive.moodle.net/remui">Repositório de predefinições</a> para predefinições que outros compartilharam.';
$string['preset'] = 'Predefinição de tema';
$string['preset_desc'] = 'Escolha uma predefinição para alterar amplamente a aparência do tema.';
$string['privacy:metadata'] = 'O tema remui não armazena nenhum dado pessoal sobre o usuário.';
$string['rawscss'] = 'SCSS bruto';
$string['rawscss_desc'] = 'Use este campo para fornecer código SCSS ou CSS que será injetado no final da folha de estilos.';
$string['rawscsspre'] = 'SCSS inicial bruto';
$string['rawscsspre_desc'] = 'Neste campo, você pode fornecer código SCSS de inicialização, que será injetado antes de tudo o mais. Na maioria das vezes, você usará essa configuração para definir variáveis.';
$string['region-side-pre'] = 'Direita';
$string['region-side-top'] = 'Topo';
$string['region-side-bottom'] = 'Fundo';
$string['showfooter'] = 'Mostrar rodapé';
$string['unaddableblocks'] = 'Blocos desnecessários';
$string['unaddableblocks_desc'] = 'Os blocos especificados não são necessários ao usar este tema e não serão listados no menu Adicionar bloco.';
$string['privacy:metadata:preference:draweropenblock'] = 'A preferência do usuário para ocultar ou mostrar a gaveta com blocos.';
$string['privacy:metadata:preference:draweropenindex'] = 'A preferência do usuário para ocultar ou mostrar a gaveta com o índice do curso.';
$string['privacy:metadata:preference:draweropennav'] = 'A preferência do usuário para ocultar ou mostrar a navegação do menu da gaveta.';
$string['privacy:drawerindexclosed'] = 'A preferência atual para a gaveta do índice está fechada.';
$string['privacy:drawerindexopen'] = 'A preferência atual para a gaveta do índice está aberta.';
$string['privacy:drawerblockclosed'] = 'A preferência atual para a gaveta do bloco está fechada.';
$string['privacy:drawerblockopen'] = 'A preferência atual para a gaveta do bloco está aberta.';
$string['privacy:drawernavclosed'] = 'A preferência atual para a gaveta de navegação está fechada.';
$string['privacy:drawernavopen'] = 'A preferência atual para a gaveta de navegação está aberta.';

// Deprecated since Moodle 4.0.
$string['totop'] = 'Subir para o início';

// Edwiser RemUI Settings Page Strings.

// Settings Tabs strings.
$string['homepagesettings'] = 'Início';
$string['coursesettings'] = "Cursos";
$string['footersettings'] = 'Rodapé';
$string["formsettings"] = "Formulários";
$string["iconsettings"] = "Ícones";
$string['loginsettings'] = 'Login';

$string['versionforheading'] = '<span class="small remuiversion"> Version {$a}</span>';
$string['themeversionforinfo'] = '<span>Versão: Edwiser RemUI v{$a}</span>';

// General Settings.
$string['mergemessagingsidebar'] = 'Unir painel de mensagens';
$string['mergemessagingsidebardesc'] = 'Unir o painel de mensagens na barra lateral direita';
$string['logoorsitename'] = 'Escolher formato do logotipo do site';
$string['logoorsitenamedesc'] = 'Somente logotipo - Grande logotipo da marca<br /> Logotipo Mini - Mini logotipo da marca<br /> Somente ícone - Um ícone como marca<br/> Ícone e nome do site - Ícone com nome do site';
$string['onlylogo'] = 'Somente logotipo';
$string['logo'] = 'Logotipo';
$string['logomini'] = 'Logotipo Mini';
$string['icononly'] = 'Somente ícone';
$string['iconsitename'] = 'Ícone e nome do site';
$string['logodesc'] = 'Você pode adicionar o logotipo a ser exibido no cabeçalho. Nota - A altura preferida é de 50px. Caso deseje personalizar, você pode fazê-lo na caixa de CSS personalizado.';
$string['logominidesc'] = 'Você pode adicionar o logotipo mini para ser exibido no cabeçalho quando a barra lateral estiver recolhida. Nota - A altura preferida é de 50px. Caso deseje personalizar, você pode fazê-lo na caixa de CSS personalizado.';
$string['siteicon'] = 'Ícone do site';
$string['siteicondesc'] = 'Não tem um logotipo? Você pode escolher um a partir desta <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new" ><b style="color:#17a2b8!important">lista</b></a>. <br /> Basta inserir o texto após "fa-".';
$string['navlogin_popup'] = 'Habilitar popup de login';
$string['navlogin_popupdesc'] = 'Habilitar popup de login para fazer login rapidamente sem redirecionar para a página de login.';
$string['coursecategories'] = 'Categorias';
$string['enablecoursecategorymenu'] = "Menu suspenso de categoria no cabeçalho";
$string['enablecoursecategorymenudesc'] = "Mantenha isso habilitado se você quiser exibir o menu suspenso de categorias no cabeçalho.";
$string['coursepagesettings'] = "Página do Curso";
$string['coursepagesettingsdesc'] = "Configurações relacionadas a cursos.";
$string['coursecategoriestext'] = "Renomear menu suspenso de categoria no cabeçalho";
$string['coursecategoriestextdesc'] = "Você pode adicionar um nome personalizado para o menu suspenso de categorias no cabeçalho.";
$string['enablerecentcourses'] = 'Habilitar cursos recentes';
$string['enablerecentcoursesdesc'] = 'Se habilitado, o menu suspenso de cursos recentes será exibido no cabeçalho.';
$string['recent'] = 'Recentes';
$string['recentcoursesmenu'] = 'Menu de Cursos Recentes';
$string['searchcatplaceholdertext'] = 'Pesquisar categorias';
$string['viewallnotifications'] = 'Ver todas as notificações';
$string['forgotpassword'] = 'Esqueceu a senha?';
$string['enableannouncement'] = "Ativar Anúncio em Todo o Site";
$string['enableannouncementdesc'] = "Ativar anúncio em todo o site para todos os usuários.";
$string['enabledismissannouncement'] = "Ativar Anúncio Dispensável em Todo o Site";
$string['enabledismissannouncementdesc'] = "Se ativado, permitir que os usuários descartem o anúncio.";
$string['brandlogo'] = 'Logo da Marca';
$string['brandname'] = 'Nome da Marca';

$string['announcementtext'] = "Anúncio";
$string['announcementtextdesc'] = "Mensagem de anúncio a ser exibida em todo o site.";
$string['announcementtype'] = "Tipo de Anúncio";
$string['announcementtypedesc'] = "Selecione o tipo de anúncio para exibir uma cor de fundo diferente para o anúncio.";
$string['typeinfo'] = "Informação";
$string['typedanger'] = "Urgente";
$string['typewarning'] = "Aviso";
$string['typesuccess'] = "Sucesso";

// Google Analytics.
$string['googleanalytics'] = 'ID de rastreamento do Google Analytics';
$string['googleanalyticsdesc'] = 'Digite o ID de rastreamento do Google Analytics para habilitar o analytics em seu site. O formato do ID de rastreamento deve ser como [UA-XXXXX-Y].<br/>Por favor, esteja ciente de que ao incluir essa configuração, você estará enviando dados ao Google Analytics e deve se certificar de que seus usuários sejam avisados sobre isso. Nosso produto não armazena nenhum dos dados sendo enviados para o Google Analytics.';
$string['favicon'] = 'Favicon';
$string['favicosize'] = 'O tamanho esperado é de 16x16 pixels';
$string['favicondesc'] = 'O "ícone favorito" do seu site. É um lembrete visual da identidade do site e é exibido na barra de endereço ou nas abas do navegador.';
$string['fontselect'] = 'Seletor de Tipo de Fonte';
$string['fontselectdesc'] = 'Escolha entre fontes Padrão ou tipos de <a href="https://fonts.google.com/" target="_new">fontes da web do Google</a>. Por favor, salve para mostrar as opções da sua escolha. Nota: Se a fonte do personalizador visual estiver definida como Padrão, então a fonte da web do Google será aplicada.';
$string['fontname'] = 'Fonte do Site';
$string['fontnamedesc'] = 'Digite o nome exato da fonte a ser usada para o Moodle.';
$string['fonttypestandard'] = 'Fonte padrão';
$string['fonttypegoogle'] = 'Fonte da Web do Google';

$string['sendfeedback'] = "Enviar feedback para Edwiser";
$string['enableedwfeedback'] = "Feedback e Suporte Edwiser";
$string['enableedwfeedbackdesc'] = "Ativar Feedback e Suporte Edwiser, visível apenas para administradores.";
$string["checkfaq"] = "Edwiser RemUI - Verificar FAQ";
$string['poweredbyedwiser'] = 'Desenvolvido por Edwiser';
$string['poweredbyedwiserdesc'] = 'Desmarque para remover "Desenvolvido por Edwiser" do seu site.';
$string['enabledictionary'] = 'Ativar Dicionário';
$string['enabledictionarydesc'] = 'Se ativado, o recurso de dicionário será ativado e mostrará o significado do texto selecionado em uma janela pop-up.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Você pode personalizar o CSS a partir da caixa de texto acima. As alterações serão refletidas em todas as páginas do seu site.';
// Conteúdo do rodapé.
$string['followus'] = 'Siga-nos';
$string['poweredby'] = 'Desenvolvido por';

// Relatar um bug/feedback com um clique.
$string['sendfeedback'] = "Enviar feedback para Edwiser";
$string['descriptionmodal_text1'] = "<p>O feedback permite enviar sugestões sobre nossos produtos. Recebemos relatos de problemas, ideias de recursos e comentários em geral.</p><p>Comece escrevendo uma breve descrição:</p>";
$string['descriptionmodal_text2'] = "<p>Em seguida, permitiremos que você identifique áreas da página relacionadas à sua descrição.</p>";
$string['emptydescription_error'] = "Por favor, insira uma descrição.";
$string['incorrectemail_error'] = "Por favor, insira um e-mail válido.";

$string['highlightmodal_text1'] = "Clique e arraste na página para nos ajudar a entender melhor seu feedback. Você pode mover essa caixa de diálogo se ela estiver no caminho.";
$string['highlight_button'] = "Destacar área";
$string['blackout_button'] = "Ocultar informações";
$string['highlight_button_tooltip'] = "Destacar áreas relevantes para o seu feedback.";
$string['blackout_button_tooltip'] = "Ocultar qualquer informação pessoal.";

$string['feedbackmodal_next'] = 'Tirar captura de tela e continuar';
$string['feedbackmodal_skipnext'] = 'Pular e continuar';
$string['feedbackmodal_previous'] = 'Voltar';
$string['feedbackmodal_submit'] = 'Enviar';
$string['feedbackmodal_ok'] = 'Ok';

$string['description_heading'] = 'Descrição';
$string['feedback_email_heading'] = 'E-mail';
$string['additional_info'] = 'Informações adicionais';
$string['additional_info_none'] = 'Nenhuma';
$string['additional_info_browser'] = 'Informações do navegador';
$string['additional_info_page'] = 'Informações da página';
$string['additional_info_pagestructure'] = 'Estrutura da página';
$string['feedback_screenshot'] = 'Captura de tela';
$string['feebdack_datacollected_desc'] = 'Uma visão geral dos dados coletados está disponível em <strong><a href="https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products" target="_blank">aqui</a></strong>.';

$string['submit_loading'] = 'Carregando...';
$string['submit_success'] = 'Obrigado';

$string['submit_error'] = 'Infelizmente ocorreu um erro ao enviar seu feedback. Por favor, tente novamente.';
$string['send_feedback_license_error'] = "Por favor, ative a licença para obter suporte do produto.";
$string['disabled'] = 'Desativado';

$string['nocoursefound'] = 'Nenhum curso encontrado';

$string['pagewidth'] = 'Layout do tema';
$string['pagewidthdesc'] = 'Aqui você pode escolher o tamanho do layout para as páginas.';
$string['defaultpermoodle'] = 'Largura estreita (padrão do Moodle)';
$string['fullwidthlayout'] = 'Largura total';

// Footer Page Settings.
$string['footersettings'] = 'Rodapé';
$string['socialmedia'] = 'Mídias sociais';
$string['socialmediadesc'] = 'Insira os links das suas redes sociais para o site.';
$string['facebooksetting'] = 'Facebook';
$string['facebooksettingdesc'] = 'Insira o link da página do Facebook do seu site. Por exemplo, https://www.facebook.com/nomedapagina';
$string['twittersetting'] = 'Twitter';
$string['twittersettingdesc'] = 'Insira o link da página do Twitter do seu site. Por exemplo, https://www.twitter.com/nomedapagina';
$string['linkedinsetting'] = 'Linkedin';
$string['linkedinsettingdesc'] = 'Insira o link da página do Linkedin do seu site. Por exemplo, https://www.linkedin.com/in/nomedapagina';
$string['gplussetting'] = 'Google Plus';
$string['gplussettingdesc'] = 'Insira o link da página do Google Plus do seu site. Por exemplo, https://plus.google.com/nomedapagina';
$string['youtubesetting'] = 'YouTube';
$string['youtubesettingdesc'] = 'Insira o link da página do YouTube do seu site. Por exemplo, https://www.youtube.com/channel/UCU1u6QtAAPJrV0v0_c2EISA';
$string['instagramsetting'] = 'Instagram';
$string['instagramsettingdesc'] = 'Insira o link da página do Instagram do seu site. Por exemplo, https://www.instagram.com/nome';
$string['pinterestsetting'] = 'Pinterest';
$string['pinterestsettingdesc'] = 'Insira o link da página do Pinterest do seu site. Por exemplo, https://www.pinterest.com/nome';
$string['quorasetting'] = 'Quora';
$string['quorasettingdesc'] = 'Insira o link da página do Quora do seu site. Por exemplo, https://www.quora.com/nome';
$string['footerbottomtext'] = 'Texto do rodapé inferior esquerdo';
$string['footerbottomlink'] = 'Link do rodapé inferior esquerdo';
$string['footerbottomlinkdesc'] = 'Insira o link para a seção inferior esquerda do rodapé. Por exemplo, http://www.suaempresa.com';
$string['footercolumn1heading'] = 'Conteúdo do rodapé para a 1ª coluna (esquerda)';
$string['footercolumn1headingdesc'] = 'Esta seção se relaciona à parte inferior (Coluna 1) da sua página inicial.';
$string['footercolumn1title'] = 'Título da 1ª coluna do rodapé';
$string['footercolumn1titledesc'] = 'Adicione um título a esta coluna.';
$string['footercolumncustomhtml'] = 'Conteúdo personalizado';
$string['footercolumn1customhtmldesc'] = 'Você pode personalizar o HTML desta coluna usando a caixa de texto acima.';
$string['footercolumn2heading'] = 'Conteúdo do Rodapé para a 2ª Coluna (Meio)';
$string['footercolumn2headingdesc'] = 'Esta seção se refere à parte inferior (Coluna 2) da sua página inicial.';
$string['footercolumn2title'] = 'Título da 2ª Coluna do Rodapé';
$string['footercolumn2titledesc'] = 'Adicione um título a esta coluna.';
$string['footercolumn2customhtml'] = 'HTML Personalizado';
$string['footercolumn2customhtmldesc'] = 'Você pode personalizar o HTML desta coluna usando a caixa de texto acima.';
$string['footercolumn3heading'] = 'Conteúdo do Rodapé para a 3ª Coluna (Meio)';
$string['footercolumn3headingdesc'] = 'Esta seção se refere à parte inferior (Coluna 3) da sua página inicial.';
$string['footercolumn3title'] = 'Título da 3ª Coluna do Rodapé';
$string['footercolumn3titledesc'] = 'Adicione um título a esta coluna.';
$string['footercolumn3customhtml'] = 'HTML Personalizado';
$string['footercolumn3customhtmldesc'] = 'Você pode personalizar o HTML desta coluna usando a caixa de texto acima.';
$string['footercolumn4heading'] = 'Conteúdo do Rodapé para a 4ª Coluna (Direita)';
$string['footercolumn4headingdesc'] = 'Esta seção se refere à parte inferior (Coluna 4) da sua página inicial.';
$string['footercolumn4title'] = 'Título da 4ª Coluna do Rodapé';
$string['footercolumn4titledesc'] = 'Adicione um título a esta coluna.';
$string['footercolumn4customhtml'] = 'HTML Personalizado';
$string['footercolumn4customhtmldesc'] = 'Você pode personalizar o HTML desta coluna usando a caixa de texto acima.';
$string['footerbottomheading'] = 'Configurações do Rodapé Inferior';
$string['footerbottomdesc'] = 'Aqui você pode especificar seu próprio link que deseja inserir na seção inferior do rodapé';
$string['footerbottomtextdesc'] = 'Adicione um texto para as Configurações do Rodapé Inferior.';
$string['footercopyrightsshow'] = 'mostrar';
$string['footercopyright'] = 'Mostrar conteúdo dos direitos autorais';
$string['footercopyrights'] = '[site] © [ano]. Todos os direitos reservados.';
$string['footercopyrightsdesc'] = 'Adicione conteúdo dos direitos autorais na parte inferior da página.';
$string['footercopyrightstags'] = 'Tags:<br>[site] - Nome do site<br>[ano] - Ano atual';
$string['footerbottomlink'] = 'Link do Rodapé Inferior Esquerdo';
$string['footerbottomlinkdesc'] = 'Insira o link para a seção inferior esquerda do rodapé. Por exemplo, http://www.suaempresa.com.br';
$string['footerbottomtext'] = 'Texto do Rodapé Inferior Esquerdo';
$string['footerbottomlink'] = 'Link do Rodapé Inferior Esquerdo';
$string['footerbottomlinkdesc'] = 'Digite o link para a seção inferior esquerda do rodapé. Por exemplo, http://www.suaempresa.com';
$string['footerbottomtext'] = 'Texto Inferior Esquerdo do Rodapé';
$string['footerbottomlink'] = 'Link Inferior Esquerdo do Rodapé';
$string['copyrighttextarea'] = 'Conteúdo de Direitos Autorais';
$string['footercolumnsize'] = 'Número de widgets';
$string['one'] = 'Um';
$string['two'] = 'Dois';
$string['three'] = 'Três';
$string['four'] = 'Quatro';
$string['showsocialmediaicon'] = "Mostrar ícones de mídia social";
$string['footercolumntype'] = 'Tipo';
$string['footercolumncustommenudesc'] = 'Adicione seus itens de menu neste formato, por exemplo.<br><pre>[
    {
        "text": "Adicione seu Texto aqui",
        "address": "http://XYZ.abc"
    },
    {
        "text": "Adicione seu Texto aqui",
        "address": "http://XYZ.abc"
    }, ...
]</pre>
<b style="color:red;">Nota:</b> Para adicionar conteúdo facilmente ao rodapé, personalize a área do rodapé com nosso <a href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer" onclick= location.href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer";location.reload();>Personalizador Visual</a>';
$string['gotop'] = 'Ir para o topo';

$string['menu'] = 'Menu';
$string['content'] = 'Conteúdo';
$string['footercolumntypedesc'] = 'Você pode escolher o tipo de widget do rodapé';
$string['socialmediaicondesc'] = 'Isso mostrará ícones de mídia social nesta seção';
$string['footercolumncustommmenu'] = 'Adicionar itens de menu';
$string['follometext'] = 'Siga-me no {$a}';
$string['footercolumndesc'] = 'Selecione o número de widgets no rodapé';
$string['footershowlogo'] = 'Mostrar logotipo do rodapé';
$string['footershowlogodesc'] = 'Mostrar logotipo no rodapé secundário.';

$string['footertermsandconditionsshow'] = 'Mostrar Termos e Condições';
$string['footertermsandconditions'] = 'Link de Termos e Condições';
$string['footertermsandconditionsdesc'] = 'Você pode adicionar um link para a página de Termos e Condições.';
$string['footertermsandconditionsshowdesc'] = 'Rodapé Termos e Condições';
$string['footerprivacypolicyshowdesc'] = 'Link de Termos e Condições';

$string['footerprivacypolicyshow'] = 'Mostrar Política de Privacidade';
$string['footerprivacypolicy'] = 'Link da Política de Privacidade';
$string['footerprivacypolicydesc'] = 'Você pode adicionar um link para a página da Política de Privacidade.';
$string['termsandconditions'] = 'Termos e Condições';
$string['privacypolicy'] = 'Política de Privacidade';
$string['typeamessage'] = "Digite sua mensagem aqui";
$string['allcontacts'] = "Todos os Contatos";

// Página de Perfil.
$string['administrator'] = 'Administrador';
$string['contacts'] = 'Contatos';
$string['blogentries'] = 'Entradas do Blog';
$string['discussions'] = 'Discussões';
$string['aboutme'] = 'Sobre Mim';
$string['courses'] = 'Cursos';
$string['interests'] = 'Interesses';
$string['institution'] = 'Departamento e Instituição';
$string['location'] = 'Localização';
$string['description'] = 'Descrição';
$string['editprofile'] = 'Editar Perfil';
$string['start_date'] = 'Data de Início';
$string['complete'] = 'Concluído';
$string['surname'] = 'Sobrenome';
$string['actioncouldnotbeperformed'] = 'Ação não pôde ser realizada!';
$string['enterfirstname'] = 'Por favor, digite seu Primeiro Nome.';
$string['enterlastname'] = 'Por favor, digite seu Sobrenome.';
$string['enteremailid'] = 'Por favor, digite seu ID de Email.';
$string['enterproperemailid'] = 'Por favor, digite um ID de email válido.';
$string['detailssavedsuccessfully'] = 'Detalhes salvos com sucesso!';
$string['fullname'] = 'Nome Completo';
$string['viewcourselow'] = "ver curso";

$string['focusmodesettings'] = 'Configurações do Modo de Foco';
$string['focusmode'] = 'Modo de Foco';
$string['enablefocusmode'] = 'Habilitar Modo de Foco';
$string['enablefocusmodedesc'] = 'Se habilitado, um botão para alternar para o aprendizado sem distrações aparecerá na página do curso.';
$string['focusmodeenabled'] = 'Modo de Foco Habilitado';
$string['focusmodedisabled'] = 'Modo de Foco Desabilitado';
$string['coursedata'] = 'Dados do Curso';
$string['prev'] = 'Anterior';
$string['next'] = 'Próximo';
$string['enablecoursestats'] = 'Habilitar Estatísticas do Curso';
$string['enablecoursestatsdesc'] = 'Se habilitado, o administrador, gerentes e professores verão estatísticas do usuário relacionadas ao curso matriculado na página do Curso Único.';

// Course Stats.
$string['notenrolledanycourse'] = 'Não matriculado em nenhum curso.';
$string['enrolledusers'] = 'Alunos Matriculados';
$string['studentcompleted'] = 'Alunos que Concluíram';
$string['inprogress'] = 'Em Progresso';
$string['yettostart'] = 'Ainda não Iniciado';
$string['completepercent'] = '{$a}% do Curso Concluído';
$string['seeallmycourses'] = "<span class='d-none d-lg-block'>Ver todos os meus </span> <span>cursos em andamento</span>";
$string['noactivity'] = 'Nenhuma atividade no curso';
$string['activitydata'] = '{$a->complete} de {$a->total} atividades concluídas';

// Login Page Strings.
$string['loginsettingpic'] = 'Enviar Imagem de Fundo';
$string['loginsettingpicdesc'] = 'Enviar imagem como plano de fundo para formulário de login.';
$string['loginpagelayout'] = 'Posição do formulário de login';
$string['loginpagelayoutdesc'] = 'Escolha o design da página de login.';
$string['logincenter'] = 'Centralizado';
$string['loginleft'] = 'Lado Esquerdo';
$string['loginright'] = 'Lado Direito';
$string['brandlogopos'] = "Mostrar logo na página de login";
$string['brandlogoposdesc'] = "Se ativado, o logo da marca será exibido na página de login.";
$string['hiddenlogo'] = "Desativar";
$string['sidebarregionlogo'] = 'No cartão de login';
$string['maincontentregionlogo'] = 'Na região central';
$string['loginpanellogo'] = 'Logo do cabeçalho (página de login)';
$string['loginpanellogodesc'] = 'Depende da configuração <strong>Escolha o formato do logo do site</strong>';
$string['signuptextcolor'] = 'Cor do texto da descrição do site';
$string['signuptextcolordesc'] = 'Selecione a cor do texto para a descrição do site.';
$string['brandlogotext'] = "Descrição do site";
$string['brandlogotextdesc'] = "Adicione o texto para a descrição do site que será exibido na página de login e inscrição. Mantenha em branco se não quiser colocar nenhuma descrição.";
$string['createnewaccount'] = 'Criar uma nova conta';
$string['welcometobrand'] = 'Olá, Bem-vindo(a) a {$a}';
$string['entertologin'] = "Digite suas informações para fazer login em sua conta";
$string['forgotaccount'] = 'Esqueceu sua senha?';
$string['potentialidps'] = 'Ou faça login usando sua conta';
$string['firsttime'] = 'Primeira vez usando este site';
// Página de Inscrição.
$string['createnewaccount'] = 'Criar uma nova conta';
// Configurações da Página do Curso.
$string['coursesettings'] = "Página do Curso";
$string['enrolpagesettings'] = "Configurações da Página de Inscrição";
$string['enrolpagesettingsdesc'] = "Gerencie o conteúdo da página de inscrição aqui.";
$string['coursearchivepagesettings'] = 'Configurações da Página do Arquivo de Curso';
$string['coursearchivepagesettingsdesc'] = 'Gerencie o layout e conteúdo da página do arquivo de curso.';
$string['courseperpage'] = 'Cursos por página';
$string['courseperpagedesc'] = "<strong>Visualização 'Grade' do curso:</strong> Ao selecionar o número de cartões de curso nas configurações acima, a página de arquivo do curso se ajustará automaticamente, organizando os cartões em linhas geradas dinamicamente.<br>
<strong style='display: inline-block;margin-top: 8px;'>Visualização 'Lista e Resumo' do curso:</strong> Os cursos serão exibidos de acordo com a seleção feita nas configurações acima.";
$string['none'] = 'Nenhum';
$string['fade'] = 'Desvanecer';
$string['slide-top'] = 'Deslizar para cima';
$string['slide-bottom'] = 'Deslizar para baixo';
$string['slide-right'] = 'Deslizar para a direita';
$string['scale-up'] = 'Aumentar escala';
$string['scale-down'] = 'Diminuir escala';
$string['courseanimation'] = 'Animação do cartão do curso';
$string['courseanimationdesc'] = 'Selecione a animação do cartão do curso a aparecer na página do arquivo de curso';

$string['currency'] = 'USD';
$string['currency_symbol'] = '$';
$string['enrolment_payment'] = 'Exibir rótulo \'GRÁTIS\' em cursos com custo de inscrição \'0\'';
$string['enrolment_payment_desc'] = 'Essa configuração decide se um rótulo "GRÁTIS" aparece para cursos sem taxas de inscrição. Se definido como "Não", o rótulo não aparecerá na página de inscrição.';
$string['allrequirepayment'] = 'Não';
$string['somearefree'] = 'Sim';
$string['allarefree'] = 'Todos os cursos são gratuitos';

$string['showcoursepricing'] = 'Mostrar Preços do Curso';
$string['showcoursepricingdesc'] = 'Ative essa configuração para mostrar a seção de preços na página de inscrição.';
$string['fullwidthcourseheader'] = 'Cabeçalho do Curso em Largura Total';
$string['fullwidthcourseheaderdesc'] = 'Ative essa configuração para deixar o cabeçalho do curso em largura total.';

$string['price'] = 'Preço';
$string['course_free'] = 'GRÁTIS';
$string['enrolnow'] = 'Agora {$a}';
$string['buyand'] = 'Comprar e';
$string['notags'] = 'Sem Tags.';
$string['tags'] = 'Tags';

$string['enrolment_layout'] = 'Layout da Página de Inscrição';
$string['enrolment_layout_desc'] = 'Ative o Layout Edwiser para um novo e melhorado design da página de inscrição.';
$string['disable'] = 'Desativar';
$string['defaultlayout'] = 'Layout Padrão do Moodle';
$string['enable_layout1'] = 'Layout Edwiser';

$string['webpage'] = "Página da Web";
$string['categorypagelayout'] = 'Layout da Página de Arquivo de Cursos';
$string['categorypagelayoutdesc'] = 'Selecione entre os layouts de página de arquivo de cursos.';
$string['edwiserlayout'] = 'Layout Edwiser';
$string['categoryfilter'] = 'Filtro de Categoria';

$string['skill0'] = 'Sem etiqueta';
$string['skill1'] = 'Iniciante';
$string['skill2'] = 'Intermediário';
$string['skill3'] = 'Avançado';

$string['lastupdatedon'] = 'Última Atualização Em ';

$string['courseoverview'] = "Visão Geral do Curso";
$string['coursecontent'] = "Conteúdo do Curso";
$string['instructors'] = "Instrutores";
$string['reviews'] = "Avaliações";
$string['curatedby'] = 'Instrutores';
$string["studentsenrolled"] = 'Alunos Matriculados';
$string['lesson'] = 'Lições';
$string['category'] = 'Categoria';
$string['review'] = 'Avaliação';
$string['length'] = 'Duração';
$string['lecture'] = 'Palestra';
$string['startdate'] = 'Data de Início';
$string['skilllevel'] = 'Nível de Habilidade';
$string['language'] = 'Idioma';
$string['certificate'] = 'Certificado';
$string['students'] = 'Alunos';
$string['courses'] = 'Cursos';

// Arquivo do curso.
$string['cachedef_courses'] = 'Cache para cursos';
$string['cachedef_guestcourses'] = 'Cache para cursos de visitantes';
$string['cachedef_updates'] = 'Cache para atualizações';
$string['mycourses'] = "Meus cursos";
$string['allcategories'] = 'Todas as categorias';
$string['categorysort'] = 'Ordenar categorias';
$string['sortdefault'] = 'Ordem (nenhum)';
$string['sortascending'] = 'A a Z';
$string['sortdescending'] = 'Z a A';

// Antiga string da página inicial.
// Configurações da página inicial.
$string['homepagesettings'] = 'Página inicial';
$string['frontpagedesign'] = 'Design da página inicial';
$string['frontpagedesigndesc'] = 'Ative o construtor Legacy ou Edwiser RemUI Homepage';
$string['frontpagechooser'] = 'Escolha o design da página inicial';
$string['frontpagechooserdesc'] = 'Escolha o design da sua página inicial.';
$string['frontpagedesignold'] = 'Construtor da página inicial antiga';
$string['frontpagedesignolddesc'] = 'Painel padrão como anterior.';
$string['frontpagedesignnew'] = 'Novo design';
$string['frontpagedesignnewdesc'] = 'Novo design com várias seções. Você pode configurar as seções individualmente na página inicial.';
$string['newhomepagedescription'] = 'Clique em "Site Home" na barra de navegação para ir para "Construtor da página inicial" e crie sua própria página inicial';
$string['frontpageloader'] = 'Carregador de imagem para a página inicial';
$string['frontpageloaderdesc'] = 'Isso substitui o carregador padrão pela sua imagem';
$string['frontpageimagecontent'] = 'Conteúdo do cabeçalho';
$string['frontpageimagecontentdesc'] = 'Esta seção se refere à parte superior da sua página inicial.';
$string['frontpageimagecontentstyle'] = 'Estilo';
$string['frontpageimagecontentstyledesc'] = 'Você pode escolher entre Estático e Slider.';
$string['staticcontent'] = 'Estático';
$string['slidercontent'] = 'Slider';
$string['addtext'] = 'Adicionar texto';
$string['defaultaddtext'] = 'A educação é um caminho testado pelo tempo para o progresso.';
$string['addtextdesc'] = 'Aqui você pode adicionar o texto a ser exibido na página inicial, preferencialmente em HTML.';
$string['uploadimage'] = 'Enviar imagem';
$string['uploadimagedesc'] = 'Você pode carregar uma imagem como conteúdo para slide';
$string['video'] = 'Código incorporado do iframe';
$string['videodesc'] = 'Aqui você pode inserir o código incorporado do iframe do vídeo que será incorporado.';
$string['contenttype'] = 'Selecionar tipo de conteúdo';
$string['contentdesc'] = 'Você pode escolher entre imagem ou fornecer URL de vídeo.';
$string['imageorvideo'] = 'Imagem/ Vídeo';
$string['image'] = 'Imagem';
$string['videourl'] = 'URL do vídeo';
$string['slideinterval'] = 'Intervalo do slide';
$string['slideintervalplaceholder'] = 'Número inteiro positivo em milissegundos.';
$string['slideintervaldesc'] = 'Você pode definir o tempo de transição entre os slides. Caso haja apenas um slide, essa opção não terá efeito. Se o intervalo for inválido (vazio|0|menor que 0), então o intervalo padrão será de 5000 milissegundos.';
$string['slidercount'] = 'Número de slides';
$string['slidercountdesc'] = '';
$string['one'] = '1';
$string['two'] = '2';
$string['three'] = '3';
$string['four'] = '4';
$string['five'] = '5';
$string['six'] = '6';
$string['eight'] = '8';
$string['nine'] = '9';
$string['twelve'] = '12';
$string['slideimage'] = 'Carregar imagens para o Slider';
$string['slideimagedesc'] = 'Você pode carregar uma imagem como conteúdo para este slide.';
$string['sliderurl'] = 'Adicionar link ao botão do Slider';
$string['slidertext'] = 'Adicionar texto ao Slider';
$string['defaultslidertext'] = '';
$string['slidertextdesc'] = 'Você pode inserir o conteúdo de texto para este slide. Preferencialmente em HTML.';
$string['sliderbuttontext'] = 'Adicionar texto ao botão do Slider';
$string['sliderbuttontextdesc'] = 'Você pode adicionar texto ao botão deste slide.';
$string['sliderurldesc'] = 'Você pode inserir o link da página para onde o usuário será redirecionado ao clicar no botão.';
$string['sliderautoplay'] = 'Definir autoplay do Slider';
$string['sliderautoplaydesc'] = 'Selecione "sim" se desejar transição automática em sua apresentação de slides.';
$string['true'] = 'Sim';
$string['false'] = 'Não';
$string['frontpageblocks'] = 'Conteúdo do Corpo';
$string['frontpageblocksdesc'] = 'Você pode inserir um título para o corpo do seu site.';
$string['frontpageblockdisplay'] = 'Seção Sobre Nós';
$string['frontpageblockdisplaydesc'] = 'Você pode mostrar ou ocultar a seção "Sobre Nós", também pode mostrar a seção "Sobre Nós" em formato de grade.';
$string['donotshowaboutus'] = 'Não Mostrar';
$string['showaboutusinrow'] = 'Mostrar seção em linha';
$string['showaboutusingridblock'] = 'Mostrar seção em bloco de grade';

// Sobre Nós.
$string['frontpageaboutus'] = 'Sobre Nós na página inicial';
$string['frontpageaboutusdesc'] = 'Esta seção é para a página inicial Sobre Nós.';
$string['frontpageaboutustitledesc'] = 'Adicionar título à seção Sobre Nós';
$string['frontpageaboutusbody'] = 'Descrição do corpo da seção Sobre Nós';
$string['frontpageaboutusbodydesc'] = 'Uma breve descrição sobre esta seção.';
$string['enablesectionbutton'] = 'Ativar botões nas seções';
$string['enablesectionbuttondesc'] = 'Ativar os botões nas seções do corpo.';
$string['sectionbuttontextdesc'] = 'Insira o texto para o botão nesta seção.';
$string['sectionbuttonlinkdesc'] = 'Insira o link URL para esta seção.';
$string['frontpageblocksectiondesc'] = 'Adicione um título a esta seção.';

// Seção de bloco 1.
$string['frontpageblocksection1'] = 'Título do corpo para a 1ª seção';
$string['frontpageblockdescriptionsection1'] = 'Descrição do corpo para a 1ª seção';
$string['frontpageblockiconsection1'] = 'Ícone Font-Awesome para a 1ª seção';
$string['sectionbuttontext1'] = 'Texto do botão para a 1ª seção';
$string['sectionbuttonlink1'] = 'Link URL para a 1ª seção';

// Seção de bloco 2.
$string['frontpageblocksection2'] = 'Título do corpo para a 2ª seção';
$string['frontpageblockdescriptionsection2'] = 'Descrição do corpo para a 2ª seção';
$string['frontpageblockiconsection2'] = 'Ícone Font-Awesome para a 2ª seção';
$string['sectionbuttontext2'] = 'Texto do botão para a 2ª seção';
$string['sectionbuttonlink2'] = 'Link URL para a 2ª seção';

// Seção de bloco 3.
$string['frontpageblocksection3'] = 'Título do corpo para a 3ª seção';
$string['frontpageblockdescriptionsection3'] = 'Descrição do corpo para a 3ª seção';
$string['frontpageblockiconsection3'] = 'Ícone Font-Awesome para a 3ª seção';
$string['sectionbuttontext3'] = 'Texto do botão para a 3ª seção';
$string['sectionbuttonlink3'] = 'Link URL para a 3ª seção';

// Seção de bloco 4.
$string['frontpageblocksection4'] = 'Título do corpo para a 4ª seção';
$string['frontpageblockdescriptionsection4'] = 'Descrição do corpo para a 4ª seção';
$string['frontpageblockiconsection4'] = 'Ícone Font-Awesome para a 4ª seção';
$string['sectionbuttontext4'] = 'Texto do botão para a 4ª seção';
$string['sectionbuttonlink4'] = 'Link de URL para a 4ª seção';
$string['defaultdescriptionsection'] = 'Aproveite de forma holística tecnologias just-in-time por meio de cenários corporativos.';
$string['frontpagetestimonial'] = 'Depoimento da página inicial';
$string['frontpagetestimonialdesc'] = 'Seção de depoimentos da página inicial';
$string['enablefrontpageaboutus'] = 'Habilitar seção de depoimentos';
$string['enablefrontpageaboutusdesc'] = 'Habilitar a seção de depoimentos na página inicial.';
$string['frontpageaboutusheading'] = 'Título da seção de depoimentos';
$string['frontpageaboutusheadingdesc'] = 'Título para o texto padrão da seção';
$string['frontpageaboutustext'] = 'Texto do depoimento';
$string['frontpageaboutustextdesc'] = 'Digite o texto do depoimento para a página inicial.';
$string['frontpageaboutusdefault'] = '<p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
Ut enim ad minim veniam.</p>';
$string['testimonialcount'] = 'Número de depoimentos';
$string['testimonialcountdesc'] = 'Número de depoimentos a serem exibidos.';
$string['testimonialimage'] = 'Imagem do depoimento';
$string['testimonialimagedesc'] = 'Imagem da pessoa para exibir com o depoimento';
$string['testimonialname'] = 'Nome da pessoa';
$string['testimonialnamedesc'] = 'Nome da pessoa';
$string['testimonialdesignation'] = 'Designação da pessoa';
$string['testimonialdesignationdesc'] = 'Designação da pessoa.';
$string['testimonialtext'] = 'Depoimento da pessoa';
$string['testimonialtextdesc'] = 'O que a pessoa diz';
$string['frontpageblockimage'] = 'Carregar imagem';
$string['frontpageblockimagedesc'] = 'Você pode carregar uma imagem como conteúdo para isso.';
$string['frontpageblockiconsectiondesc'] = 'Você pode escolher qualquer ícone nesta <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new">lista</a>. Basta digitar o texto após "fa-".';
$string['frontpageblockdescriptionsectiondesc'] = 'Uma breve descrição sobre o título.';

// Curso.
$string['graderreport'] = 'Relatório de avaliador';
$string['enroluser'] = 'Matricular usuários';
$string['activityeport'] = 'Relatório de atividade';
$string['editcourse'] = 'Editar curso';
$string['imageforcourse'] = 'Imagem para o curso';
// Próxima atividade anterior.
$string['activityprev'] = 'Atividade anterior';
$string['activitynext'] = 'Próxima atividade';
$string['activitynextpreviousbutton'] = 'Ativar botão de atividade anterior e próxima';
$string['activitynextpreviousbuttondesc'] = 'Quando ativado, os botões Próxima e Anterior da atividade aparecerão na página de atividade única para alternar entre as atividades.';
$string['disablenextprevious'] = 'Desativar';
$string['enablenextprevious'] = 'Ativar';
$string['enablenextpreviouswithname'] = 'Ativar com nome da atividade';

// Importador.
$string['importer'] = 'Importador';
$string['importer-missing'] = 'O plugin de Importador do Edwiser Site está faltando. Por favor, visite o site <a href="https://edwiser.org">Edwiser</a> para baixar este plugin.';

// Centro de informações.
$string['informationcenter'] = 'Centro de Informações';
$string['licensenotactive'] = '<strong>Alerta!</strong> A licença não está ativada, por favor <strong>ative</strong> a licença nas configurações do RemUI.';
$string['licensenotactiveadmin'] = '<strong>Alerta!</strong> A licença não está ativada, por favor <strong>ative</strong> a licença <a class="text-primary" href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#informationcenter" >aqui</a>.';
$string['activatelicense'] = 'Ativar Licença';
$string['deactivatelicense'] = 'Desativar Licença';
$string['renewlicense'] = 'Renovar Licença';
$string['deactivated'] = 'Desativada';
$string['active'] = 'Ativa';
$string['notactive'] = 'Não Ativa';
$string['expired'] = 'Expirada';
$string['licensekey'] = 'Chave de Licença';
$string['licensestatus'] = 'Status da Licença';
$string['no_activations_left'] = 'Limite excedido';
$string['activationfailed'] = 'Falha na ativação da chave de licença. Por favor, tente novamente mais tarde.';
$string['noresponsereceived'] = 'Não houve resposta do servidor. Por favor, tente novamente mais tarde.';
$string['licensekeydeactivated'] = 'A chave de licença foi desativada.';
$string['siteinactive'] = 'Site inativo (Pressione Ativar licença para ativar o plugin).';
$string['entervalidlicensekey'] = 'Por favor, insira uma chave de licença válida.';
$string['nolicenselimitleft'] = 'Limite máximo de ativações alcançado, sem ativações restantes.';
$string['licensekeyisdisabled'] = 'Sua chave de licença está desativada.';
$string['licensekeyhasexpired'] = "Sua chave de licença expirou. Por favor, renove-a.";
$string['licensekeyactivated'] = "Sua chave de licença está ativada.";
$string['entervalidlicensekey'] = "Por favor, insira uma chave de licença correta.";
$string['edwiserremuilicenseactivation'] = 'Ativação da Chave de Licença Edwiser RemUI';
$string['enterlicensekey'] = "Insira a chave de licença...";
$string['invalid'] = "Inválida";

$string['courseheaderdesign'] = 'Design do cabeçalho da página do curso';
$string['courseheaderdesigndesc'] = 'Escolha o design do cabeçalho da página do curso';
$string['default'] = 'Padrão';
$string['headerdesign'] = 'Design do cabeçalho {$a}';
$string['sidebarcoursemenuheading'] = "Menu do curso";

// Notificação
$string['inproductnotification'] = "Atualizar preferências do usuário (notificação no produto) - RemUI";

$string["noti_enrolandcompletion"] = 'Os layouts modernos e profissionais do Edwiser RemUI ajudaram brilhantemente a aumentar o engajamento geral dos seus alunos com <b>{$a->enrolment} novas inscrições em cursos e {$a->completion} conclusões de cursos</b> neste mês';

$string["noti_completion"] = 'O Edwiser RemUI melhorou seus níveis de engajamento dos alunos: Você tem um total de <b>{$a->completion} conclusões de cursos</b> neste mês';

$string["noti_enrol"] = 'Seu design do LMS parece ótimo com o Edwiser RemUI: Você tem <b>{$a->enrolment} novas inscrições em cursos</b> no seu portal neste mês';

$string["coolthankx"] = "Legal, obrigado!";

$string['gridview'] = 'Visualização em grade';
$string['listview'] = 'Visualização em lista';
$string['summaryview'] = 'Visualização de resumo';

$string['side-top'] = "Conteúdo Superior da Caixa";
$string['content'] = "Padrão do Moodle";
$string['side-bottom'] = "Conteúdo Inferior da Caixa";
$string['side-pre'] = "Barra Lateral Direita";

$string['sitenamecolor'] = "Cor do nome ou ícone do site.";
$string['sitenamecolordesc'] = "Cor para o texto do nome do site e ícone do site, que também será aplicada na página de login.";

$string['coursesenrolled'] = "Cursos matriculados";
$string['coursescompleted'] = "Cursos concluídos";
$string['activitiescompleted'] = "Atividades concluídas";
$string['activitiesdue'] = "Atividades devidas";

$string['customizer-migrate-notice'] = 'As configurações de cores foram migradas para o personalizador visual. Por favor, clique no botão abaixo para abrir o personalizador visual.';
$string['customizer-close-heading'] = 'Fechar personalizador visual';
$string['customizer-close-description'] = 'As alterações não salvas serão descartadas. Deseja continuar?';
$string['reset'] = 'Redefinir';
$string['reset-settings'] = 'Redefinir todas as configurações do personalizador visual';
$string['reset-settings-description'] = '
<div>As configurações do personalizador visual serão restauradas para o padrão. Você quer continuar?</div>
<div class="mt-3"><strong>Redefinir Tudo:</strong> Redefinir todas as configurações.</div>
<div class="mt-3"><strong>Redefinir:</strong> As configurações, exceto as seguintes, serão redefinidas para o padrão.</div>
';
$string['customizer'] = 'Personalizador Visual';
$string['error'] = 'Erro';
$string['resetdesc'] = 'Redefinir as configurações para a última salvamento ou padrão quando nada foi salvo';
$string['noaccessright'] = 'Desculpe! Você não tem direitos para usar';

$string['font-family'] = 'Família de fonte';
$string['font-family_help'] = 'Defina a família de fonte de {$a}';

$string['button-font-family'] = 'Família de fonte';
$string['button-font-family_help'] = 'Defina a família de fonte do texto do botão';

$string['font-size'] = 'Tamanho da fonte';
$string['font-size_help'] = 'Defina o tamanho da fonte de {$a}';
$string['font-weight'] = 'Peso da fonte';
$string['font-weight_help'] = 'Defina o peso da fonte de {$a}. A propriedade font-weight define como os caracteres em um texto devem ser exibidos, se mais espessos ou mais finos.';
$string['line-height'] = 'Altura da linha';
$string['line-height_help'] = 'Defina a altura da linha de {$a}';
$string['global'] = 'Global';
$string['global_help'] = 'Você pode gerenciar configurações globais como cor, fonte, cabeçalhos, botões etc.';
$string['site'] = 'Site';
$string['text-color'] = 'Cor do texto';
$string['welcome-text-color'] = 'Cor do texto de boas-vindas';
$string['text-hover-color'] = 'Cor do texto ao passar o mouse';
$string['text-color_help'] = 'Defina a cor do texto de {$a}';
$string['content-color'] = 'Cor do conteúdo';
$string['icon-color'] = 'Cor do ícone';
$string['icon-hover-color'] = 'Cor do ícone ao passar o mouse';
$string['icon-color_help'] = 'Defina a cor do ícone de {$a}';
$string['link-color'] = 'Cor do link';
$string['link-color_help'] = 'Defina a cor do link de {$a}';
$string['link-hover-color'] = 'Cor do link ao passar o mouse';
$string['link-hover-color_help'] = 'Defina a cor do link ao passar o mouse de {$a}';
$string['typography'] = 'Tipografia';
$string['inherit'] = 'Herdado';
$string["weight-100"] = '100';
$string["weight-200"] = '200';
$string["weight-300"] = '300';
$string["weight-400"] = '400';
$string["weight-500"] = '500';
$string["weight-600"] = '600';
$string["weight-700"] = '700';
$string["weight-800"] = '800';
$string["weight-900"] = '900';
$string['text-transform'] = 'Transformação de texto';
$string['text-transform_help'] = 'A propriedade text-transform controla a capitalização do texto. Defina a transformação de texto de {$a}';

$string['button-text-transform'] = 'Transformação de texto';
$string['button-text-transform_help'] = 'A propriedade text-transform controla a capitalização do texto. Defina a transformação de texto para o texto do botão.';

$string["default"] = 'Padrão';
$string["none"] = 'Nenhum';
$string["capitalize"] = 'Capitalizar';
$string["uppercase"] = 'Letras maiúsculas';
$string["lowercase"] = 'Letras minúsculas';
$string['background-color'] = 'Cor de fundo';
$string['background-hover-color'] = 'Cor de fundo ao passar o mouse';
$string['background-color_help'] = 'Defina a cor de fundo de {$a}';
$string['background-hover-color'] = 'Cor de fundo ao passar o mouse';
$string['background-hover-color_help'] = 'Defina a cor de fundo ao passar o mouse de {$a}';
$string['color'] = 'Cor';
$string['customizing'] = 'Personalizando';
$string['savesuccess'] = 'Salvo com sucesso.';
$string['mobile'] = 'Celular';
$string['tablet'] = 'Tablet';
$string['hide-customizer'] = 'Ocultar personalizador';
$string['customcss_help'] = 'Você pode adicionar CSS personalizado. Isso será aplicado em todas as páginas do seu site.';

// Corpo Global do Personalizador.
$string['body'] = 'Corpo';
$string['body-font-family_desc'] = 'Defina a família da fonte para todo o site. Observe que, se definido como Padrão, a fonte da configuração do RemUI será aplicada.';
$string['body-font-size_desc'] = 'Defina o tamanho base da fonte para todo o site.';
$string['body-fontweight_desc'] = 'Defina o peso da fonte para todo o site.';
$string['body-text-transform_desc'] = 'Defina a transformação de texto para todo o site.';
$string['body-lineheight_desc'] = 'Defina a altura da linha para todo o site.';
$string['faviconurl_help'] = 'URL do favicon';

// Cabeçalho Global do Personalizador.
$string['heading'] = 'Cabeçalho';
$string['use-custom-color'] = 'Usar cor personalizada';
$string['use-custom-color_help'] = 'Usar cor personalizada para {$a}';
$string['typography-heading-all-heading'] = 'Cabeçalhos (H1 - H6)';
$string['typography-heading-h1-heading'] = 'Cabeçalho 1';
$string['typography-heading-h2-heading'] = 'Cabeçalho 2';
$string['typography-heading-h3-heading'] = 'Cabeçalho 3';
$string['typography-heading-h4-heading'] = 'Cabeçalho 4';
$string['typography-heading-h5-heading'] = 'Cabeçalho 5';
$string['typography-heading-h6-heading'] = 'Cabeçalho 6';

// Cores do Personalizador.
$string['primary-color'] = 'Cor primária';
$string['primary-color_help'] = 'Aplicar a cor primária da marca em todo o site. Essa cor será aplicada aos botões, links de texto, ao passar o mouse e para itens do menu de cabeçalho ativos, ao passar o mouse e para ícones ativos.
<br><b>Observação:</b> A alteração da cor primária não alterará as cores dos botões se você tiver alterado as cores dos botões por meio de suas configurações individuais (<b>Global > Botões > Configurações de cor do botão</b>). Alterar a cor primária não mudará as cores dos botões se você tiver alterado as cores dos botões por meio de suas configurações individuais (Global> Botões> Configurações de cor do botão). Redefina as cores dos botões a partir de suas configurações individuais para alterar a mudança do botão alterando globalmente a cor primária a partir daqui';

$string['secondary-color'] = 'Cor de destaque';
$string['secondary-color_help'] = 'Aplica a cor de destaque a todo o site. Esta cor será aplicada aos ícones no bloco Estatísticas na página do Painel, tags nos cartões do curso, banners do cabeçalho do curso';

$string['page-background'] = 'Fundo da página';
$string['page-background_help'] = 'Defina um fundo personalizado para a área de conteúdo da página. Você pode escolher cor, gradiente ou imagem. O ângulo de cor do gradiente é de 100 graus.';

$string['page-background-color'] = 'Cor do fundo da página';
$string['page-background-color_help'] = 'Defina a cor de fundo para a área de conteúdo da página.';

$string['page-background-image'] = 'Imagem de fundo da página';
$string['page-background-image_help'] = 'Defina uma imagem como plano de fundo para a área de conteúdo da página.';

$string['gradient'] = 'Gradiente';
$string['gradient-color1'] = 'Cor do gradiente 1';
$string['gradient-color1_help'] = 'Defina a primeira cor do gradiente';
$string['gradient-color2'] = 'Cor do gradiente 2';
$string['gradient-color2_help'] = 'Defina a segunda cor do gradiente';
$string['gradient-color-angle'] = 'Ângulo do gradiente';
$string['gradient-color-angle_help'] = 'Defina o ângulo para as cores do gradiente';

$string['page-background-imageattachment'] = 'Anexo de imagem de fundo';
$string['page-background-imageattachment_help'] = 'A propriedade background-attachment define se uma imagem de fundo rola com o restante da página ou é fixa.';

$string['image'] = 'Imagem';
$string['additional-css'] = 'CSS adicional';
$string['left-sidebar'] = 'Barra lateral esquerda';
$string['main-sidebar'] = 'Barra lateral principal';
$string['sidebar-links'] = 'Links da barra lateral';
$string['secondary-sidebar'] = 'Barra lateral secundária';
$string['header'] = 'Cabeçalho';
$string['headertypography'] = 'Tipografia do cabeçalho';
$string['headercolors'] = 'Cores do cabeçalho';
$string['menu'] = 'Menu';
$string['site-identity'] = 'Identidade do site';
$string['primary-header'] = 'Cabeçalho primário';
$string['color'] = 'Cor';

// Botões do Customizador.
$string['buttons'] = 'Botões';
$string['border'] = 'Borda';
$string['border-width'] = 'Largura da borda';
$string['border-width_help'] = 'Defina a largura da borda de {$a}';
$string['border-color'] = 'Cor da borda';
$string['border-color_help'] = 'Defina a cor da borda de {$a}';
$string['border-hover-color'] = 'Cor da borda ao passar o mouse';
$string['border-hover-color_help'] = 'Define a cor da borda ao passar o mouse em cima de {$a}';
$string['border-radius'] = 'Raio da borda';
$string['border-radius_help'] = 'Define o raio da borda de {$a}';
$string['letter-spacing'] = 'Espaçamento entre letras';
$string['letter-spacing_help'] = 'Define o espaçamento entre letras de {$a}';
$string['text'] = 'Texto';
$string['padding'] = 'Preenchimento';
$string['padding-top'] = 'Preenchimento superior';
$string['padding-top_help'] = 'Define o preenchimento superior de {$a}';
$string['padding-right'] = 'Preenchimento direito';
$string['padding-right_help'] = 'Define o preenchimento direito de {$a}';
$string['padding-bottom'] = 'Preenchimento inferior';
$string['padding-bottom_help'] = 'Define o preenchimento inferior de {$a}';
$string['padding-left'] = 'Preenchimento esquerdo';
$string['padding-left_help'] = 'Define o preenchimento esquerdo de {$a}';
$string['secondary'] = 'Secundário';
$string['colors'] = 'Cores';
$string['commonbuttonsettings'] = 'Configurações comuns';
$string['buttonsizesettings'] = 'Tamanhos de botão';
$string['buttonsizesettingshead'] = '{$a}';
$string['commonfontsettings'] = 'Fonte';
$string['buttoncolorsettings'] = 'Configurações de cor do botão';
// Cabeçalho Personalizado.
$string['header-background-color_help'] = 'Defina a cor de fundo do cabeçalho. Isso não será aplicado se <strong>Definir cor de fundo do cabeçalho igual à cor de fundo do logo</strong> estiver habilitado.';
$string['site-logo'] = 'Logo do site';
$string['header-menu'] = 'Menu do cabeçalho';
$string['box-shadow-size'] = 'Tamanho da sombra da caixa';
$string['box-shadow-size_help'] = 'Defina o tamanho da sombra da caixa para o cabeçalho do site';
$string['box-shadow-blur'] = 'Desfoque da sombra da caixa';
$string['box-shadow-blur_help'] = 'Defina o desfoque da sombra da caixa para o cabeçalho do site';
$string['box-shadow-color'] = 'Cor da sombra da caixa';
$string['box-shadow-color_help'] = 'Defina a cor da sombra da caixa para o cabeçalho do site';
$string['layout-desktop'] = 'Layout desktop';
$string['layout-desktop_help'] = 'Defina o layout do cabeçalho para desktop';
$string['layout-mobile'] = 'Layout mobile';
$string['layout-mobile_help'] = 'Defina o layout do cabeçalho para mobile';
$string['header-left'] = 'Ícone esquerdo menu direito';
$string['header-right'] = 'Ícone direito menu esquerdo';
$string['header-top'] = 'Ícone superior menu inferior';
$string['hover'] = 'Hover';
$string['logo'] = 'Logo';
$string['applynavbarcolor'] = 'Definir cor de fundo do cabeçalho igual à cor de fundo do logo';
$string['applynavbarcolor_help'] = 'A cor de fundo do logo será aplicada ao cabeçalho inteiro. Alterar a cor de fundo do logo mudará a cor de fundo do cabeçalho. Você ainda pode aplicar cor de texto personalizada e cor de hover aos menus do cabeçalho.';
$string['header-background-color-warning'] = 'Não será usado se <strong>Definir cor do site da barra de navegação</strong> estiver habilitado.';
$string['logosize'] = 'A proporção esperada é de 130:33 para visualização à esquerda e 140:33 para visualização à direita.';
$string['logominisize'] = 'A proporção esperada é de 40:33.';
$string['sitenamewithlogo'] = 'Nome do site com logo (Apenas visualização superior)';

// Personalizador de Barra Lateral.
$string['link-text'] = 'Texto do link';
$string['link-text_help'] = 'Defina a cor do texto do link de {$a}';
$string['link-icon'] = 'Ícone do link';
$string['link-icon_help'] = 'Defina a cor do ícone do link de {$a}';
$string['active-link-color'] = 'Cor do link ativo';
$string['active-link-color_help'] = 'Defina a cor personalizada para o link ativo de {$a}';
$string['active-link-background'] = 'Fundo do link ativo';
$string['active-link-background_help'] = 'Defina a cor personalizada para o fundo do link ativo de {$a}';
$string['link-hover-background'] = 'Fundo do link ao passar o mouse';
$string['link-hover-background_help'] = 'Defina o fundo do link ao passar o mouse para {$a}';
$string['link-hover-text'] = 'Texto do link ao passar o mouse';
$string['link-hover-text_help'] = 'Defina a cor do texto do link ao passar o mouse de {$a}';

// Personalizador de Rodapé.
$string['footer'] = 'Rodapé';
$string['basic'] = 'Design do rodapé';
$string['socialall'] = 'Links das redes sociais';
$string['advance'] = 'Área principal do rodapé';
$string['footercolumn'] = 'Widget';
$string['footercolumnwidgetno'] = 'Selecione o número de widgets';
$string['footercolumndesc'] = 'Número de widgets para exibir no rodapé.';
$string['footercolumntype'] = 'Selecione o tipo';
$string['footercolumntypedesc'] = 'Você pode escolher o tipo de widget de rodapé';
$string['footercolumnsocial'] = 'Links de redes sociais';
$string['footercolumnsocialdesc'] = 'Selecione os links a serem exibidos. Pressione e segure "ctrl" no teclado para selecionar vários links';
$string['footercolumntitle'] = 'Adicionar título';
$string['footercolumntitledesc'] = 'Adicione título a este widget.';
$string['footercolumncustomhtml'] = 'Conteúdo';
$string['footercolumncustomhtmldesc'] = 'Você pode personalizar o conteúdo deste widget usando o editor abaixo.';
$string['both'] = 'Ambos';
$string['footercolumnsize'] = 'Ajustar largura do widget';
$string['footercolumnsizenote'] = 'Arraste a linha vertical para ajustar o tamanho do widget.';
$string['footercolumnsizedesc'] = 'Você pode definir o tamanho individual de cada widget.';
$string['footercolumnmenu'] = 'Menu';
$string['footercolumnmenudesc'] = 'Menu de links';
$string['footermenu'] = 'Menu';
$string['footermenudesc'] = 'Adicionar menu no widget do rodapé.';
$string['customizermenuadd'] = 'Adicionar item de menu';
$string['customizermenuedit'] = 'Editar item de menu';
$string['customizermenumoveup'] = 'Mover item de menu para cima';
$string['customizermenuemovedown'] = 'Mover item de menu para baixo';
$string['customizermenuedelete'] = 'Excluir item de menu';
$string['menutext'] = 'Texto';
$string['menuaddress'] = 'Endereço';
$string['menuorientation'] = 'Orientação do menu';
$string['menuorientationdesc'] = 'Defina a orientação do menu. A orientação pode ser vertical ou horizontal.';
$string['menuorientationvertical'] = 'Vertical';
$string['menuorientationhorizontal'] = 'Horizontal';
$string['footerfacebook'] = 'Facebook';
$string['footertwitter'] = 'Twitter';
$string['footerlinkedin'] = 'Linkedin';
$string['footergplus'] = 'Google Plus';
$string['footeryoutube'] = 'Youtube';
$string['footerinstagram'] = 'Instagram';
$string['footerpinterest'] = 'Pinterest';
$string['footerquora'] = 'Quora';
$string['footershowlogo'] = 'Mostrar logotipo';
$string['footershowlogodesc'] = 'Mostrar logotipo no rodapé secundário.';
$string['footersecondarysocial'] = 'Mostrar links de mídia social';
$string['footersecondarysocialdesc'] = 'Mostrar links de mídia social no rodapé secundário.';
$string['footertermsandconditionsshow'] = 'Mostrar Termos e Condições';
$string['footertermsandconditions'] = 'Link dos Termos e Condições';
$string['footertermsandconditionsdesc'] = 'Você pode adicionar um link para a página de Termos e Condições.';
$string['footerprivacypolicyshow'] = 'Mostrar Política de Privacidade';
$string['footerprivacypolicy'] = 'Link da Política de Privacidade';
$string['footerprivacypolicydesc'] = 'Você pode adicionar um link para a página de Política de Privacidade.';
$string['footercopyrightsshow'] = 'Mostrar Conteúdo de Direitos Autorais';
$string['footercopyrights'] = 'Conteúdo de Direitos Autorais';
$string['footercopyrightsdesc'] = 'Adicionar conteúdo de Direitos Autorais no final da página.';
$string['footercopyrightstags'] = 'Tags:<br>[site] - Nome do site<br>[year] - Ano atual';
$string['termsandconditions'] = 'Termos e Condições';
$string['privacypolicy'] = 'Política de Privacidade';
$string['footerfont'] = 'Fonte';
$string['footerbasiccolumntitle'] = 'Título da coluna';
$string['divider-color'] = 'Cor do separador';
$string['divider-color_help'] = 'Definir a cor do separador de {$a}';
$string['text-hover-color'] = 'Cor do texto ao passar o mouse';
$string['text-hover-color_help'] = 'Define a cor do texto ao passar o mouse sobre {$a}.';
$string['link-color'] = 'Cor do link';
$string['link-color_help'] = 'Define a cor do link de {$a}.';
$string['link-hover-color'] = 'Cor do link ao passar o mouse';
$string['link-hover-color_help'] = 'Define a cor do link ao passar o mouse sobre {$a}.';
$string['icon-default-color'] = 'Cor do ícone';
$string['icon-default-color_help'] = 'Define a cor do ícone de {$a}.';
$string['icon-hover-color'] = 'Cor do ícone ao passar o mouse';
$string['icon-hover-color_help'] = 'Define a cor do ícone ao passar o mouse sobre {$a}.';
$string['footerfontsize_help'] = 'Define o tamanho da fonte.';
$string['footer-color-heading1'] = 'Cores do rodapé';
$string['footer-color-heading2'] = 'Links do rodapé';
$string['footer-color-heading3'] = 'Ícones do rodapé';

$string['footerfontfamily'] = 'Família da fonte';
$string['footerfontfamily_help'] = 'Família da fonte do rodapé.';
$string['footerfontsize'] = 'Tamanho da fonte';
$string['footerfontsize_help'] = 'Tamanho da fonte do rodapé.';
$string['footerfontweight'] = 'Peso da fonte';
$string['footerfontweight_help'] = 'Peso da fonte do rodapé.';
$string['footerfonttext-transform'] = 'Transformação do texto';
$string['footerfonttext-transform_help'] = 'Transformação do texto do rodapé.';
$string['footerfontlineheight'] = 'Espaçamento entre linhas';
$string['footerfontlineheight_help'] = 'Espaçamento entre linhas do rodapé.';
$string['footerfontltrspace'] = 'Espaçamento entre letras';
$string['footerfontltrspace_help'] = 'Define o espaçamento entre letras.';
$string['footer-columntitle-fontfamily'] = 'Família da fonte';
$string['footer-columntitle-fontfamily_help'] = 'Família da fonte';
$string['footer-columntitle-fontsize'] = 'Tamanho da fonte';
$string['footer-columntitle-fontsize_help'] = 'Tamanho da fonte do título da coluna do rodapé';
$string['footer-columntitle-fontweight'] = 'Peso da fonte';
$string['footer-columntitle-fontweight_help'] = 'Peso da fonte do título da coluna do rodapé';
$string['footer-columntitle-textransform'] = 'Transformação do texto';
$string['footer-columntitle-textransform_help'] = 'Transformação do texto do título da coluna do rodapé';
$string['footer-columntitle-lineheight'] = 'Espaçamento entre linhas';
$string['footer-columntitle-lineheight_help'] = 'Espaçamento entre as linhas';
$string['footer-columntitle-ltrspace'] = 'Espaçamento entre as letras';
$string['footer-columntitle-ltrspace_help'] = 'Espaçamento entre as letras';
$string['footer-columntitle-color'] = 'Cor';
$string['footer-columntitle-color_help'] = 'Cor';

$string['openinnewtab'] = 'Abrir em uma nova aba';
$string['useheaderlogo'] = 'Usar o mesmo logotipo do cabeçalho';
$string['secondaryfooterlogo'] = 'Adicionar um novo logotipo';
$string['logosettings'] = 'Configurações do logotipo';
$string['loginformsettings'] = 'Configurações do formulário de login';
$string['loginpagesettings'] = 'Configurações da página de login';
$string['footersecondary'] = 'Área inferior do rodapé';
$string['footer-columns'] = 'Colunas do rodapé';
$string['footer-columntitle-color_help'] = 'Definir a cor do texto de {$a}';
$string['footer-logo-color'] = 'Selecionar a cor do ícone ou do texto';
$string['footer-logo-color_help'] = 'Selecionar a cor do ícone ou do texto';
// Personalizador de login.
$string['login'] = 'Login';
$string['panel'] = 'Painel';
$string['page'] = 'Página';
$string['loginbackgroundopacity'] = 'Opacidade da sobreposição de fundo';
$string['loginbackgroundopacity_help'] = 'Aplicar sobreposição à imagem de fundo da página de login.';
$string['loginpanelbackgroundcolor_help'] = 'Aplicar cor de fundo ao painel de login.';
$string['loginpaneltextcolor_help'] = 'Aplicar cor do texto ao painel de login.';
$string['loginpanelcontentcolor_help'] = 'Aplicar cor do texto ao conteúdo do painel de login.';
$string['loginpanellinkcolor_help'] = 'Aplicar cor do link ao painel de login.';
$string['loginpanellinkhovercolor_help'] = 'Aplicar cor do link quando o mouse passa sobre ele ao painel de login.';
$string['login-panel-position'] = 'Posição do painel de login';
$string['login-panel-position_help'] = 'Definir a posição do painel de login e registro';
$string['login-page-info'] = '<p><b>Nota: </b>A página de login não pode ser visualizada no personalizador visual porque apenas usuários deslogados podem vê-la. Você pode testar a configuração salvando e abrindo a página de login no modo anônimo.</p>';
$string['login-page-setting'] = 'Estilo de fundo da página';
$string['login-page-backgroundgradient1'] = 'Selecionar cor 1';
$string['login-page-backgroundgradient2'] = 'Selecionar cor 2';
$string['loginpanelbackgroundcolor'] = 'Cor de fundo da página';
$string['loginpagebackgroundcolor'] = 'Selecionar cor de fundo';
$string['loginpagebackgroundcolor_help'] = 'Definir o fundo da página de login. Você pode escolher uma cor, gradiente ou imagem.';
$string['login-page-background_help'] = 'Aplicar cor de fundo ao painel de login';

$string['primary'] = 'Primário';

$string['dashboardsettingdesc'] = 'Configurações relacionadas ao painel';
$string['dashboardsetting'] = 'Painel';
$string['dashboardpage'] = 'Página do painel';
$string['enabledashboardcoursestats'] = 'Ativar estatísticas do curso no painel';
$string['enabledashboardcoursestatsdesc'] = 'Se ativado, as estatísticas do curso serão exibidas na página do painel';

$string['customizecontrolsclose'] = "Fechar";

// Personalizador de configuração rápida.
$string['quicksetup'] = 'Configuração rápida';
$string['pallet'] = 'Paleta';
$string['colorpallet'] = 'Paletas de cores';
$string['currentpallet'] = 'Paleta atual';
$string['currentfont'] = 'Fonte atual';
$string['colorpalletdesc'] = 'Descrição das paletas de cores';
$string['preset1'] = 'Predefinido 1';
$string['preset2'] = 'Predefinido 2';
$string['sitefavicon'] = 'Favicon do site';

$string['themecolors'] = 'Cores do tema';
$string['brandcolors-heading'] = 'Cores da marca';
$string['border-color'] = 'Cor da borda';
$string['border-hover-color'] = 'Cor da borda ao passar o mouse';
$string['smart-colors-heading'] = "Aplicar cores globais";
$string['smart-colors-info'] = "<p>As cores globais e suas sombras / tons serão aplicadas ao site para criar uma combinação de cores visualmente impressionante</p><p><b>Nota:</b> Você tem a flexibilidade de personalizar as cores de elementos individuais a qualquer momento, simplesmente visitando suas configurações específicas.</p>";
$string['apply'] = "Aplicar";
$string['backgroundsettings'] = 'Configurações de fundo';

$string['ascent-background-color'] = 'Cor de fundo Ascensão';
$string['ascent-background-color_help'] = 'Definir a cor de fundo da Ascensão. Esta cor será aplicada ao fundo das tags no site, exceto para as tags nos cartões de curso e no banner do cabeçalho do curso';
$string['element-background-color'] = 'Cor de fundo do elemento';
$string['element-background-color_help'] = 'Defina a cor de fundo do elemento. Esta cor é aplicada ao fundo para texto pequeno, fundo ao passar o mouse em textos suspensos, fundo dos cabeçalhos de seção, dicas etc.';

$string['light-border-color'] = 'Cor da borda clara';
$string['themecolors-lightbordercolor_help'] = 'Defina a cor da borda clara. Esta cor é aplicada como borda a elementos com fundos brancos, como o menu suspenso de notificação no cabeçalho, cartões de curso, pesquisa de menu suspenso de curso e em linhas divisórias em elementos de bloco, etc.';

$string['medium-border-color'] = 'Cor da borda média';
$string['themecolors-mediumbordercolor_help'] = 'Defina a cor da borda média. Esta cor é aplicada como cor da borda e cor do divisor. É especificamente aplicada como cor da borda para menus suspensos e caixas de pesquisa e também para o fundo dos elementos aos quais a cor do fundo do elemento é aplicada (você pode encontrar a configuração de cor do fundo do elemento em <b>Cores do Tema > Configurações de Fundo</b>) para exemplos como o fundo de textos pequenos, cabeçalhos de seções, dicas de ferramentas etc.';

$string['borderssettings'] = 'Configurações de bordas';

// Configurações do menu rápido
$string['enablequickmenu'] = 'Ativar menu rápido';
$string['enablequickmenudesc'] = 'Menu suspenso com links rápidos para acesso mais fácil às páginas.';

// Gaveta de navegação esquerda.
$string['coursearchivepage'] = 'Página de Arquivo do Curso';
$string['createanewcourse'] = 'Criar um Novo Curso';
$string['remuisettings'] = 'Configurações RemUI';

$string['bodysettingslinking'] = 'Configurações avançadas de link';
$string['bodysettingslinking_help'] = 'Quando ativado, as configurações de pequenos parágrafos e texto de informações pequenas serão vinculadas às configurações do corpo.';
$string['bodysettingslinked'] = 'Vinculado às configurações do corpo';
$string['normal-para-font'] = "Parágrafo normal";
$string['smallpara-font'] = "Pequeno parágrafo";
$string['smallinfo-font'] = "Texto de informação pequeno";

$string['interactiveicons'] = 'Ícones interativos';
$string['noninteractiveicons'] = 'Ícones não interativos';
$string['singlecolorsicon'] = "Ícone de cores únicas";
$string['scicon-color'] = 'Cor';
$string['scicon-color_help'] = 'Cor do estado de repouso do ícone de cor única';
$string['scicon-hover'] = 'Passar o mouse';
$string['scicon-hover_help'] = 'Cor do estado do passar do mouse do ícone de cor única';
$string['scicon-active'] = 'Ativo';
$string['scicon-active_help'] = 'Cor do estado ativo do ícone de cor única';

$string['dualcolorsicon'] = "Ícone de cores duplas";
$string['dcicon-color'] = 'Cor';
$string['dcicon-color_help'] = 'Cor do estado de repouso do ícone de cor dupla';
$string['dcicon-hover'] = 'Passar o mouse';
$string['dcicon-hover_help'] = 'Cor do estado do passar do mouse do ícone de cor dupla';
$string['dcicon-active'] = 'Ativo';
$string['dcicon-active_help'] = 'Cor do estado ativo do ícone de cor dupla';

$string['non-interactive-color'] = 'Cor';
$string['non-interactive-color_help'] = 'Cor do ícone não interativo';
$string['textlink'] = 'Link de texto';

$string['header-logo-setting'] = 'Configurações do logotipo do cabeçalho';
$string['logo-bg-color'] = 'Cor de fundo do logotipo';
$string['logo-bg-color_help'] = 'Defina a cor de fundo para o logotipo da marca do cabeçalho.';
$string['header-design-settings'] = 'Configurações de design do cabeçalho';
$string['hide-show-menu-item'] = 'Esconder/Mostrar item de menu';
$string['hide-dashboard'] = 'Esconder Painel';
$string['hide-dashboard_help'] = 'Ao ativar esta opção, o item Painel do cabeçalho será escondido';
$string['hide-home'] = 'Esconder Início';
$string['hide-home_help'] = 'Ao ativar esta opção, o item Início do cabeçalho será escondido';
$string['hide-my-courses'] = 'Esconder Meus Cursos';
$string['hide-my-courses_help'] = 'Ao ativar esta opção, os itens Meus cursos e os cursos aninhados do cabeçalho serão escondidos';
$string['hide-site-admin'] = 'Esconder Administração do Site';
$string['hide-site-admin_help'] = 'Ao ativar esta opção, o item Administração do Site do cabeçalho será escondido';
$string['hide-recent-courses'] = 'Esconder Cursos Recentes';
$string['hide-recent-courses_help'] = 'Ao ativar esta opção, o menu suspenso Cursos Recentes do cabeçalho será escondido';
$string['header-menu-element-bg-color'] = 'Cor de fundo do elemento do menu';
$string['header-menu-element-bg-color_help'] = 'Cor de fundo do elemento do menu';
$string['header-menu-divider-bg-color'] = 'Cor do divisor do elemento';
$string['header-menu-divider-bg-color_help'] = 'Cor do divisor do elemento';
$string['hds-iconcolor'] = 'Cor do ícone do cabeçalho';
$string['hds-boxshadow'] = 'Sombra de caixa do cabeçalho';

$string['hds-menuitems'] = 'Itens do menu de cabeçalho';
$string['hds-menu-fontsize_desc'] = 'Definir tamanho da fonte para itens do menu de cabeçalho';
$string['hds-menu-color'] = 'Cor do item do menu';
$string['hds-menu-color_desc'] = 'Definir cor dos itens do menu de cabeçalho';
$string['hds-menu-hover-color'] = 'Cor de destaque do item do menu';
$string['hds-menu-hover-color_desc'] = 'Definir cor de destaque dos itens do menu de cabeçalho';
$string['hds-menu-active-color'] = 'Cor ativa do item do menu';
$string['hds-menu-active-color_desc'] = 'Definir cor ativa dos itens do menu de cabeçalho';

$string['hds-icon-color'] = 'Cor dos ícones';
$string['hds-icon-color_help'] = 'Cor dos ícones do menu de cabeçalho';
$string['hds-icon-hover-color'] = 'Cor de destaque dos ícones';
$string['hds-icon-hover-color_help'] = 'Definir cor de destaque dos ícones do menu de cabeçalho';
$string['hds-icon-active-color'] = 'Cor ativa dos ícones';
$string['hds-icon-active-color_help'] = 'Definir cor ativa dos ícones do menu de cabeçalho';

$string['preset1'] = "Preset 1";
$string['preset2'] = "Preset 2";
$string['preset3'] = "Preset 3";
$string['fonts'] = "Fontes";
$string['show'] = "Mostrar";
$string['hide'] = "Ocultar";
$string['other-bg-color'] = 'Outras cores de fundo';
$string['text-link-panel'] = 'Link de texto';
$string['colorpalletes'] = 'Paletas de cores';
$string['selectpallete'] = 'Selecionar paleta';
$string['selectfont'] = 'Selecionar fonte';

$string['socialiconspanel'] = "Painel de ícones sociais";
$string['social-icons-info'] = "<p>Para exibir os ícones de redes sociais na parte inferior de qualquer coluna de conteúdo, vá em <b>Rodapé > Área principal do rodapé > Widget > Selecione o tipo = Conteúdo </b>e ative a opção para mostrar os ícones de mídia social.</p>";
$string['social-icons-heading'] = "Ícones de redes sociais";
$string["custommenulinktext"] = 'Itens de menu personalizados';
$string["custommenulink"] = '<h6>Itens de menu personalizados</h6><p> Para adicionar / editar / excluir itens de menu personalizados, vá em Administração do site > Aparência > Configurações do tema > <a href="{$a}/admin/settings.php?section=themesettings#admin-custommenuitems" target ="_blank" class="text-decoration-none">Itens de menu personalizados</a> <p>';
$string['note'] = 'Nota';
$string['social-media-selection-note'] = "<p>Pressione Ctrl para selecionar/deselecionar a mídia</p>";

$string['editmodeswitch'] = "Alternar Modo de Edição";
$string['continue'] = 'Continuar';
$string['viewcourse'] = 'Ver Curso';
$string['hiddencourse'] = 'Curso Oculto';
$string['openquickmenu'] = 'Abrir menu rápido';
$string['closequickmenu'] = 'Fechar menu rápido';
$string['start'] = 'Início';
$string['other-bg-color'] = 'Outras cores de fundo';
$string['text-link-panel'] = 'Link de texto';
$string['colorpalletes'] = 'Paletas de cores';
$string['selectpallete'] = 'Selecione a paleta';
$string['selectfont'] = 'Selecione a fonte';

$string['socialiconspanel'] = "Painel de ícones sociais";
$string['social-icons-info'] = "<p>Para exibir os ícones das redes sociais na parte inferior de qualquer coluna com conteúdo, vá para <b>Rodapé > Área principal do rodapé > Widget > Selecione o tipo = Conteúdo</b> e ative a configuração para mostrar os ícones das redes sociais.</p>";
$string['social-icons-heading'] = "Ícones das redes sociais";
$string["custommenulinktext"] = 'Itens de menu personalizados';
$string["custommenulink"] = '<h6>Itens de menu personalizados</h6><p> Para adicionar/editar/excluir itens de menu personalizados, vá para Administração do site > Aparência > Configurações do tema > <a href="{$a}/admin/settings.php?section=themesettings#admin-custommenuitems" target ="_blank" class="text-decoration-none">Itens de menu personalizados</a> <p>';
$string['note'] = 'Nota';
$string['social-media-selection-note'] = "<p>Pressione Ctrl para selecionar/desselecionar as redes sociais</p>";

$string['editmodeswitch'] = "Alterar o modo de edição";
$string['continue'] = 'Continuar';
$string['viewcourse'] = 'Visualizar curso';
$string['hiddencourse'] = 'Curso oculto';
$string['openquickmenu'] = 'Abrir menu rápido';
$string['closequickmenu'] = 'Fechar menu rápido';
$string['start'] = 'Iniciar';

$string['readmore'] = 'Leia Mais';
$string['readless'] = 'Leia Menos';
$string['setting'] = 'Configurações';
$string['lastaccess'] = 'Último acesso';
$string['certificate'] = 'Certificados';
$string['badge'] = 'Distintivos';
$string['firstname'] = 'Primeiro nome';
$string['lastname'] = 'Último nome';
$string['badgefrom'] = 'Distintivos de {$a}';
$string['timelinenoevenettext'] = 'Não há atividades futuras';
$string['description'] = 'Descrição';
$string['instructorcounttitle'] = "Professores adicionais disponíveis no curso";

$string['personalizer'] = "Personalizador Visual";
$string['edwpersonalizer'] = "Personalizador Visual";
$string['editinpersonalizer'] = "Editar com o Personalizador";
$string['activepersonalizer'] = "Visualizando no Personalizador Edwiser.";
$string['searchtotalcount'] = 'Mostrando {$a} resultados';
$string['noresutssearchmsg'] = "<h4 class ='p-p-6 text-center m-0 '>Nada para exibir</h4>";
$string['globarsearchresult'] = "Resultados da Busca Global";
$string['searchresultdesctext'] = 'Mostrando resultados para';
$string['noresultfoundmg'] = "<h4 class ='p-p-6 text-center m-0 '>Nenhum resultado encontrado</h4>";

$string['enrol_relatedcourses'] = 'Cursos Relacionados';
$string['enrol_latestcourses'] = 'Últimos Cursos';
$string['enrol_coursecardesc'] = 'Descubra o seu programa perfeito em nossos cursos.';
$string['enrol_viewall'] = 'Ver Todos';

$string['showrelatedcourse'] = "Mostrar Cursos Relacionados";
$string['showrelatedcoursedesc'] = "Ative essa configuração para mostrar os cursos relacionados na página de matrícula.";

$string['showlatestcourse'] = 'Mostrar Últimos Cursos';
$string['showlatestcoursedesc'] = 'Ative essa configuração para mostrar o último curso na página de matrícula.';

$string['latestcoursecount'] = 'Contagem de Blocos de Últimos Cursos';
$string['latestcoursecountdesc'] = 'Defina um número para os últimos cursos exibidos na página de matrícula';

$string['allcourescattext'] = 'Todas as categorias';
$string['archivecoursecounttext'] = 'Cursos';
$string['coursecardlessonstext'] = 'lições';
$string['prevsectionbuttontext'] = 'Seção Anterior';
$string['nextsectionbuttontext'] = 'Próxima Seção';

$string['eight'] = '8';
$string['twelve'] = '12';
$string['sixteen'] = '16';
$string['twenty'] = '20';

// Minha Página de Curso.
$string['resume'] = 'Currículo';
$string['start'] = 'Início';
$string['completed'] = 'Concluído';

$string['siteannouncementheading'] = 'Anúncio em todo o site';
$string['siteannouncementheadingdesc'] = 'Ative o anúncio em todo o site para todos os usuários.';
$string['seosettingsheading'] = 'Configurações de SEO';
$string['seosettingsheadingdesc'] = 'Otimize a visibilidade do seu site nos mecanismos de pesquisa.';
$string['sitecustomizationhead'] = 'Personalização do site';
$string['sitecustomizationheaddesc'] = 'Escolha as fontes, o tamanho do layout das páginas e você pode personalizar com o CSS.';
$string['advancefeatureshead'] = 'Configurações de recursos avançados';
$string['advancefeaturesheaddesc'] = 'Melhore sua experiência de aprendizado com configurações avançadas.';
$string['mainfooterareahead'] = 'Área principal do rodapé';
$string['mainfooterareaheaddesc'] = 'Configuração da área principal do rodapé';

// heading-advance weight settings
$string['heading-adv-setting'] = 'Configurações de peso de fonte';
$string['heading-regular-fontweight'] = 'Peso de fonte regular';
$string['heading-semibold-fontweight'] = 'Peso de fonte semibold';
$string['heading-bold-fontweight'] = 'Peso de fonte negrito';
$string['heading-exbold-fontweight'] = 'Peso de fonte extranegrito';

// Usage tracking.
$string["usagedatatracker"] = "Rastreador de dados de uso";
$string['enableusagetracking'] = "Habilitar rastreamento de uso";
$string['enableusagetrackingdesc'] = "<strong>AVISO DE RASTREAMENTO DE USO</strong>

<hr class='text-muted' />
<p>A partir de agora, a Edwiser coletará dados anônimos para gerar estatísticas de uso do produto.</p>
<p>Essas informações nos ajudarão a orientar o desenvolvimento na direção certa e a comunidade Edwiser a prosperar.</p>
<p>Dito isso, não coletamos seus dados pessoais nem os de seus alunos durante esse processo. Você pode desativar isso do plugin sempre que desejar sair deste serviço.</p>
<p>Uma visão geral dos dados coletados está disponível <strong><a href='https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products' target='_blank'>aqui</a></strong>.</p>";

$string['profileinterestinfo'] = 'Para editar interesses, vá para Configurações de Perfil -> Editar Perfil ->';
$string['profileinterest'] = 'Interesses';
$string['citytowntext'] = 'Cidade';
$string['selectcountrystring'] = 'Selecione um país...';

$string['heading-fontweight_desc'] = 'Definir o peso da fonte dos cabeçalhos para todo o site.';
$string['small-para-fontweight_desc'] = 'Definir o peso da fonte para pequenos parágrafos em todo o site.';
$string['small-info-fontweight_desc'] = 'Definir o peso da fonte para pequenas informações em todo o site.';

$string['full-width-top'] = 'Parte Superior de Largura Total';
$string['full-bottom'] = 'Parte Inferior de Largura Total';

$string['homepageedwpagebuilderoption'] = "Use o Edwiser Pagebuilder para a página inicial";

$string['livecustomizer'] = "Personalizador ao Vivo";

$string['loaderimagehead'] = 'Imagem de Carregamento do Site';
$string['loaderimagedesc'] = 'Escolha a imagem de carregamento para o seu site';

$string['region-full-bottom'] = 'Região de largura total inferior';
$string['region-full-width-top'] = 'Região de largura total superior';

$string['homepagetransparentheadertitle'] = 'Estilo de Cabeçalho Transparente da Página Inicial';
$string['homepagetransparentheaderdesc'] = "Torne o cabeçalho da sua página inicial transparente";

$string['frontpageheadercolortitle'] = 'Escolher cor do texto do cabeçalho';
$string['frontpageheadercolordesc'] = "Escolher cor do texto do cabeçalho";

$string['transparentheaderheader'] = 'Estilo do cabeçalho da página inicial';
$string['transparentheaderheaderdesc'] = 'Ativar/desativar estilo de cabeçalho transparente';

$string['hidehomepageelement'] = 'Ocultar Elementos da Página Inicial';
$string['hidehomepageelementdesc'] = 'Ocultar cabeçalho do conteúdo, subnavegação e seção de atividade';

$string['hideheadercontenttitle'] = 'Ocultar Cabeçalho de Conteúdo';
$string['hideheadercontentdesc'] = 'Se ativado, o Nome do Site e a navegação secundária do Moodle serão removidos na página inicial';

$string['hideactivitysectiontitle'] = 'Ocultar Seção de Atividade';
$string['hideactivitysectiondesc'] = 'Se ativado, a seção de atividade será ocultada na página inicial.';

$string['floataddblockbtnregionselectionmsg'] = 'Os novos blocos serão adicionados na região "{$a}" visível atualmente';

// settings page deprication design strings
$string['settingpage-dep-top-above-st'] = 'Clique em \'Página Inicial do Site\' na barra de navegação para ir ao \'Construtor de Página Inicial\' e criar sua própria página inicial';
$string['settingpage-dep-top-st1'] = 'Apresentamos uma maneira melhor de criar e personalizar páginas iniciais!';
$string['settingpage-dep-top-st2'] = 'Estamos animados em apresentar o Edwiser RemUI Page Builder para criar páginas iniciais, junto com uma nova biblioteca de modelos composta por mais de 30 modelos de blocos e 7 layouts de página inicial';
$string['settingpage-dep-top-st3'] = '1. Atualize o Edwiser RemUI Page Builder para a versão v4.2.0 ou superior <a href="https://edwiser.org/my-account/" target="_blank">aqui</a>';

$string['settingpagedepbottomst1'] = 'Selecione o Page Builder no menu suspenso acima e vá para a página inicial para criar um novo design de página inicial.';
$string['settingpagedepbottomst2'] = 'Saiba Mais';
$string['settingpagedepbottomst3'] = 'OU';

$string['settingpagedepbottomsecondaryst1'] = 'Migre automaticamente o conteúdo do seu construtor de página inicial para o Edwiser Page Builder.';
$string['settingpagedepbottomsecondaryst2'] = '<span class="para-semibold-1 m-0">Observação:</span> É necessário a versão v4.2.0 do plugin Edwiser RemUI page builder e a versão v4.1.3 do plugin Homepage builder.';
$string['settingpagedepbottomsecondaryst3'] = 'O que acontecerá?';
$string['settingpagedepbottomsecondaryst4'] = 'O código e o conteúdo de cada seção da página inicial atual serão movidos para um bloco HTML personalizado no Edwiser RemUI Page Builder. O design e o conteúdo da página permanecerão os mesmos, e você poderá editá-los facilmente de forma <strong>sem a necessidade de código usando o Edwiser RemUI Page Builder</strong>.';
$string['settingpagedepbottomsecondaryst5'] = '<span class="para-semibold-1 m-0">Observação:</span> Esta é a última atualização relacionada ao Homepage Builder. Ele foi fundido agora no Edwiser Page Builder.';


$string['upgradeherelinktext'] = 'atualizar aqui';

$string['addnewpage'] = "Adicionar uma nova página";

$string['edwiserfeedback'] = "Feedback do Edwiser";
$string['edwiserhelp'] = "Ajuda do Moodle";
$string['edwisersupport'] = "Suporte do Edwiser";


// Novas configurações e melhorias na página do curso
$string['courseinfocontrolhead'] = "Controle de Informações do Curso";
$string['courseinfocontroldesc'] = "Controle a visibilidade de informações relacionadas ao curso em todo o site";

$string['coursedatevisibilityhead'] = "Mostrar 'Data' no curso";
$string['coursedatevisibilitydesc'] = "Mostrar 'Data' no curso";

$string['hidedate'] = "Não mostrar";
$string['showstartdate'] = "Mostrar data de início";
$string['showupdatedate'] = "Mostrar data de 'Atualização'";
$string['showstartwhenend'] = "Mostrar 'Data de início' quando 'Data de término' estiver definida";


$string['enrolleduserscountvisibilityhead'] = "Mostrar informações de ‘Alunos matriculados’";
$string['enrolleduserscountvisibilitydesc'] = "Desative para ocultar as informações de ‘Alunos matriculados’";

$string['lessonsvisiblityoncoursecardhead'] = "Mostrar informações de ‘Lições’";
$string['lessonsvisiblityoncoursecarddesc'] = "Desative para ocultar as informações de ‘Lições'";

$string['coursecardsettingshead'] = "Configurações do Cartão do Curso";
$string['coursecardsettingsdesc'] = "Configurações relacionadas ao cartão do curso";

$string['headeroverlayopacityhead'] = "Alterar a opacidade da sobreposição";
$string['headeroverlayopacitydesc'] = "O valor padrão já está definido como '100'. Para ajustar a opacidade, por favor, insira um valor entre 0 e 100";

$string['showless'] = 'Mostrar Menos';
$string['showmore'] = 'Mostrar Mais';

$string['coursestarted'] = "Iniciado:";
$string['courseupdated'] = "Atualizado:";

$string['coursecardlessonssingletext'] = 'Aula';
$string['coursecardsenrolledetxt'] = 'Matriculado';

$string['showenrolledtexthead'] = 'Mostrar título \'Matriculado\'';
$string['showenrolledtextdesc'] = '';


$string['showenrolledtextinputhead'] = '';
$string['showenrolledtextinputdesc'] = 'Renomeie o título \'Enrolled\'.<br><strong>Máximo de 8 caracteres recomendado</strong>';
$string['showenrolledtextinputdefaulttext'] = 'Enrolled';

$string['showlessontexthead'] = 'Mostrar título \'Lições\'';
$string['showlessontextdesc'] = '';


$string['showlessontextinputhead'] = '';
$string['showlessontextinputdesc'] = 'Renomeie o título \'Lessons\'.<br><strong>Máximo de 8 caracteres recomendado</strong>';
$string['showlessontextinputdefaulttext'] = 'Lessons';

$string['editcoursetitle'] = 'Editar título do curso';
$string['changecategory'] = 'Mudar categoria';
$string['editreviewapproval'] = 'Editar aprovação de revisão';
$string['addchangevideo'] = 'Adicionar/Mudar vídeo';
$string['novideomessage'] = 'Não há vídeo.<br>Clique no link acima para adicionar um vídeo.';
$string['changecourseimage'] = 'Mudar imagem do curso';
$string['changebtntextandlink'] = 'Adicionar link e preço';
$string['edit'] = 'Editar';
$string['viewalltext'] = 'Ver tudo';
$string['addremuicustomfield'] = 'Adicionar campo personalizado RemUI';
$string['editremuicustomfield'] = 'Editar campo personalizado RemUI';
$string['howtoaddcustomfield'] = 'Como \'Adicionar e Editar\' campos personalizados RemUI?';
$string['changebtntext'] = 'Mudar texto do botão';
$string['addlink'] = 'Adicionar link';
$string['save'] = 'Salvar';
$string['cancel'] = 'Cancelar';
$string['updateenrollmentmethods'] = 'Atualizar Métodos de Matrícula <span class="text-lowercase">{$a}</span>';
$string['hideenrollmentoptions'] = 'Ocultar Opções de Matrícula <span class="text-lowercase">{$a}</span>';
$string['showenrollmentoptions'] = 'Mostrar Opções de Matrícula <span class="text-lowercase">{$a}</span>';
$string['editcoursetext'] = 'Editar texto do curso';
$string['editcoursecontent'] = 'Editar conteúdo do curso';
$string['manageinstructors'] = 'Gerenciar instrutores';
$string['message'] = 'Mensagem';
$string['email'] = 'Email:';
$string['editcoursessectionsettings'] = 'Editar configurações da seção de cursos';
$string['sectionishiddenmessage'] = 'Esta seção está oculta.<br>Para torná-la visível, clique no link acima \'Mostrar opções de inscrição\'';
$string['noreviewmessage'] = 'Atualmente, não há revisão.<br>Para verificar revisões \'Pendentes de aprovação\', clique no link \'Editar aprovação de revisão\'.';
$string['backtothecourse'] = 'Voltar para o curso';
$string['viewcourseenrollmentpage'] = 'Ver Página de Matrícula do Curso <span class="text-lowercase">{$a}</span>';
$string['unenroll'] = 'Cancelar inscrição';
$string['toactivateenrollmenttext'] = 'você mesmo para ativar o link da página de inscrição';
$string['showhidefreelabel'] = 'Mostrar/Ocultar etiqueta \'GRÁTIS\'';
$string['norelatedcoursemessage'] = 'A seção \'Cursos relacionados\' está oculta.<br>Para torná-la visível, clique no link acima \'Editar configurações da seção de cursos\'';
$string['nolatestcoursemessage'] = 'A seção \'Últimos cursos\' está oculta.<br>Para torná-la visível, clique no link acima \'Editar configurações da seção de cursos\'';
$string['showhidefreelabel'] = 'Mostrar/Ocultar etiqueta \'GRÁTIS\'';
$string['editpricing'] = 'Editar preços';
$string['nocontentmessage'] = 'Não há conteúdo nesta seção.<br>Para adicionar conteúdo, clique no link acima \'Editar texto do curso\'';
$string['noinstructormessage'] = 'Não há instrutor inscrito neste curso.<br>Para adicionar um instrutor, clique no link acima \'Gerenciar instrutores\'';
$string['noinstructor'] = 'Sem instrutor';



$string['enrolment_payment'] = 'Exibir rótulo \'GRÁTIS\' em cursos com custo de inscrição \'0\'';
$string['enrolment_payment_desc'] = 'Essa configuração decide se um rótulo "GRÁTIS" aparece para cursos sem taxas de inscrição. Se definido como "Não", o rótulo não aparecerá na página de inscrição.';
$string['allrequirepayment'] = 'Não';
$string['somearefree'] = 'Sim';
$string['allarefree'] = 'Todos os cursos são gratuitos';
$string['curatedby'] = 'Instrutores';
$string['length'] = 'Duração';
$string['enrolleduserscountvisibilityhead'] = "Mostrar informações de ‘Alunos matriculados’";
$string['enrolleduserscountvisibilitydesc'] = "Desative para ocultar as informações de ‘Alunos matriculados’";
$string['lessonsvisiblityoncoursecardhead'] = "Mostrar informações de ‘Lições’";
$string['lessonsvisiblityoncoursecarddesc'] = "Desative para ocultar as informações de ‘Lições'";


$string['enrolnow'] = 'Agora {$a}';
$string['updateenrollmentmethods'] = 'Atualizar Métodos de Matrícula <span class="text-lowercase">{$a}</span>';
$string['hideenrollmentoptions'] = 'Ocultar Opções de Matrícula <span class="text-lowercase">{$a}</span>';
$string['showenrollmentoptions'] = 'Mostrar Opções de Matrícula <span class="text-lowercase">{$a}</span>';
$string['viewcourseenrollmentpage'] = 'Ver Página de Matrícula do Curso <span class="text-lowercase">{$a}</span>';

$string['darkmodetitilestring'] = 'Modo Escuro';
$string['lightmodetitlestring'] = 'Modo Claro';
$string['darkmodesettingshead'] = 'Configurações do Modo Escuro';
$string['darkmodesettingsheaddesc'] = 'Controle o modo claro e escuro do seu site';
$string['enabledarkmode'] = 'Ativar funcionalidade de modo escuro';
$string['enabledarkmodedesc'] = '';
$string['dmoption_disable'] = 'Desativar';
$string['dmoption_allowonallpages'] = 'Permitir em todas as páginas';
$string['dmoption_excludepages'] = 'Permitir em todas as páginas, exceto estas páginas';
$string['dmoption_includepages'] = 'Permitir apenas nessas páginas';
$string['darkmodeincludepages'] = 'Incluir apenas nessas páginas';
$string['darkmodeincludepagesdesc']  = '<div><strong>Para gerenciar o modo escuro em páginas específicas, basta adicionar a URL da página.</strong>
<pre>Exemplo:
    Para incluir/excluir o modo escuro em uma página de curso específica (por exemplo, o curso com id=2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>Para gerenciar o modo escuro em um grupo de páginas</strong>
<pre>Exemplo:
    Para incluir/excluir o modo escuro em todas as páginas de curso
    <moodlesite.com>/course/view.php%
</pre>
Para uma explicação mais detalhada <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">clique aqui</a>.</div>';

$string['darkmodeexcludepages'] = 'Excluir páginas';
$string['darkmodeexcludepagesdesc']  = '<div><strong>Para gerenciar o modo escuro em páginas específicas, basta adicionar a URL da página.</strong>
<pre>Exemplo:
    Para incluir/excluir o modo escuro em uma página de curso específica (por exemplo, o curso com id=2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>Para gerenciar o modo escuro em um grupo de páginas</strong>
<pre>Exemplo:
    Para incluir/excluir o modo escuro em todas as páginas de curso
    <moodlesite.com>/course/view.php%
</pre>
Para uma explicação mais detalhada <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">clique aqui</a>.</div>';

$string['customizerdarkmodewarning'] = "Esteja ciente de que as alterações feitas no Personalizador Visual serão aplicadas no 'modo claro' do site e serão automaticamente refletidas no 'modo escuro' também.";
$string['customizerdarkmodedonotshowbtntext'] = 'Não mostrar novamente';
$string['customizerdarkmodeok'] = 'Ok';
$string['previewswitchon'] = 'Ativar';
$string['previewswitchoff'] = 'Desativar';
$string['darkmodepreview'] =  'Pré-visualização do Modo Escuro';
$string['darkmodecustomizernote']='<li>No \'personalizador visual\', todas as alterações serão feitas no \'modo claro\' do site, e isso será automaticamente refletido no \'modo escuro\'.</li>
<li>As configurações do personalizador visual serão desativadas durante a pré-visualização no modo escuro.</li>';
$string["switchtodm"] = "Modo Escuro";
$string["switchtolm"] = "Modo Claro";
$string["disabledmwarning"] = "Para habilitar o personalizador visual, desative a pré-visualização do modo escuro.";


$string["here"] = "aqui";
$string["clickhere"] = "Clique aqui";
$string["settingpagedepbottomsecondaryst2b"] = '<a href="https://edwiser.org/my-account/" target="_blank" >Clique aqui</a> para baixar e atualizar os plugins para sua versão mais recente.';
$string['settingpage-dep-top-st4'] = '1. Baixe e instale o Construtor de Página da Edwiser RemUI para a versão v4.2.0 e superior em <a href="https://edwiser.org/my-account/" target="_blank">aqui</a>';
$string['viewcoursetitle'] = 'Ver Curso';
$string['okay'] = 'Okay!';
$string['forcefulmigrate'] = 'Migração Forçada';

$string['moodleblocks'] = 'Blocos do Moodle';

$string['citytown'] = 'Cidade';
$string['searchtext'] = 'Texto de busca';
$string['enablesiteloader'] = "Ativar/Desativar imagem de carregamento";
$string['enablesiteloaderdesc'] = "Para desativar o GIF de carregamento no site, desmarque a caixa chamada \"Ativar/Desativar imagem de carregamento\". Para ativá-lo, basta marcar a caixa.";
$string['aria:courseimage'] = 'Imagem do curso';

$string['addcustomprice'] = 'Adicionar um preço personalizado';
$string['enablepricingsettingstext'] = 'Ativar o preço padrão removerá o “preço personalizado e o link de inscrição personalizado”.';
$string['enabledefaultpricing'] = 'Ativar preço padrão';
$string["dashboardstatsupdate"] = "Atualização de estatísticas RemUI";

$string["filters"] = "Filtros";
$string["applyfilters"] = "Aplicar filtros";
$string["clear"] = "Limpar";
$string["level"] = "Nível";
$string["ratings"] = "Avaliações";
$string["free"] = "Gratuito";
$string["paid"] = "Pago";
$string["rating4"] = "4 e acima";
$string["rating3"] = "3 e acima";
$string["newest"] = "Mais recente";
$string["oldest"] = "Mais antigo";
$string["highrating"] = "Alta classificação";
$string["lowrating"] = "Baixa classificação";
$string["date"] = "Data";
$string["alphabetical"] = "Alfabético";
$string["showcourseperpage"] = "Mostrar curso por página";
$string["close"] = "Fechar";
$string["row2"] = "Mostrar:2 linha";
$string["row3"] = "Mostrar:3 linhas";
$string["row4"] = "Mostrar:4 linhas";
$string["row5"] = "Mostrar:5 linhas";
$string["row6"] = "Mostrar:6 linhas";

$string["filteremptymsg"] = "NOTA: Para visualizar os filtros, adicione propriedades de filtro, como Níveis, Preço, Avaliações e Idiomas ao curso.";

$string['sectionaddmax'] = 'Você atingiu o número máximo de seções permitidas para um curso...';
$string['prevsubsectionbuttontext'] = 'Subseção anterior';
$string['nextsubsectionbuttontext'] = 'Próxima subseção';