<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_remui
 * @copyright (c) 2023 WisdmLabs (https://wisdmlabs.com/) <support@wisdmlabs.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'Configuración avanzada';
$string['backgroundimage'] = 'Imagen de fondo';
$string['backgroundimage_desc'] = 'La imagen que se mostrará como fondo del sitio. La imagen de fondo que cargues aquí anulará la imagen de fondo en tus archivos de preajuste de tema.';
$string['brandcolor'] = 'Color de marca';
$string['brandcolor_desc'] = 'El color de la marca.';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'Un bootswatch es un conjunto de variables de Bootstrap y css para dar estilo a Bootstrap';
$string['choosereadme'] = 'Edwiser RemUI es un tema personalizable de Moodle diseñado para mejorar tu experiencia de eLearning al abordar desafíos como la personalización limitada y problemas de la interfaz de usuario. Con su diseño moderno e intuitivo y sus características integrales, puedes crear fácilmente un sitio visualmente impresionante y con tu propia marca que aumente el compromiso de los estudiantes y brinde una experiencia que los alumnos amarán.';
$string['currentinparentheses'] = '(actual)';
$string['configtitle'] = 'Edwiser RemUI';
$string['generalsettings'] = 'Básico';
$string['loginbackgroundimage'] = 'Imagen de fondo de la página de inicio de sesión';
$string['loginbackgroundimage_desc'] = 'La imagen que se mostrará como fondo para el formulario de inicio de sesión.';
$string['nobootswatch'] = 'Ninguno';
$string['pluginname'] = 'Edwiser RemUI';
$string['presetfiles'] = 'Archivos de preajuste de tema adicionales';
$string['presetfiles_desc'] = 'Los archivos de preajuste se pueden utilizar para alterar drásticamente la apariencia del tema. Consulta <a href="https://docs.moodle.org/dev/remui_Presets">remui presets</a> para obtener información sobre cómo crear y compartir tus propios archivos de preajuste, y consulta el <a href="https://archive.moodle.net/remui">Repositorio de preajustes</a> para ver los preajustes que otros han compartido.';
$string['preset'] = 'Preajuste de tema';
$string['preset_desc'] = 'Elige un preajuste para cambiar ampliamente la apariencia del tema.';
$string['privacy:metadata'] = 'El tema remui no almacena ningún dato personal sobre ningún usuario.';
$string['rawscss'] = 'SCSS crudo';
$string['rawscss_desc'] = 'Utiliza este campo para proporcionar código SCSS o CSS que se inyectará al final de la hoja de estilos.';

// Deprecated since Moodle 4.0.
$string['totop'] = 'Ir al inicio';

// Edwiser RemUI Settings Page Strings.

// Settings Tabs strings.
$string['homepagesettings'] = 'Página de inicio';
$string['coursesettings'] = "Página de curso";
$string['footersettings'] = 'Pie de página';
$string["formsettings"] = "Formularios";
$string["iconsettings"] = "Iconos";
$string['loginsettings'] = 'Página de inicio de sesión';

$string['versionforheading'] = '<span class="small remuiversion"> Versión {$a}</span>';
$string['themeversionforinfo'] = '<span>Versión instalada actualmente: Edwiser RemUI v{$a}</span>';

// General Settings.
$string['mergemessagingsidebar'] = 'Combinar panel de mensajes';
$string['mergemessagingsidebardesc'] = 'Combinar el panel de mensajes en la barra lateral derecha';
$string['logoorsitename'] = 'Elegir formato de logotipo del sitio';
$string['logoorsitenamedesc'] = 'Solo logotipo - Logotipo de marca grande<br /> Logotipo mini - Logotipo de marca mini <br /> Solo icono - Un icono como marca <br/> Icono y nombre del sitio - Icono con nombre del sitio';
$string['onlylogo'] = 'Solo logotipo';
$string['logo'] = 'Logotipo';
$string['logomini'] = 'Logotipo mini';
$string['icononly'] = 'Solo icono';
$string['iconsitename'] = 'Icono y nombre del sitio';
$string['logodesc'] = 'Puedes agregar el logotipo que se mostrará en el encabezado. Nota: La altura preferida es de 50px. En caso de que desees personalizarlo, puedes hacerlo desde el cuadro de CSS personalizado.';
$string['logominidesc'] = 'Puedes agregar el logotipo mini que se mostrará en el encabezado cuando se contraiga la barra lateral. Nota: La altura preferida es de 50px. En caso de que desees personalizarlo, puedes hacerlo desde el cuadro de CSS personalizado.';
$string['siteicon'] = 'Icono del sitio';
$string['siteicondesc'] = '¿No tienes un logotipo? Puedes elegir uno de esta <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new" ><b style="color:#17a2b8!important">lista</b></a>. <br /> Solo ingresa el texto después de "fa-".';
$string['navlogin_popup'] = 'Habilitar ventana emergente de inicio de sesión';
$string['navlogin_popupdesc'] = 'Habilitar la ventana emergente de inicio de sesión para iniciar sesión rápidamente sin redirigir a la página de inicio de sesión.';
$string['coursecategories'] = 'Categorías';
$string['enablecoursecategorymenu'] = "Menú desplegable de categorías en el encabezado";
$string['enablecoursecategorymenudesc'] = "Mantén esto habilitado si deseas mostrar el menú desplegable de categorías en el encabezado";
$string['coursepagesettings'] = "Página de curso";
$string['coursepagesettingsdesc'] = "Configuración relacionada con los cursos.";
$string['coursecategoriestext'] = "Renombrar el menú desplegable de categorías en el encabezado";
$string['coursecategoriestextdesc'] = "Puedes agregar un nombre personalizado para el menú desplegable de categorías en el encabezado.";
$string['enablerecentcourses'] = 'Habilitar cursos recientes';
$string['enablerecentcoursesdesc'] = 'Si se habilita, el menú desplegable de cursos recientes se mostrará en el encabezado.';
$string['recent'] = 'Recientes';
$string['recentcoursesmenu'] = 'Menú de cursos recientes';
$string['searchcatplaceholdertext'] = 'Buscar categorías';
$string['viewallnotifications'] = 'Ver todas las notificaciones';
$string['forgotpassword'] = '¿Olvidaste tu contraseña?';
$string['enableannouncement'] = "Habilitar anuncio para todo el sitio";
$string['enableannouncementdesc'] = "Habilitar anuncio para todo el sitio para todos los usuarios.";
$string['enabledismissannouncement'] = "Habilitar anuncio para todo el sitio que se pueda descartar";
$string['enabledismissannouncementdesc'] = "Si se habilita, permitirá a los usuarios descartar el anuncio.";
$string['brandlogo'] = 'Logotipo de marca';
$string['brandname'] = 'Nombre de marca';

$string['announcementtext'] = "Anuncio";
$string['announcementtextdesc'] = "Mensaje de anuncio que se mostrará en todo el sitio.";
$string['announcementtype'] = "Tipo de anuncio";
$string['announcementtypedesc'] = "Selecciona el tipo de anuncio para mostrar un color de fondo diferente para el anuncio.";
$string['typeinfo'] = "Información";
$string['typedanger'] = "Urgente";
$string['typewarning'] = "Advertencia";
$string['typesuccess'] = "Éxito";

// Google Analytics.
$string['googleanalytics'] = 'ID de seguimiento de Google Analytics';
$string['googleanalyticsdesc'] = 'Por favor, ingresa tu ID de seguimiento de Google Analytics para habilitar Analytics en tu sitio web. El formato de la ID de seguimiento debe ser como [UA-XXXXX-Y].<br/>Ten en cuenta que al incluir esta configuración, estarás enviando datos a Google Analytics y debes asegurarte de que tus usuarios estén advertidos sobre esto. Nuestro producto no almacena ninguno de los datos que se envían a Google Analytics.';
$string['favicon'] = 'Favicon';
$string['favicosize'] = 'El tamaño esperado es de 16x16 píxeles';
$string['favicondesc'] = 'El "icono favorito" de tu sitio. Es un recordatorio visual de la identidad del sitio web y se muestra en la barra de direcciones o en las pestañas del navegador';
$string['fontselect'] = 'Selector de tipo de fuente';
$string['fontselectdesc'] = 'Elige entre fuentes estándar o <a href="https://fonts.google.com/" target="_new">tipos de fuentes web de Google</a>. Por favor, guarda para mostrar las opciones de tu elección. Nota: Si la fuente del personalizador visual está configurada como Estándar, entonces se aplicará la fuente web de Google.';
$string['fontname'] = 'Fuente del sitio';
$string['fontnamedesc'] = 'Ingresa el nombre exacto de la fuente que se utilizará para Moodle.';
$string['fonttypestandard'] = 'Fuente estándar';
$string['fonttypegoogle'] = 'Fuente web de Google';

$string['sendfeedback'] = "Enviar comentarios a Edwiser";
$string['enableedwfeedback'] = "Comentarios y soporte de Edwiser";
$string['enableedwfeedbackdesc'] = "Habilitar comentarios y soporte de Edwiser, visible solo para administradores.";
$string["checkfaq"] = "Edwiser RemUI - Consultar FAQ";
$string['poweredbyedwiser'] = 'Desarrollado por Edwiser';
$string['poweredbyedwiserdesc'] = 'Desmarcar para eliminar "Desarrollado por Edwiser" de tu sitio.';
$string['enabledictionary'] = 'Habilitar diccionario';
$string['enabledictionarydesc'] = 'Si se habilita, la función de diccionario se activará y mostrará el significado del texto seleccionado en una ventana emergente.';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Puedes personalizar el CSS desde el cuadro de texto anterior. Los cambios se reflejarán en todas las páginas de tu sitio.';
// Footer Content.
$string['followus'] = 'Síguenos';
$string['poweredby'] = 'Desarrollado por';

// One click report  bug/feedback.
$string['sendfeedback'] = "Enviar comentarios a Edwiser";
$string['descriptionmodal_text1'] = "<p>Los comentarios te permiten enviarnos sugerencias sobre nuestros productos. Damos la bienvenida a los informes de problemas, ideas de funciones y comentarios generales.</p><p>Comienza escribiendo una breve descripción:</p>";
$string['descriptionmodal_text2'] = "<p>A continuación, te permitiremos identificar las áreas de la página relacionadas con tu descripción.</p>";
$string['emptydescription_error'] = "Por favor, ingresa una descripción.";
$string['incorrectemail_error'] = "Por favor, ingresa un ID de correo electrónico válido.";

$string['highlightmodal_text1'] = "Haz clic y arrastra sobre la página para ayudarnos a comprender mejor tus comentarios. Puedes mover este cuadro de diálogo si está estorbando.";
$string['highlight_button'] = "Resaltar área";
$string['blackout_button'] = "Ocultar información";
$string['highlight_button_tooltip'] = "Resalta las áreas relevantes para tus comentarios.";
$string['blackout_button_tooltip'] = "Oculta cualquier información personal.";

$string['feedbackmodal_next'] = 'Tomar captura de pantalla y continuar';
$string['feedbackmodal_skipnext'] = 'Omitir y continuar';
$string['feedbackmodal_previous'] = 'Atrás';
$string['feedbackmodal_submit'] = 'Enviar';
$string['feedbackmodal_ok'] = '¡Okay!';

$string['description_heading'] = 'Descripción';
$string['feedback_email_heading'] = 'Correo electrónico';
$string['additional_info'] = 'Información adicional';
$string['additional_info_none'] = 'Ninguna';
$string['additional_info_browser'] = 'Información del navegador';
$string['additional_info_page'] = 'Información de la página';
$string['additional_info_pagestructure'] = 'Estructura de la página';
$string['feedback_screenshot'] = 'Captura de pantalla';
$string['feebdack_datacollected_desc'] = 'Una descripción general de los datos recopilados está disponible <strong><a href="https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products" target="_blank">aquí</a></strong>.';

$string['submit_loading'] = 'Cargando...';
$string['submit_success'] = 'Gracias por tus comentarios. Valoramos cada comentarioque recibimos.';
$string['submit_error'] = 'Lamentablemente ocurrió un error mientras se enviaban tus comentarios. Por favor, inténtalo de nuevo.';
$string['send_feedback_license_error'] = "Por favor, activa la licencia en la configuración de RemUI para obtener soporte del producto.";
$string['disabled'] = 'Deshabilitado';

$string['nocoursefound'] = 'No se encontró ningún curso';

$string['pagewidth'] = 'Diseño del tema';
$string['pagewidthdesc'] = 'Aquí puedes elegir el tamaño del diseño para las páginas.';
$string['defaultpermoodle'] = 'Ancho estrecho (predeterminado de Moodle)';
$string['fullwidthlayout'] = 'Ancho completo';

// Footer Page Settings.
$string['footersettings'] = 'Pie de página';
$string['socialmedia'] = 'Redes sociales';
$string['socialmediadesc'] = 'Ingresa los enlaces de redes sociales para tu sitio.';
$string['facebooksetting'] = 'Facebook';
$string['facebooksettingdesc'] = 'Ingresa el enlace de la página de Facebook de tu sitio. Por ejemplo: https://www.facebook.com/nombrepagina';
$string['twittersetting'] = 'Twitter';
$string['twittersettingdesc'] = 'Ingresa el enlace de la página de Twitter de tu sitio. Por ejemplo: https://www.twitter.com/nombrepagina';
$string['linkedinsetting'] = 'Linkedin';
$string['linkedinsettingdesc'] = 'Ingresa el enlace de la página de Linkedin de tu sitio. Por ejemplo: https://www.linkedin.com/in/nombrepagina';
$string['gplussetting'] = 'Google Plus';
$string['gplussettingdesc'] = 'Ingresa el enlace de la página de Google Plus de tu sitio. Por ejemplo: https://plus.google.com/nombrepagina';
$string['youtubesetting'] = 'YouTube';
$string['youtubesettingdesc'] = 'Ingresa el enlace de la página de YouTube de tu sitio. Por ejemplo: https://www.youtube.com/channel/UCU1u6QtAAPJrV0v0_c2EISA';
$string['instagramsetting'] = 'Instagram';
$string['instagramsettingdesc'] = 'Ingresa el enlace de la página de Instagram de tu sitio. Por ejemplo: https://www.instagram.com/nombre';
$string['pinterestsetting'] = 'Pinterest';
$string['pinterestsettingdesc'] = 'Ingresa el enlace de la página de Pinterest de tu sitio. Por ejemplo: https://www.pinterest.com/nombre';
$string['quorasetting'] = 'Quora';
$string['quorasettingdesc'] = 'Ingresa el enlace de la página de Quora de tu sitio. Por ejemplo: https://www.quora.com/nombre';
$string['footerbottomtext'] = 'Texto inferior izquierdo del pie de página';
$string['footerbottomlink'] = 'Enlace inferior izquierdo del pie de página';
$string['footerbottomlinkdesc'] = 'Ingresa el enlace para la sección inferior izquierda del pie de página. Por ejemplo: http://www.tuempresa.com';
$string['footercolumn1heading'] = 'Contenido del pie de página para la 1ra columna (izquierda)';
$string['footercolumn1headingdesc'] = 'Esta sección se relaciona con la parte inferior (Columna 1) de tu página de inicio.';
$string['footercolumn1title'] = 'Título de la 1ra columna del pie de página';
$string['footercolumn1titledesc'] = 'Agrega un título a esta columna.';
$string['footercolumncustomhtml'] = 'Contenido';
$string['footercolumn1customhtmldesc'] = 'Puedes personalizar el HTML de esta columna utilizando el cuadro de texto anterior.';
$string['footercolumn2heading'] = 'Contenido del pie de página para la 2da columna (centro)';
$string['footercolumn2headingdesc'] = 'Esta sección se relaciona con la parte inferior (Columna 2) de tu página de inicio.';
$string['footercolumn2title'] = 'Título de la 2da columna del pie de página';
$string['footercolumn2titledesc'] = 'Agrega un título a esta columna.';
$string['footercolumn2customhtml'] = 'HTML personalizado';
$string['footercolumn2customhtmldesc'] = 'Puedes personalizar el HTML de esta columna utilizando el cuadro de texto anterior.';
$string['footercolumn3heading'] = 'Contenido del pie de página para la 3ra columna (centro)';
$string['footercolumn3headingdesc'] = 'Esta sección se relaciona con la parte inferior (Columna 3) de tu página de inicio.';
$string['footercolumn3title'] = 'Título de la 3ra columna del pie de página';
$string['footercolumn3titledesc'] = 'Agrega un título a esta columna.';
$string['footercolumn3customhtml'] = 'HTML personalizado';
$string['footercolumn3customhtmldesc'] = 'Puedes personalizar el HTML de esta columna utilizando el cuadro de texto anterior.';
$string['footercolumn4heading'] = 'Contenido del pie de página para la 4ta columna (derecha)';
$string['footercolumn4headingdesc'] = 'Esta sección se relaciona con la parte inferior (Columna 4) de tu página de inicio.';
$string['footercolumn4title'] = 'Título de la 4ta columna del pie de página';
$string['footercolumn4titledesc'] = 'Agrega un título a esta columna.';
$string['footercolumn4customhtml'] = 'HTML personalizado';
$string['footercolumn4customhtmldesc'] = 'Puedes personalizar el HTML de esta columna utilizando el cuadro de texto anterior.';
$string['footerbottomheading'] = 'Configuración del pie de página inferior';
$string['footerbottomdesc'] = 'Aquí puedes especificar tu propio enlace que deseas ingresar en la sección inferior del pie de página';
$string['footerbottomtextdesc'] = 'Agrega texto a la configuración del pie de página inferior.';
$string['footercopyrightsshow'] = 'mostrar';
$string['footercopyright'] = 'Mostrar contenido de derechos de autor';
$string['footercopyrights'] = '[site] © [year]. Todos los derechos reservados.';
$string['footercopyrightsdesc'] = 'Agrega contenido de derechos de autor en la parte inferior de la página.';
$string['footercopyrightstags'] = 'Etiquetas:<br>[site]  -  Nombre del sitio<br>[year]  -  Año actual';
$string['footerbottomlink'] = 'Enlace inferior izquierdo del pie de página';
$string['footerbottomlinkdesc'] = 'Ingresa el enlace para la sección inferior izquierda del pie de página. Por ejemplo: http://www.tuempresa.com';
$string['footerbottomtext'] = 'Texto inferior izquierdo del pie de página';
$string['footerbottomlink'] = 'Enlace inferior izquierdo del pie de página';
$string['copyrighttextarea'] = 'Contenido de derechos de autor';
$string['footercolumnsize'] = 'Número de widgets';
$string['one'] = 'Uno';
$string['two'] = 'Dos';
$string['three'] = 'Tres';
$string['four'] = 'Cuatro';
$string['showsocialmediaicon'] = "Mostrar iconos de redes sociales";
$string['footercolumntype'] = 'Tipo';
$string['footercolumncustommenudesc'] = 'Agrega tus elementos de menú en este formato, por ejemplo:<br><pre>[
    {
        "text": "Agrega tu texto aquí",
        "address": "http://XYZ.abc"
    },
    {
        "text": "Agrega tu texto aquí",
        "address": "http://XYZ.abc"
    }, ...
]</pre>
<b style="color:red;">Nota:</b> Para agregar fácilmente contenido al pie de página, personaliza el área del pie de página con nuestro <a href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer" onclick= location.href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer";location.reload();>Personalizador Visual</a>';
$string['gotop'] = 'Ir al inicio';

$string['menu'] = 'Menú';
$string['content'] = 'Contenido';
$string['footercolumntypedesc'] = 'Puedes elegir el tipo de widget del pie de página';
$string['socialmediaicondesc'] = 'Mostrará los iconos de redes sociales en esta sección';
$string['footercolumncustommmenu'] = 'Agregar elementos de menú';
$string['follometext'] = 'Sígueme en {$a}';
$string['footercolumndesc'] = 'Selecciona el número de widgets en el pie de página';
$string['footershowlogo'] = 'Mostrar logotipo en el pie de página';
$string['footershowlogodesc'] = 'Mostrar el logotipo en el pie de página secundario.';

$string['footertermsandconditionsshow'] = 'Mostrar Términos y Condiciones';
$string['footertermsandconditions'] = 'Enlace de Términos y Condiciones';
$string['footertermsandconditionsdesc'] = 'Puedes agregar un enlace para la página de Términos y Condiciones.';
$string['footertermsandconditionsshowdesc'] = 'Términos y Condiciones del pie de página';
$string['footerprivacypolicyshowdesc'] = 'Enlace de Política de Privacidad';

$string['footerprivacypolicyshow'] = 'Mostrar Política de Privacidad';
$string['footerprivacypolicy'] = 'Enlace de Política de Privacidad';
$string['footerprivacypolicydesc'] = 'Puedes agregar un enlace para la página de Política de Privacidad.';
$string['termsandconditions'] = 'Términos y Condiciones';
$string['privacypolicy'] = 'Política de Privacidad';
$string['typeamessage'] = "Escribe tu mensaje aquí";
$string['allcontacts'] = "Todos los contactos";

// Profile Page.
$string['administrator'] = 'Administrador';
$string['contacts'] = 'Contactos';
$string['blogentries'] = 'Entradas de blog';
$string['discussions'] = 'Discusiones';
$string['aboutme'] = 'Sobre mí';
$string['courses'] = 'Cursos';
$string['interests'] = 'Intereses';
$string['institution'] = 'Departamento e Institución';
$string['location'] = 'Ubicación';
$string['description'] = 'Descripción';
$string['editprofile'] = 'Editar perfil';
$string['start_date'] = 'Fecha de inicio';
$string['complete'] = 'Completar';
$string['surname'] = 'Apellido';
$string['actioncouldnotbeperformed'] = '¡No se pudo realizar la acción!';
$string['enterfirstname'] = 'Por favor, ingresa tu nombre.';
$string['enterlastname'] = 'Por favor, ingresa tu apellido.';
$string['entervalidphoneno'] = 'Ingresa un número de teléfono válido';
$string['enteremailid'] = 'Por favor, ingresa tu ID de correo electrónico.';
$string['enterproperemailid'] = 'Por favor, ingresa un ID de correo electrónico válido.';
$string['detailssavedsuccessfully'] = '¡Detalles guardados con éxito!';
$string['fullname']  = 'Nombre completo';
$string['viewcourselow'] = "ver curso";

$string['focusmodesettings'] = 'Configuración del modo de enfoque';
$string['focusmode'] = 'Modo de enfoque';
$string['enablefocusmode'] = 'Habilitar modo de enfoque';
$string['togglefocusmode'] = "Alternar modo de enfoque";
$string['enablefocusmodedesc'] = 'Si se habilita, aparecerá un botón para cambiar al modo de aprendizaje sin distracciones en la página del curso.';
$string['focusmodeenabled'] = 'Modo de enfoque habilitado';
$string['focusmodedisabled'] = 'Modo de enfoque deshabilitado';
$string['coursedata'] = 'Datos del curso';
$string['prev'] = 'Anterior';
$string['next'] = 'Siguiente';
$string['enablecoursestats'] = 'Habilitar estadísticas del curso';
$string['enablecoursestatsdesc'] = 'Si se habilita, el administrador, los gestores y el profesor verán las estadísticas de los usuarios relacionadas con el curso inscrito en la página del curso individual.';

// Course Stats.
$string['notenrolledanycourse'] = 'No inscrito en ningún curso.';
$string['enrolledusers'] = 'Estudiantes inscritos';
$string['studentcompleted'] = 'Estudiantes que completaron';
$string['inprogress'] = 'En progreso';
$string['yettostart'] = 'Por comenzar';
$string['completepercent'] = '{$a}% del curso completado';
$string['seeallmycourses'] = "<span class='d-none d-lg-block'>Ver todos mis </span>&nbsp;<span>cursos en progreso</span>";
$string['noactivity'] = 'No hay actividades en el curso';
$string['activitydata'] = '{$a->complete} de {$a->total} actividades completadas';

// Login Page Strings.
$string['loginsettingpic'] = 'Cargar imagen de fondo';
$string['loginsettingpicdesc'] = 'Carga una imagen como fondo para el formulario de inicio de sesión.';
$string['loginpagelayout'] = 'Posición del formulario de inicio de sesión';
$string['loginpagelayoutdesc'] = 'Elija el diseño de la página de inicio de sesión.';
$string['logincenter'] = 'Centro';
$string['loginleft'] = 'Lado izquierdo';
$string['loginright'] = 'Lado derecho';
$string['brandlogopos'] = "Mostrar logotipo en la página de inicio de sesión";
$string['brandlogoposdesc'] = "Si está habilitado, el logotipo de la marca se mostrará en la página de inicio de sesión.";
$string['hiddenlogo'] = "Deshabilitar";
$string['sidebarregionlogo'] = 'En la tarjeta de inicio de sesión';
$string['maincontentregionlogo'] = 'En la región central';
$string['loginpanellogo'] = 'Logotipo de encabezado (Página de inicio de sesión)';
$string['loginpanellogodesc'] = 'Depende de la configuración de <strong>Elegir formato del logotipo del sitio</strong>';
$string['signuptextcolor'] = 'Color de la descripción del sitio';
$string['signuptextcolordesc'] = 'Seleccione el color del texto para la descripción del sitio.';
$string['brandlogotext'] = "Descripción del sitio";
$string['loginpagesitedescription'] = 'Descripción del sitio en la página de inicio de sesión';
$string['brandlogotextdesc'] = "Agregue texto para la descripción del sitio que se mostrará en la página de inicio de sesión y registro. Déjelo en blanco si no desea agregar ninguna descripción.";
$string['createnewaccount'] = 'Crear una nueva cuenta';
$string['welcometobrand'] = 'Hola, bienvenido a {$a}';
$string['entertologin'] = "Ingrese sus detalles para iniciar sesión en su cuenta";
$string['forgotaccount'] = '¿Olvidó su contraseña?';
$string['potentialidps'] = 'O inicie sesión con su cuenta';
$string['firsttime'] = '¿Primera vez usando este sitio?';
// Página de registro.
$string['createnewaccount'] = 'Crear una nueva cuenta';
// Configuración de la página del curso.
$string['coursesettings'] = "Página del curso";
$string['enrolpagesettings'] = "Configuración de la página de inscripción";
$string['enrolpagesettingsdesc'] = "Administre el contenido de la página de inscripción aquí.";
$string['coursearchivepagesettings'] = 'Configuración de la página de archivo de cursos';
$string['coursearchivepagesettingsdesc'] = 'Administre el diseño y contenido de la página de archivo de cursos.';
$string['courseperpage'] = 'Cursos por página';
$string['courseperpagedesc'] = "<strong>Vista 'Cuadrícula' de cursos:</strong> Al seleccionar el número de tarjetas de curso en la configuración anterior, la página de archivo del curso se ajustará automáticamente, organizando las tarjetas en filas generadas dinámicamente.<br>
<strong style='display: inline-block;margin-top: 8px;'>Vista 'Lista y Resumen' de cursos:</strong> Los cursos se mostrarán según la selección realizada en la configuración anterior.";
$string['none'] = 'Ninguno';
$string['fade'] = 'Desvanecer';
$string['slide-top'] = 'Deslizar desde arriba';
$string['slide-bottom'] = 'Deslizar desde abajo';
$string['slide-right'] = 'Deslizar desde la derecha';
$string['scale-up'] = 'Aumentar escala';
$string['scale-down'] = 'Disminuir escala';
$string['courseanimation'] = 'Animación de la tarjeta del curso';
$string['courseanimationdesc'] = 'Seleccione la animación de la tarjeta del curso que aparecerá en la página de archivo de cursos';

$string['currency'] = 'USD';
$string['currency_symbol'] = '$';
$string['enrolment_payment'] = 'Mostrar etiqueta "GRATIS" en curso con costo de inscripción "0"';
$string['enrolment_payment_desc'] = 'Esta configuración decide si aparece una etiqueta "GRATIS" para los cursos sin tarifas de inscripción. Si se establece en "No", la etiqueta no aparecerá en la página de inscripción.';
$string['allrequirepayment'] = 'No';
$string['somearefree'] = 'Sí';
$string['allarefree'] = 'Todos los cursos son gratuitos';

$string['showcoursepricing'] = 'Mostrar precios de los cursos';
$string['showcoursepricingdesc'] = 'Habilite esta configuración para mostrar la sección de precios en la página de inscripción.';
$string['fullwidthcourseheader'] = 'Encabezado de curso de ancho completo';
$string['fullwidthcourseheaderdesc'] = 'Habilite esta configuración para que el encabezado del curso tenga ancho completo.';

$string['price'] = 'Precio';
$string['course_free'] = 'GRATIS';
$string['enrolnow'] = '{$a} ahora';
$string['buyand'] = 'Comprar & ';
$string['notags'] = 'Sin etiquetas.';
$string['tags'] = 'Etiquetas';

$string['enrolment_layout'] = 'Diseño de la página de inscripción';
$string['enrolment_layout_desc'] = 'Habilitar diseño Edwiser para un nuevo y mejorado diseño de página de inscripción.';
$string['disable'] = 'Deshabilitar';
$string['defaultlayout'] = 'Diseño predeterminado de Moodle';
$string['enable_layout1'] = 'Diseño Edwiser';

$string['webpage'] = "Página web";
$string['categorypagelayout'] = 'Diseño de la página de archivo de cursos';
$string['categorypagelayoutdesc'] = 'Seleccione entre los diseños de la página de archivo de cursos.';
$string['edwiserlayout'] = 'Diseño Edwiser';
$string['categoryfilter'] = 'Filtro de categorías';

$string['skill0'] = 'Sin etiqueta';
$string['skill1'] = 'Principiante';
$string['skill2'] = 'Intermedio';
$string['skill3'] = 'Avanzado';

$string['lastupdatedon'] = 'Última actualización el ';

$string['courseoverview'] = "Resumen del curso";
$string['coursecontent'] = "Contenido del curso";
$string['instructors'] = "Instructores";
$string['reviews'] = "Reseñas";
$string['curatedby'] = 'Instructores';
$string["studentsenrolled"] = 'Estudiantes inscritos';
$string['lesson'] = 'Lección';
$string['category'] = 'Categoría';
$string['review'] = 'Reseña';
$string['length'] = 'Duración';
$string['lecture'] = 'Conferencia';
$string['startdate'] = 'Fecha de inicio';
$string['skilllevel'] = 'Nivel de habilidad';
$string['language'] = 'Idioma';
$string['certificate'] = 'Certificado';
$string['students'] = 'Estudiantes';
$string['courses'] = 'Cursos';

// Archivo de cursos.
$string['cachedef_courses'] = 'Caché para cursos';
$string['cachedef_guestcourses'] = 'Caché para cursos de invitados';
$string['cachedef_updates'] = 'Caché para actualizaciones';
$string['mycourses'] = "Mis cursos";
$string['allcategories'] = 'Todas las categorías';
$string['categorysort'] = 'Ordenar categorías';
$string['sortdefault'] = 'Ordenar (ninguno)';
$string['sortascending'] = 'A a Z';
$string['sortdescending'] = 'Z a A';

// Cadenas antiguas de la página principal.
// Configuración de la página de inicio.
$string['homepagesettings'] = 'Página de inicio';
$string['frontpagedesign'] = 'Diseño de la página principal';
$string['frontpagedesigndesc'] = 'Habilitar constructor de página principal Legacy o Edwiser RemUI';
$string['frontpagechooser'] = 'Elegir diseño de la página principal';
$string['frontpagechooserdesc'] = 'Elija el diseño de su página principal.';
$string['frontpagedesignold'] = 'Constructor de página principal Legacy';
$string['frontpagedesignolddesc'] = 'Panel predeterminado como el anterior.';
$string['frontpagedesignnew'] = 'Nuevo diseño';
$string['frontpagedesignnewdesc'] = 'Nuevo diseño fresco con múltiples secciones. Puede configurar secciones individualmente en la página principal.';
$string['newhomepagedescription'] = 'Haga clic en "Inicio del sitio" en la barra de navegación para ir al "Constructor de página principal" y crear su propia página principal
<br><div><b style="color:red;">Nota:</b> El Constructor de página principal se deprecará pronto</div>
<br><div><a id="homepage-edwpagebuilder-migratorbtn" href="#" class="btn btn-primary ">migrar página principal a pagebuilder</a></div>migre su página principal a pagebuilder';
$string['frontpageloader'] = 'Cargar imagen de cargador para la página principal';
$string['frontpageloaderdesc'] = 'Esto reemplaza el cargador predeterminado con su imagen';
$string['frontpageimagecontent'] = 'Contenido del encabezado';
$string['frontpageimagecontentdesc'] = 'Esta sección se relaciona con la parte superior de su página principal.';
$string['frontpageimagecontentstyle'] = 'Estilo';
$string['frontpageimagecontentstyledesc'] = 'Puede elegir entre Estático y Deslizador.';
$string['staticcontent'] = 'Estático';
$string['slidercontent'] = 'Deslizador';
$string['addtext'] = 'Agregar texto';
$string['defaultaddtext'] = 'La educación es un camino comprobado hacia el progreso.';
$string['addtextdesc'] = 'Aquí puede agregar el texto que se mostrará en la página principal, preferiblemente en HTML.';
$string['uploadimage'] = 'Cargar imagen';
$string['uploadimagedesc'] = 'Puede cargar una imagen como contenido para el deslizante';
$string['video'] = 'Código incrustado iframe';
$string['videodesc'] = 'Aquí puede insertar el código incrustado iframe del video que se va a incrustar.';
$string['contenttype'] = 'Seleccione el tipo de contenido';
$string['contentdesc'] = 'Puedes elegir entre imagen o proporcionar URL de video.';
$string['imageorvideo'] = 'Imagen/ Video';
$string['image'] = 'Imagen';
$string['videourl'] = 'URL de Video';
$string['slideinterval'] = 'Intervalo de diapositivas';
$string['slideintervalplaceholder'] = 'Número entero positivo en milisegundos.';
$string['slideintervaldesc'] = 'Puedes establecer el tiempo de transición entre las diapositivas. En caso de que haya una sola diapositiva, esta opción no tendrá efecto. Si el intervalo es inválido (vacío|0|menor que 0), el intervalo predeterminado es de 5000 milisegundos.';
$string['slidercount'] = 'Número de diapositivas';
$string['slidercountdesc'] = '';
$string['one'] = '1';
$string['two'] = '2';
$string['three'] = '3';
$string['four'] = '4';
$string['five'] = '5';
$string['six'] = '6';
$string['eight'] = '8';
$string['nine'] = '9';
$string['twelve'] = '12';
$string['slideimage'] = 'Subir imágenes para el Slider';
$string['slideimagedesc'] = 'Puedes subir una imagen como contenido para esta diapositiva.';
$string['sliderurl'] = 'Agregar enlace al botón del Slider';
$string['slidertext'] = 'Agregar texto al Slider';
$string['defaultslidertext'] = '';
$string['slidertextdesc'] = 'Puedes insertar el contenido de texto para esta diapositiva. Preferiblemente en HTML.';
$string['sliderbuttontext'] = 'Agregar texto al botón en la diapositiva';
$string['sliderbuttontextdesc'] = 'Puedes agregar texto al botón en esta diapositiva.';
$string['sliderurldesc'] = 'Puedes insertar el enlace de la página a la que el usuario será redirigido una vez que haga clic en el botón.';
$string['sliderautoplay'] = 'Configurar reproducción automática del Slider';
$string['sliderautoplaydesc'] = 'Selecciona "sí" si deseas una transición automática en tu presentación de diapositivas.';
$string['true'] = 'Sí';
$string['false'] = 'No';
$string['frontpageblocks'] = 'Contenido Principal';
$string['frontpageblocksdesc'] = 'Puedes insertar un encabezado para el cuerpo de tu sitio';
$string['frontpageblockdisplay'] = 'Sección Sobre Nosotros';
$string['frontpageblockdisplaydesc'] = 'Puedes mostrar u ocultar la sección "Sobre Nosotros", también puedes mostrar la sección "Sobre Nosotros" en formato de cuadrícula';
$string['donotshowaboutus'] = 'No Mostrar';
$string['showaboutusinrow'] = 'Mostrar Sección en una Fila';
$string['showaboutusingridblock'] = 'Mostrar Sección en Bloque de Cuadrícula';

// About Us.
$string['frontpageaboutus'] = 'Portada Sobre Nosotros';
$string['frontpageaboutusdesc'] = 'Esta sección es para la portada Sobre Nosotros';
$string['frontpageaboutustitledesc'] = 'Agregar título a la Sección Sobre Nosotros';
$string['frontpageaboutusbody'] = 'Descripción del Cuerpo para la Sección Sobre Nosotros';
$string['frontpageaboutusbodydesc'] = 'Una breve descripción sobre esta Sección';
$string['enablesectionbutton'] = 'Habilitar botones en Secciones';
$string['enablesectionbuttondesc'] = 'Habilitar los botones en las secciones del cuerpo.';
$string['sectionbuttontextdesc'] = 'Ingresa el texto para el botón en esta Sección.';
$string['sectionbuttonlinkdesc'] = 'Ingresa el enlace URL para esta Sección.';
$string['frontpageblocksectiondesc'] = 'Agregar título a esta Sección.';

// Block section 1.
$string['frontpageblocksection1'] = 'Título del cuerpo para la 1ª Sección';
$string['frontpageblockdescriptionsection1'] = 'Descripción del cuerpo para la 1ª Sección';
$string['frontpageblockiconsection1'] = 'Ícono de Font-Awesome para la 1ª Sección';
$string['sectionbuttontext1'] = 'Texto del botón para la 1ª Sección';
$string['sectionbuttonlink1'] = 'Enlace URL para la 1ª Sección';

// Block section 2.
$string['frontpageblocksection2'] = 'Título del cuerpo para la 2ª Sección';
$string['frontpageblockdescriptionsection2'] = 'Descripción del cuerpo para la 2ª Sección';
$string['frontpageblockiconsection2'] = 'Ícono de Font-Awesome para la 2ª Sección';
$string['sectionbuttontext2'] = 'Texto del botón para la 2ª Sección';
$string['sectionbuttonlink2'] = 'Enlace URL para la 2ª Sección';

// Block section 3.
$string['frontpageblocksection3'] = 'Título del cuerpo para la 3ª Sección';
$string['frontpageblockdescriptionsection3'] = 'Descripción del cuerpo para la 3ª Sección';
$string['frontpageblockiconsection3'] = 'Ícono de Font-Awesome para la 3ª Sección';
$string['sectionbuttontext3'] = 'Texto del botón para la 3ª Sección';
$string['sectionbuttonlink3'] = 'Enlace URL para la 3ª Sección';

// Block section 4.
$string['frontpageblocksection4'] = 'Título del cuerpo para la 4ª Sección';
$string['frontpageblockdescriptionsection4'] = 'Descripción del cuerpo para la 4ª Sección';
$string['frontpageblockiconsection4'] = 'Ícono de Font-Awesome para la 4ª Sección';
$string['sectionbuttontext4'] = 'Texto del botón para la 4ª Sección';
$string['sectionbuttonlink4'] = 'Enlace URL para la 4ª Sección';
$string['defaultdescriptionsection'] = 'Aprovecha holísticamente tecnologías just in time a través de escenarios corporativos.';
$string['frontpagetestimonial'] = 'Testimonio de la Portada';
$string['frontpagetestimonialdesc'] = 'Sección de Testimonios de la Portada';
$string['enablefrontpageaboutus'] = 'Habilitar sección de Testimonios';
$string['enablefrontpageaboutusdesc'] = 'Habilitar la sección de Testimonios en la portada.';
$string['frontpageaboutusheading'] = 'Encabezado del Testimonio';
$string['frontpageaboutusheadingdesc'] = 'Encabezado para el texto predeterminado de la sección';
$string['frontpageaboutustext'] = 'Texto del Testimonio';
$string['frontpageaboutustextdesc'] = 'Ingresa el texto del testimonio para la portada.';
$string['frontpageaboutusdefault'] = '<p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
              Ut enim ad minim veniam.</p>';
$string['testimonialcount'] = 'Cantidad de Testimonios';
$string['testimonialcountdesc'] = 'Número de testimonios a mostrar.';
$string['testimonialimage'] = 'Imagen del Testimonio';
$string['testimonialimagedesc'] = 'Imagen de la persona a mostrar con el testimonio';
$string['testimonialname'] = 'Nombre de la Persona';
$string['testimonialnamedesc'] = 'Nombre de la persona';
$string['testimonialdesignation'] = 'Designación de la Persona';
$string['testimonialdesignationdesc'] = 'Designación de la persona.';
$string['testimonialtext'] = 'Testimonio de la Persona';
$string['testimonialtextdesc'] = 'Lo que dice la persona';
$string['frontpageblockimage'] = 'Subir imagen';
$string['frontpageblockimagedesc'] = 'Puedes subir una imagen como contenido para esto.';
$string['frontpageblockiconsectiondesc'] = 'Puedes elegir cualquier ícono de esta <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new">lista</a>. Solo ingresa el texto después de "fa-". ';
$string['frontpageblockdescriptionsectiondesc'] = 'Una breve descripción sobre el título.';

// Course.
$string['graderreport'] = 'Informe del Calificador';
$string['enroluser'] = 'Inscribir Usuarios';
$string['activityeport'] = 'Informe de Actividad';
$string['editcourse'] = 'Editar Curso';
$string['imageforcourse'] = 'Imagen para el Curso';
// Next Previous Activity.
$string['activityprev'] = 'Actividad Anterior';
$string['activitynext'] = 'Siguiente Actividad';
$string['activitynextpreviousbutton'] = 'Habilitar botón de Actividad Siguiente y Anterior';
$string['activitynextpreviousbuttondesc'] = 'Cuando está habilitado, el botón de Actividad Siguiente y Anterior aparecerá en la página de Actividad Única para cambiar entre actividades';
$string['disablenextprevious'] = 'Deshabilitar';
$string['enablenextprevious'] = 'Habilitar';
$string['enablenextpreviouswithname'] = 'Habilitar con el nombre de la Actividad';

// Importer.
$string['importer'] = 'Importador';
$string['importer-missing'] = 'El plugin Edwiser Site Importer falta. Por favor visita el sitio de <a href="https://edwiser.org">Edwiser</a> para descargar este plugin.';

// Information center.
$string['informationcenter'] = 'Centro de Información';
$string['licensenotactive'] = '<strong>¡Alerta!</strong> La licencia no está activada, por favor <strong>activa</strong> la licencia en la configuración de RemUI.';
$string['licensenotactiveadmin'] = '<strong>¡Alerta!</strong> La licencia no está activada, por favor <strong>activa</strong> la licencia <a class="text-primary" href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#informationcenter" >aquí</a>.';
$string['activatelicense'] = 'Activar Licencia';
$string['deactivatelicense'] = 'Desactivar Licencia';
$string['renewlicense'] = 'Renovar Licencia';
$string['deactivated'] = 'Desactivado';
$string['active'] = 'Activo';
$string['notactive'] = 'No Activo';
$string['expired'] = 'Expirado';
$string['licensekey'] = 'Clave de Licencia';
$string['licensestatus'] = 'Estado de la Licencia';
$string['no_activations_left'] = 'Límite excedido';
$string['activationfailed'] = 'Falló la activación de la clave de licencia. Por favor, intenta de nuevo más tarde.';
$string['noresponsereceived'] = 'No se recibió respuesta del servidor. Por favor, intenta de nuevo más tarde.';
$string['licensekeydeactivated'] = 'La clave de licencia está desactivada.';
$string['siteinactive'] = 'Sitio inactivo (Presiona Activar licencia para activar el plugin).';
$string['entervalidlicensekey'] = 'Por favor ingresa una clave de licencia válida.';
$string['nolicenselimitleft'] = 'Límite máximo de activaciones alcanzado, no hay activaciones disponibles.';
$string['licensekeyisdisabled'] = 'Tu clave de licencia está desactivada.';
$string['licensekeyhasexpired'] = "Tu clave de licencia ha expirado. Por favor, renuévala.";
$string['licensekeyactivated'] = "Tu clave de licencia está activada.";
$string['entervalidlicensekey'] = "Por favor ingresa la clave de licencia correcta.";
$string['edwiserremuilicenseactivation'] = 'Activación de Licencia de Edwiser RemUI';
$string['enterlicensekey'] = "Ingresa la clave de licencia...";
$string['invalid'] = "Inválido";

$string['courseheaderdesign'] = 'Diseño del encabezado de la página del curso';
$string['courseheaderdesigndesc'] = 'Elige el diseño del encabezado de la página del curso';
$string['default'] = 'Predeterminado';
$string['headerdesign'] = 'Diseño del encabezado {$a}';
$string['sidebarcoursemenuheading'] = "Menú del Curso";

// Notification.
$string['inproductnotification'] = "Actualizar preferencias de usuario (Notificación en el producto) - RemUI";

$string["noti_enrolandcompletion"] = 'Los modernos y profesionales diseños de Edwiser RemUI han ayudado enormemente a aumentar tu participación total de estudiantes con <b>{$a->enrolment} nuevas inscripciones en cursos y {$a->completion} finalizaciones de cursos</b> este mes';

$string["noti_completion"] = 'Edwiser RemUI ha mejorado tus niveles de participación de estudiantes: Tienes un total de <b>{$a->completion} finalizaciones de cursos</b> este mes';

$string["noti_enrol"] = 'Tu diseño LMS se ve genial con Edwiser RemUI: Tienes <b>{$a->enrolment} nuevas inscripciones en cursos</b> en tu portal este mes';

$string["coolthankx"] = "Genial, ¡Gracias!";

$string['gridview'] = 'Vista en Cuadrícula';
$string['listview'] = 'Vista en Lista';
$string['summaryview'] = 'Vista Resumen';

$string['side-top'] = "Contenido de la Caja Superior";
$string['content'] = "Predeterminado de Moodle";
$string['side-bottom'] = "Contenido de la Caja Inferior";
$string['side-pre'] = "Barra Lateral Derecha";

$string['sitenamecolor'] = "Color del nombre o icono del sitio.";
$string['sitenamecolordesc'] = "Color para el nombre del sitio y el texto del icono del sitio, que también se aplicará en la página de inicio de sesión.";

$string['coursesenrolled'] = "Cursos Inscritos";
$string['coursescompleted'] = "Cursos Completados";
$string['activitiescompleted'] = "Actividades Completadas";
$string['activitiesdue'] = "Actividades Pendientes";

// Customizer Strings
$string['customizer-migrate-notice'] = 'La configuración de colores se ha migrado al personalizador visual. Por favor, haz clic en el botón de abajo para abrir el personalizador visual.';
$string['customizer-close-heading'] = 'Cerrar personalizador visual';
$string['customizer-close-description'] = 'Los cambios no guardados se descartarán. ¿Te gustaría continuar?';
$string['reset'] = 'Restablecer';
$string['resetall'] = 'Restablecer Todo';
$string['reset-settings'] = 'Restablecer todas las configuraciones del personalizador visual';
$string['reset-settings-description'] = '
<div>Las configuraciones del personalizador visual se restaurarán a predeterminadas. ¿Deseas continuar?</div>
<div class="mt-3"><strong>Restablecer Todo:</strong> Restablecer todas las configuraciones.</div>
<div class="mt-3"><strong>Restablecer:</strong> Las configuraciones excepto las siguientes se restablecerán a predeterminadas.</div>
';
$string['link'] = 'Enlace';
$string['customizer'] = 'Personalizador visual';
$string['error'] = 'Error';
$string['resetdesc'] = 'Restablecer configuración a la última guardada o predeterminada cuando no haya nada guardado';
$string['noaccessright'] = '¡Lo siento! No tienes derechos para usar esta página';

$string['font-family'] = 'Familia de fuentes';
$string['font-family_help'] = 'Establecer la familia de fuentes de {$a}';

$string['button-font-family'] = 'Familia de fuentes';
$string['button-font-family_help'] = 'Establecer la familia de fuentes del texto del botón';

$string['font-size'] = 'Tamaño de fuente';
$string['font-size_help'] = 'Establecer el tamaño de fuente de {$a}';
$string['font-weight'] = 'Peso de la fuente';
$string['font-weight_help'] = 'Establecer un peso de fuente de {$a}. La propiedad font-weight establece qué tan gruesos o delgados deben mostrarse los caracteres en el texto.';
$string['line-height'] = 'Altura de línea';
$string['line-height_help'] = 'Establecer la altura de línea de {$a}';
$string['global'] = 'Global';
$string['global_help'] = 'Puedes gestionar configuraciones globales como color, fuente, encabezados, botones, etc.';
$string['site'] = 'Sitio';
$string['text-color'] = 'Color de texto';
$string['welcome-text-color'] = 'Color del texto de bienvenida';
$string['text-hover-color'] = 'Color de texto al pasar el ratón';
$string['text-color_help'] = 'Establecer el color de texto de {$a}';
$string['content-color'] = 'Color del contenido';
$string['icon-color'] = 'Color del icono';
$string['icon-hover-color'] = 'Color del icono al pasar el ratón';
$string['icon-color_help'] = 'Establecer el color del icono de {$a}';
$string['link-color'] = 'Color del enlace';
$string['link-color_help'] = 'Establecer el color del enlace de {$a}';
$string['link-hover-color'] = 'Color del enlace al pasar el ratón';
$string['link-hover-color_help'] = 'Establecer el color del enlace al pasar el ratón de {$a}';
$string['typography'] = 'Tipografía';
$string['inherit'] = 'Heredar';
$string["weight-100"] = '100';
$string["weight-200"] = '200';
$string["weight-300"] = '300';
$string["weight-400"] = '400';
$string["weight-500"] = '500';
$string["weight-600"] = '600';
$string["weight-700"] = '700';
$string["weight-800"] = '800';
$string["weight-900"] = '900';
$string['text-transform'] = 'Transformación de texto';
$string['text-transform_help'] = 'La propiedad text-transform controla la capitalización del texto. Establecer la transformación de texto de {$a}.';

$string['button-text-transform'] = 'Transformación de texto';
$string['button-text-transform_help'] = 'La propiedad text-transform controla la capitalización del texto. Establecer la transformación de texto para el texto del botón';

$string["default"] = 'Predeterminado';
$string["none"] = 'Ninguno';
$string["capitalize"] = 'Capitalizar';
$string["uppercase"] = 'Mayúsculas';
$string["lowercase"] = 'Minúsculas';
$string['background-color'] = 'Color de fondo';
$string['background-hover-color'] = 'Color de fondo al pasar el ratón';
$string['background-color_help'] = 'Establecer el color de fondo de {$a}';
$string['background-hover-color'] = 'Color de fondo al pasar el ratón';
$string['background-hover-color_help'] = 'Establecer el color de fondo al pasar el ratón de {$a}';
$string['color'] = 'Color';
$string['customizing'] = 'Personalizando';
$string['savesuccess'] = 'Guardado exitosamente.';
$string['mobile'] = 'Móvil';
$string['tablet'] = 'Tableta';
$string['hide-customizer'] = 'Ocultar personalizador visual';
$string['customcss_help'] = 'Puede agregar CSS personalizado. Esto se aplicará en todas las páginas de su sitio.';

// Customizer Global body.
$string['body'] = 'Cuerpo';
$string['body-font-family_desc'] = 'Establecer la familia de fuentes para todo el sitio. Nota: si se establece en Estándar, se aplicará la fuente de la configuración de RemUI.';
$string['body-font-size_desc'] = 'Establecer el tamaño base de la fuente para todo el sitio.';
$string['body-fontweight_desc'] = 'Establecer el peso de la fuente para todo el sitio.';
$string['body-text-transform_desc'] = 'Establecer la transformación de texto para todo el sitio.';
$string['body-lineheight_desc'] = 'Establecer la altura de línea para todo el sitio.';
$string['faviconurl_help'] = 'URL del favicon';

// Customizer Global heading.
$string['heading'] = 'Encabezado';
$string['use-custom-color'] = 'Usar color personalizado';
$string['use-custom-color_help'] = 'Usar color personalizado para {$a}';
$string['typography-heading-all-heading'] = 'Encabezados (H1 - H6)';
$string['typography-heading-h1-heading'] = 'Encabezado 1';
$string['typography-heading-h2-heading'] = 'Encabezado 2';
$string['typography-heading-h3-heading'] = 'Encabezado 3';
$string['typography-heading-h4-heading'] = 'Encabezado 4';
$string['typography-heading-h5-heading'] = 'Encabezado 5';
$string['typography-heading-h6-heading'] = 'Encabezado 6';

// Customizer Colors.
$string['primary-color'] = 'Color primario';
$string['primary-color_help'] = 'Aplicar el color primario de la marca a todo el sitio. Este color se aplicará a los botones, enlaces de texto, al pasar el cursor y a los elementos del menú de encabezado activos, al pasar el cursor y a los íconos activos
    <br><b>Nota:</b> Cambiar el color primario no cambiará los colores de los botones si ha cambiado los colores de los botones a través de sus configuraciones individuales (<b>Global > Botones> Configuración de color de botones</b>). Restablezca los colores de los botones desde sus configuraciones individuales para cambiar el color del botón cambiando globalmente el color primario desde aquí ';

$string['secondary-color'] = 'Color de acento';
$string['secondary-color_help'] = 'Aplicar color de acento a todo el sitio. Este color se aplicará a los íconos en el bloque de estadísticas en la página del tablero, etiquetas en las tarjetas de curso, pancartas de encabezado de curso';

$string['page-background'] = 'Fondo de la página';
$string['page-background_help'] = 'Establecer un fondo personalizado para el área de contenido de la página. Puede elegir color, degradado o imagen. El ángulo del color degradado es 100 grados.';

$string['page-background-color'] = 'Color de fondo de la página';
$string['page-background-color_help'] = 'Establecer color de fondo para el área de contenido de la página.';

$string['page-background-image'] = 'Imagen de fondo de la página';
$string['page-background-image_help'] = 'Establecer una imagen como fondo para el área de contenido de la página.';

$string['gradient'] = 'Degradado';
$string['gradient-color1'] = 'Color de degradado 1';
$string['gradient-color1_help'] = 'Establecer el primer color del degradado';
$string['gradient-color2'] = 'Color de degradado 2';
$string['gradient-color2_help'] = 'Establecer el segundo color del degradado';
$string['gradient-color-angle'] = 'Ángulo del degradado';
$string['gradient-color-angle_help'] = 'Establecer el ángulo para los colores del degradado';

$string['page-background-imageattachment'] = 'Adjunto de imagen de fondo';
$string['page-background-imageattachment_help'] = 'La propiedad background-attachment establece si una imagen de fondo se desplaza con el resto de la página o está fija.';

$string['image'] = 'Imagen';
$string['additional-css'] = 'CSS adicional';
$string['left-sidebar'] = 'Barra lateral izquierda';
$string['main-sidebar'] = 'Barra lateral principal';
$string['sidebar-links'] = 'Enlaces de la barra lateral';
$string['secondary-sidebar'] = 'Barra lateral secundaria';
$string['header'] = 'Encabezado';
$string['headertypography'] = 'Tipografía del encabezado';
$string['headercolors'] = 'Colores del encabezado';
$string['menu'] = 'Menú';
$string['site-identity'] = 'Identidad del sitio';
$string['primary-header'] = 'Encabezado primario';
$string['color'] = 'Color';

// Customizer Buttons.
$string['buttons'] = 'Botones';
$string['border'] = 'Borde';
$string['border-width'] = 'Ancho del borde';
$string['border-width_help'] = 'Establecer el ancho del borde de {$a}';
$string['border-color'] = 'Color del borde';
$string['border-color_help'] = 'Establecer el color del borde de {$a}';
$string['border-hover-color'] = 'Color del borde al pasar el cursor';
$string['border-hover-color_help'] = 'Establecer el color del borde al pasar el cursor de {$a}';
$string['border-radius'] = 'Radio del borde';
$string['border-radius_help'] = 'Establecer el radio del borde de {$a}';
$string['letter-spacing'] = 'Espaciado de letras';
$string['letter-spacing_help'] = 'Establecer el espaciado de letras de {$a}';
$string['text'] = 'Texto';
$string['padding'] = 'Relleno';
$string['padding-top'] = 'Relleno superior';
$string['padding-top_help'] = 'Establecer el relleno superior de {$a}';
$string['padding-right'] = 'Relleno derecho';
$string['padding-right_help'] = 'Establecer el relleno derecho de {$a}';
$string['padding-bottom'] = 'Relleno inferior';
$string['padding-bottom_help'] = 'Establecer el relleno inferior de {$a}';
$string['padding-left'] = 'Relleno izquierdo';
$string['padding-left_help'] = 'Establecer el relleno izquierdo de {$a}';
$string['secondary'] = 'Secundario';
$string['colors'] = 'Colores';
$string['commonbuttonsettings'] = 'Configuración común';
$string['buttonsizesettings'] = 'Tamaños de botón';
$string['buttonsizesettingshead'] = '{$a}';
$string['commonfontsettings'] = 'Fuente';
$string['buttoncolorsettings'] = 'Configuración de color de botón';
// Customizer Header.
$string['header-background-color_help'] = 'Establecer el color de fondo del encabezado. Esto no se aplicará si está habilitada la opción <strong>Establecer el color de fondo del encabezado igual que el color de fondo del logo</strong>.';
$string['site-logo'] = 'Logo del sitio';
$string['header-menu'] = 'Menú del encabezado';
$string['box-shadow-size'] = 'Tamaño de la sombra de caja';
$string['box-shadow-size_help'] = 'Establecer el tamaño de la sombra de caja para el encabezado del sitio';
$string['box-shadow-blur'] = 'Desenfoque de la sombra de caja';
$string['box-shadow-blur_help'] = 'Establecer el desenfoque de la sombra de caja para el encabezado del sitio';
$string['box-shadow-color'] = 'Color de la sombra de caja';
$string['box-shadow-color_help'] = 'Establecer el color de la sombra de caja para el encabezado del sitio';
$string['layout-desktop'] = 'Diseño de escritorio';
$string['layout-desktop_help'] = 'Establecer el diseño del encabezado para escritorio';
$string['layout-mobile'] = 'Diseño móvil';
$string['layout-mobile_help'] = 'Establecer el diseño del encabezado para móvil';
$string['header-left'] = 'Ícono a la izquierda, menú a la derecha';
$string['header-right'] = 'Ícono a la derecha, menú a la izquierda';
$string['header-top'] = 'Ícono arriba, menú abajo';
$string['hover'] = 'Pasar el cursor';
$string['logo'] = 'Logo';
$string['applynavbarcolor'] = 'Establecer el color de fondo del encabezado igual que el color de fondo del logo';
$string['applynavbarcolor_help'] = 'El color de fondo del logo se aplicará a todo el encabezado. Cambiar el color de fondo del logo cambiará el color de fondo del encabezado. Aún puede aplicar un color de texto y un color al pasar el cursor personalizados a los menús del encabezado.';
$string['header-background-color-warning'] = 'No se usará si está habilitada la opción <strong>Establecer el color del sitio de la barra de navegación</strong>.';
$string['logosize'] = 'La relación de aspecto esperada es 130:33 para la vista izquierda, 140:33 para la vista derecha.';
$string['logominisize'] = 'La relación de aspecto esperada es 40:33.';
$string['sitenamewithlogo'] = 'Nombre del sitio con logo (solo vista superior)';

// Customizador Sidebar.
$string['link-text'] = 'Texto del enlace';
$string['link-text_help'] = 'Establecer color del texto del enlace de {$a}';
$string['link-icon'] = 'Ícono del enlace';
$string['link-icon_help'] = 'Establecer color del ícono del enlace de {$a}';
$string['active-link-color'] = 'Color del enlace activo';
$string['active-link-color_help'] = 'Establecer color personalizado para el enlace activo de {$a}';
$string['active-link-background'] = 'Fondo del enlace activo';
$string['active-link-background_help'] = 'Establecer color personalizado para el fondo del enlace activo de {$a}';
$string['link-hover-background'] = 'Fondo del enlace al pasar el ratón';
$string['link-hover-background_help'] = 'Establecer fondo del enlace al pasar el ratón para {$a}';
$string['link-hover-text'] = 'Texto del enlace al pasar el ratón';
$string['link-hover-text_help'] = 'Establecer color del texto del enlace al pasar el ratón para {$a}';

// Customizador Footer.
$string['footer'] = 'Pie de página';
$string['basic'] = 'Diseño del pie de página';
$string['socialall'] = 'Enlaces de redes sociales';
$string['advance'] = 'Área principal del pie de página';
$string['footercolumn'] = 'Widget';
$string['footercolumnwidgetno'] = 'Seleccionar número de widgets';
$string['footercolumndesc'] = 'Número de widgets para mostrar en el pie de página.';
$string['footercolumntype'] = 'Seleccionar tipo';
$string['footercolumnsettings'] = 'Configuraciones de la columna del pie de página';
$string['footercolumntypedesc'] = 'Puedes elegir el tipo de widget del pie de página';
$string['footercolumnsocial'] = 'Enlaces de redes sociales';
$string['footercolumnsocialdesc'] = 'Selecciona los enlaces para mostrar. Mantén presionada la tecla "ctrl" en el teclado para seleccionar múltiples enlaces';
$string['footercolumntitle'] = 'Agregar título';
$string['footercolumntitledesc'] = 'Agregar título a este widget.';
$string['footercolumncustomhtml'] = 'Contenido';
$string['footercolumncustomhtmldesc'] = 'Puedes personalizar el contenido de este widget usando el editor que se encuentra a continuación.';
$string['both'] = 'Ambos';
$string['footercolumnsize'] = 'Ajustar ancho del widget';
$string['footercolumnsizenote'] = 'Arrastra la línea vertical para ajustar el tamaño del widget.';
$string['footercolumnsizedesc'] = 'Puedes establecer el tamaño individual del widget.';
$string['footercolumnmenu'] = 'Menú';
$string['footercolumnmenureset'] = 'Menús de columnas del pie de página';
$string['footercolumnmenudesc'] = 'Enlace del menú';
$string['footermenu'] = 'Menú';
$string['footermenudesc'] = 'Agregar menú en el widget del pie de página.';
$string['customizermenuadd'] = 'Agregar elemento del menú';
$string['customizermenuedit'] = 'Editar elemento del menú';
$string['customizermenumoveup'] = 'Mover elemento del menú hacia arriba';
$string['customizermenuemovedown'] = 'Mover elemento del menú hacia abajo';
$string['customizermenuedelete'] = 'Eliminar elemento del menú';
$string['menutext'] = 'Texto';
$string['menuaddress'] = 'Dirección';
$string['menuorientation'] = 'Orientación del menú';
$string['menuorientationdesc'] = 'Establecer la orientación del menú. La orientación puede ser vertical u horizontal.';
$string['menuorientationvertical'] = 'Vertical';
$string['menuorientationhorizontal'] = 'Horizontal';
$string['footerfacebook'] = 'Facebook';
$string['footertwitter'] = 'Twitter';
$string['footerlinkedin'] = 'LinkedIn';
$string['footergplus'] = 'Google Plus';
$string['footeryoutube'] = 'YouTube';
$string['footerinstagram'] = 'Instagram';
$string['footerpinterest'] = 'Pinterest';
$string['footerquora'] = 'Quora';
$string['footershowlogo'] = 'Mostrar Logo';
$string['footershowlogodesc'] = 'Mostrar logo en el pie de página secundario.';
$string['footersecondarysocial'] = 'Mostrar enlaces de redes sociales';
$string['footersecondarysocialdesc'] = 'Mostrar enlaces de redes sociales en el pie de página secundario.';
$string['footertermsandconditionsshow'] = 'Mostrar Términos y Condiciones';
$string['footertermsandconditions'] = 'Enlace de Términos y Condiciones';
$string['footertermsandconditionsdesc'] = 'Puedes agregar un enlace para la página de Términos y Condiciones.';
$string['footerprivacypolicyshow'] = 'Mostrar Política de Privacidad';
$string['footerprivacypolicy'] = 'Enlace de Política de Privacidad';
$string['footerprivacypolicydesc'] = 'Puedes agregar un enlace para la página de Política de Privacidad.';
$string['footercopyrightsshow'] = 'Mostrar contenido de derechos de autor';
$string['footercopyrights'] = 'Contenido de derechos de autor';
$string['footercopyrightsdesc'] = 'Agregar contenido de derechos de autor en la parte inferior de la página.';
$string['footercopyrightstags'] = 'Etiquetas:<br>[site] - Nombre del sitio<br>[year] - Año actual';
$string['termsandconditions'] = 'Términos y Condiciones';
$string['privacypolicy'] = 'Política de Privacidad';
$string['footerfont'] = 'Fuente';
$string['footerbasiccolumntitle'] = 'Título de la columna';
$string['divider-color'] = 'Color del divisor';
$string['divider-color_help'] = 'Establecer color del divisor de {$a}';
$string['text-hover-color'] = 'Color del texto al pasar el ratón';
$string['text-hover-color_help'] = 'Establecer color del texto al pasar el ratón de {$a}';
$string['link-color'] = 'Color del enlace';
$string['link-color_help'] = 'Establecer color del enlace de {$a}';
$string['link-hover-color'] = 'Color del enlace al pasar el ratón';
$string['link-hover-color_help'] = 'Establecer color del enlace al pasar el ratón de {$a}';
$string['icon-default-color'] = 'Color del ícono';
$string['icon-default-color_help'] = 'Color del ícono de {$a}';
$string['icon-hover-color'] = 'Color del ícono al pasar el ratón';
$string['icon-hover-color_help'] = 'Color del ícono al pasar el ratón de {$a}';
$string['footerfontsize_help'] = 'Establecer tamaño de la fuente';
$string['footer-color-heading1'] = 'Colores del pie de página';
$string['footer-color-heading2'] = 'Enlaces del pie de página';
$string['footer-color-heading3'] = 'Íconos del pie de página';

$string['footerfontfamily'] = 'Familia de fuentes';
$string['footerfontfamily_help'] = 'Familia de fuentes';
$string['footerfontsize'] = 'Tamaño de fuente';
$string['footerfontsize_help'] = 'Tamaño de la fuente del pie de página';
$string['footerfontweight'] = 'Peso de la fuente';
$string['footerfontweight_help'] = 'Peso de la fuente del pie de página';
$string['footerfonttext-transform'] = 'Mayúsculas y minúsculas';
$string['footerfonttext-transform_help'] = 'Mayúsculas y minúsculas';
$string['footerfontlineheight'] = 'Espaciado entre líneas';
$string['footerfontlineheight_help'] = 'Espaciado entre líneas';
$string['footerfontltrspace'] = 'Espaciado de letras';
$string['footerfontltrspace_help'] = 'Establecer espaciado de letras de {$a}';

$string['footer-columntitle-fontfamily'] = 'Familia de fuentes';
$string['footer-columntitle-fontfamily_help'] = 'Familia de fuentes';
$string['footer-columntitle-fontsize'] = 'Tamaño de fuente';
$string['footer-columntitle-fontsize_help'] = 'Tamaño de la fuente del título de la columna del pie de página';
$string['footer-columntitle-fontweight'] = 'Peso de la fuente';
$string['footer-columntitle-fontweight_help'] = 'Peso de la fuente del título de la columna del pie de página';
$string['footer-columntitle-textransform'] = 'Mayúsculas y minúsculas';
$string['footer-columntitle-textransform_help'] = 'Mayúsculas y minúsculas';
$string['footer-columntitle-lineheight'] = 'Espaciado entre líneas';
$string['footer-columntitle-lineheight_help'] = 'Espaciado entre líneas';
$string['footer-columntitle-ltrspace'] = 'Espaciado de letras';
$string['footer-columntitle-ltrspace_help'] = 'Espaciado de letras';
$string['footer-columntitle-color'] = 'Color';
$string['footer-columntitle-color_help'] = 'Color';

$string['openinnewtab'] = 'Abrir en una nueva pestaña';
$string['useheaderlogo'] = 'Usar el mismo logo del encabezado';
$string['secondaryfooterlogo'] = 'Agregar un nuevo logo';
$string['logosettings'] = 'Configuraciones del logo';
$string['loginformsettings'] = 'Configuraciones del formulario de inicio de sesión';
$string['loginpagesettings'] = 'Configuraciones de la página de inicio de sesión';
$string['footersecondary'] = 'Área inferior del pie de página';
$string['footer-columns'] = 'Columnas del pie de página';
$string['footer-columntitle-color_help'] = 'Establecer color del texto de {$a}';
$string['footer-logo-color'] = 'Seleccionar color de ícono o texto';
$string['footer-logo-color_help'] = 'Seleccionar color de ícono o texto';
// Personalizador de inicio de sesión.
$string['login'] = 'Iniciar sesión';
$string['panel'] = 'Panel';
$string['page'] = 'Página';
$string['loginbackgroundopacity'] = 'Opacidad de la superposición del fondo';
$string['loginbackgroundopacity_help'] = 'Aplicar superposición a la imagen de fondo de la página de inicio de sesión.';
$string['loginpanelbackgroundcolor_help'] = 'Aplicar color de fondo al panel de inicio de sesión.';
$string['loginpaneltextcolor_help'] = 'Aplicar color de texto al panel de inicio de sesión.';
$string['loginpanelcontentcolor_help'] = 'Aplicar color de texto al contenido del panel de inicio de sesión.';
$string['loginpanellinkcolor_help'] = 'Aplicar color de enlace al panel de inicio de sesión.';
$string['loginpanellinkhovercolor_help'] = 'Aplicar color de enlace al pasar el ratón sobre el panel de inicio de sesión.';
$string['login-panel-position'] = 'Posición del panel de inicio de sesión';
$string['login-panel-position_help'] = 'Establecer la posición para el panel de inicio de sesión y registro';
$string['login-page-info'] = '<p><b>Nota: </b>La página de inicio de sesión no se puede previsualizar en el personalizador visual porque solo los usuarios que no han iniciado sesión pueden verla. Puedes probar la configuración guardando y abriendo la página de inicio de sesión en modo incógnito.</p>';
$string['login-page-setting'] = 'Estilo de fondo de la página';
$string['login-page-backgroundgradient1'] = 'Seleccionar Color 1';
$string['login-page-backgroundgradient2'] = 'Seleccionar Color 2';
$string['loginpanelbackgroundcolor'] = 'Color de fondo de la página';
$string['loginpagebackgroundcolor'] = 'Seleccionar color de fondo';
$string['loginpagebackgroundcolor_help'] = 'Establecer fondo de la página de inicio de sesión. Puedes elegir color, degradado o imagen.';
$string['login-page-background_help'] = 'Aplicar color de fondo al panel de inicio de sesión';

/*Strings del Personalizador*/
$string['primary'] = 'Primario';

$string['dashboardsettingdesc'] = 'Configuraciones relacionadas con el tablero';
$string['dashboardsetting'] = 'Tablero';
$string['dashboardpage'] = 'Página del tablero';
$string['enabledashboardcoursestats'] = 'Habilitar estadísticas del curso en el tablero';
$string['enabledashboardcoursestatsdesc'] = 'Si está habilitado, mostrará las estadísticas del curso en la página del tablero';

$string['customizecontrolsclose'] = "Cerrar";

// Configuración rápida del personalizador.
$string['quicksetup'] = 'Configuración rápida';
$string['pallet'] = 'Paleta';
$string['colorpallet'] = 'Paletas de colores';
$string['currentpallet'] = 'Paleta actual';
$string['currentfont'] = 'Fuente actual';
$string['colorpalletdesc'] = 'Descripción de las paletas de colores';
$string['preset1'] = 'Preestablecido 1';
$string['preset2'] = 'Preestablecido 2';
$string['sitefavicon'] = 'Favicon del sitio';

$string['themecolors'] = 'Colores del tema';
$string['brandcolors-heading'] = 'Colores de la marca';
$string['border-color'] = 'Color del borde';
$string['border-hover-color'] = 'Color del borde al pasar el ratón';
$string['smart-colors-heading'] = "Aplicar colores globales";
$string['smart-colors-info'] = "<p>Los colores globales y sus matices se aplicarán al sitio para crear una combinación de colores visualmente impresionante</p><p><b>Nota: </b>Tienes la flexibilidad de personalizar los colores de los elementos individuales en cualquier momento simplemente visitando su configuración específica.</p>";
$string['apply'] = "Aplicar";
$string['backgroundsettings'] = 'Configuraciones de fondo';

$string['ascent-background-color'] = 'Color de fondo de ascenso';
$string['ascent-background-color_help'] = 'Establecer el color de fondo de ascenso. Este color se aplicará al fondo de las etiquetas en el sitio excepto las etiquetas en las tarjetas del curso y el banner del encabezado del curso';
$string['element-background-color'] = 'Color de fondo del elemento';
$string['element-background-color_help'] = 'Establecer el color de fondo del elemento. Este color se aplica al fondo para texto pequeño, fondo al pasar el ratón para textos desplegables, fondo de encabezados de secciones, tooltips, etc';

$string['light-border-color'] = 'Color del borde claro';
$string['themecolors-lightbordercolor_help'] = 'Establecer el color del borde claro. Este color se aplica como borde a elementos con fondos blancos como el menú desplegable de notificaciones en el encabezado, tarjetas de cursos, búsqueda de cursos desplegable y en líneas divisorias en los elementos del bloque, etc';

$string['medium-border-color'] = 'Color del borde medio';
$string['themecolors-mediumbordercolor_help'] = 'Establecer el color del borde medio. Este color se aplica como color del borde y color divisor. Se aplica específicamente como color del borde para menús desplegables y cuadro de búsqueda y también a elementos de fondo para los que se aplica el color de fondo del elemento (Puedes encontrar la configuración del color de fondo del elemento bajo <b>Colores del tema > Configuración de fondo</b>) como fondo para texto pequeño, fondo de encabezados de secciones, tooltips, etc';
$string['borderssettings'] = 'Configuraciones de bordes';

// Configuración del menú rápido.
$string['enablequickmenu'] = 'Habilitar menú rápido';
$string['enablequickmenudesc'] = 'Menú flotante de enlaces rápidos para un acceso más fácil a las páginas.';

// Navegación izquierda del cajón.
$string['coursearchivepage'] = 'Página de archivo de cursos';
$string['createanewcourse'] = 'Crear un nuevo curso';
$string['remuisettings'] = 'Configuraciones de RemUI';

$string['bodysettingslinking'] = 'Enlace de configuraciones avanzadas';
$string['bodysettingslinking_help'] = 'Cuando está habilitado, las configuraciones de Párrafo pequeño y Texto de información pequeño se enlazarán con las configuraciones del cuerpo.';
$string['bodysettingslinked'] = 'Enlazado con configuraciones del cuerpo';
$string['normal-para-font'] = "Párrafo normal";
$string['smallpara-font'] = "Párrafo pequeño";
$string['smallinfo-font'] = "Texto de información pequeño";

$string['interactiveicons'] = 'Íconos interactivos';
$string['noninteractiveicons'] = 'Íconos no interactivos';
$string['singlecolorsicon'] = "Ícono de colores únicos";
$string['scicon-color'] = 'Color';
$string['scicon-color_help'] = 'Color en estado de reposo de ícono de color único';
$string['scicon-hover'] = 'Pasar el ratón';
$string['scicon-hover_help'] = 'Color en estado de pasar el ratón de ícono de color único';
$string['scicon-active'] = 'Activo';
$string['scicon-active_help'] = 'Color en estado activo de ícono de color único';

$string['dualcolorsicon'] = "Ícono de dos colores";
$string['dcicon-color'] = 'Color';
$string['dcicon-color_help'] = 'Color en estado de reposo de ícono de dos colores';
$string['dcicon-hover'] = 'Pasar el ratón';
$string['dcicon-hover_help'] = 'Color en estado de pasar el ratón de ícono de dos colores';
$string['dcicon-active'] = 'Activo';
$string['dcicon-active_help'] = 'Color en estado activo de ícono de dos colores';

$string['non-interactive-color'] = 'Color';
$string['non-interactive-color_help'] = 'Color de ícono no interactivo';
$string['textlink'] = 'Enlace de texto';

$string['header-logo-setting'] = 'Configuraciones del logo del encabezado';
$string['logo-bg-color'] = 'Color de fondo del logo';
$string['logo-bg-color_help'] = 'Establecer color de fondo al logo de la marca del encabezado.';
$string['header-design-settings'] = 'Configuraciones de diseño del encabezado';
$string['hide-show-menu-item'] = 'Ocultar/Mostrar elemento del menú';
$string['hide-dashboard'] = 'Ocultar tablero';
$string['hide-dashboard_help'] = 'Al habilitar esto, se ocultará el elemento del tablero del encabezado';
$string['hide-home'] = 'Ocultar inicio';
$string['hide-home_help'] = 'Al habilitar esto, se ocultará el elemento de inicio del encabezado';
$string['hide-my-courses'] = 'Ocultar mis cursos';
$string['hide-my-courses_help'] = 'Al habilitar esto, se ocultarán mis cursos y los elementos anidados del curso del encabezado';
$string['hide-site-admin'] = 'Ocultar administración del sitio';
$string['hide-site-admin_help'] = 'Al habilitar esto, se ocultará el elemento de administración del sitio del encabezado';
$string['hide-recent-courses'] = 'Ocultar cursos recientes';
$string['hide-recent-courses_help'] = 'Al habilitar esto, se ocultará el menú desplegable de cursos recientes del encabezado';
$string['header-menu-element-bg-color'] = 'Color de fondo del elemento';
$string['header-menu-element-bg-color_help'] = 'Color de fondo del elemento';
$string['header-menu-divider-bg-color'] = 'Color del divisor del elemento';
$string['header-menu-divider-bg-color_help'] = 'Color del divisor del elemento';
$string['hds-iconcolor'] = 'Color del ícono del encabezado';
$string['hds-boxshadow'] = 'Sombra de caja del encabezado';

$string['hds-menuitems'] = 'Elementos del menú del encabezado';
$string['hds-menu-fontsize_desc'] = 'Establecer tamaño de fuente para los elementos del menú del encabezado';
$string['hds-menu-color'] = 'Color del elemento del menú';
$string['hds-menu-color_desc'] = 'Establecer color del elemento del menú del encabezado';
$string['hds-menu-hover-color'] = 'Color del elemento del menú al pasar el ratón';
$string['hds-menu-hover-color_desc'] = 'Establecer color del elemento del menú al pasar el ratón sobre el encabezado';
$string['hds-menu-active-color'] = 'Color del elemento del menú activo';
$string['hds-menu-active-color_desc'] = 'Establecer color del elemento del menú activo del encabezado';

$string['hds-icon-color'] = 'Color de los íconos';
$string['hds-icon-color_help'] = 'Color de los íconos del menú del encabezado';
$string['hds-icon-hover-color'] = 'Color de los íconos al pasar el ratón';
$string['hds-icon-hover-color_help'] = 'Color de los íconos al pasar el ratón sobre el menú del encabezado';
$string['hds-icon-active-color'] = 'Color de los íconos activos';
$string['hds-icon-active-color_help'] = 'Color de los íconos activos del menú del encabezado';

$string['preset1'] = "Preestablecido 1";
$string['preset2'] = "Preestablecido 2";
$string['preset3'] = "Preestablecido 3";
$string['fonts'] = "Fuentes";
$string['show'] = "Mostrar";
$string['hide'] = "Ocultar";

$string['other-bg-color'] = 'Otros colores de fondo';
$string['text-link-panel'] = 'Enlace de texto';
$string['colorpalletes'] = 'Paletas de colores';
$string['selectpallete'] = 'Seleccionar paleta';
$string['selectfont'] = 'Seleccionar fuente';

$string['socialiconspanel'] = "Panel de íconos sociales";
$string['social-icons-info'] = "<p>Para mostrar los íconos de redes sociales en la parte inferior de cualquier columna con contenido, ve a <b>Pie de página > Área principal del pie de página > Widget > Seleccionar tipo = Contenido </b> y activa la configuración para mostrar íconos de redes sociales.</p>";
$string['social-icons-heading'] = "Íconos de redes sociales";
$string["custommenulinktext"] = 'Elementos del menú personalizado';
$string["custommenulink"] = '<h6>Elementos del menú personalizado</h6><p> Para agregar / editar / eliminar elementos del menú personalizado ve a Administración del sitio > Apariencia > Configuración del tema > <a href="{$a}/admin/settings.php?section=themesettings#admin-custommenuitems" target ="_blank" class="text-decoration-none">Elementos del menú personalizado</a> <p>';
$string['note'] = 'Nota';
$string['social-media-selection-note'] = "<p>Presiona Ctrl para seleccionar/deseleccionar los medios</p>";

$string['editmodeswitch'] = "Interruptor de modo de edición";
$string['continue'] = 'Continuar';
$string['viewcourse'] = 'Ver curso';
$string['hiddencourse'] = 'Curso oculto';
$string['openquickmenu'] = 'Abrir menú rápido';
$string['closequickmenu'] = 'Cerrar menú rápido';
$string['start'] = 'Comenzar';

$string['readmore'] = 'Leer más';
$string['readless'] = 'Leer menos';
$string['setting'] = 'Configuraciones';
$string['lastaccess'] = 'Último acceso ';
$string['certificate'] = 'Certificados';
$string['badge'] = 'Insignias';
$string['firstname'] = 'Nombre';
$string['lastname'] = 'Apellido';
$string['badgefrom'] = 'Insignias de {$a}';
$string['timelinenoevenettext'] = 'No hay actividades próximas';
$string['description']  = 'Descripción';
$string['instructorcounttitle'] = "Profesores adicionales disponibles en el curso";

$string['personalizer'] = "Personalizador visual";
$string['edwpersonalizer'] = "Personalizador visual";
$string['editinpersonalizer'] = "Editar con el personalizador";
$string['activepersonalizer'] = "Visualizando en el personalizador de Edwiser.";
$string['searchtotalcount'] = 'Mostrando {$a} resultados';
$string['noresutssearchmsg'] = "<h4 class ='p-p-6 text-center m-0 '>Nada que mostrar</h4>";
$string['globarsearchresult'] = "Resultados de búsqueda global";
$string['searchresultdesctext']  = 'Mostrando resultados para';
$string['noresultfoundmg'] = "<h4 class ='p-p-6 text-center m-0 '>No se encontraron resultados</h4>";

$string['enrol_relatedcourses'] = 'Cursos relacionados';
$string['enrol_latestcourses'] = 'Cursos más recientes';
$string['enrol_coursecardesc'] = 'Descubre tu programa perfecto en nuestros cursos.';
$string['enrol_viewall'] = 'Ver todos';

$string['showrelatedcourse'] = "Mostrar cursos relacionados";
$string['showrelatedcoursedesc'] = "Habilitar esta configuración para mostrar los cursos relacionados en la página de inscripción.";

$string['showlatestcourse'] = 'Mostrar cursos más recientes';
$string['showlatestcoursedesc'] = 'Habilitar esta configuración para mostrar el curso más reciente en la página de inscripción.';

$string['latestcoursecount'] = 'Recuento de bloques de cursos más recientes';
$string['latestcoursecountdesc'] = 'Establecer un número para los cursos más recientes que se muestran en la página de inscripción';

$string['allcourescattext'] = 'Todas las categorías';
$string['archivecoursecounttext'] = 'Cursos';
$string['coursecardlessonstext'] = 'Lecciones';
$string['prevsectionbuttontext'] = 'Sección anterior';
$string['nextsectionbuttontext'] = 'Sección siguiente';

$string['eight'] = '8';
$string['twelve'] = '12';
$string['sixteen'] = '16';
$string['twenty'] = '20';

// Página de Mis Cursos.
$string['resume'] = 'Reanudar';
$string['start'] = 'Comenzar';
$string['completed'] = 'Completado';

$string['siteannouncementheading'] = 'Anuncio a nivel de sitio';
$string['siteannouncementheadingdesc'] = 'Habilitar anuncio a nivel de sitio para todos los usuarios.';
$string['seosettingsheading'] = 'Configuraciones de SEO';
$string['seosettingsheadingdesc'] = 'Optimiza la visibilidad de tu sitio web en los motores de búsqueda.';
$string['sitecustomizationhead'] = 'Personalización del sitio';
$string['sitecustomizationheaddesc'] = 'Elige fuentes, tamaño de diseño para páginas y puedes personalizar con el CSS.';
$string['advancefeatureshead'] = 'Configuraciones de características avanzadas';
$string['advancefeaturesheaddesc'] = 'Mejora tu experiencia de aprendizaje con configuraciones avanzadas.';
$string['mainfooterareahead'] = 'Área principal del pie de página';
$string['mainfooterareaheaddesc'] = 'Configuración del área principal del pie de página';

// Configuraciones avanzadas de peso de fuente para títulos
$string['heading-adv-setting'] = 'Configuraciones de peso de fuente para títulos';
$string['heading-regular-fontweight'] = 'Peso de fuente regular';
$string['heading-semibold-fontweight'] = 'Peso de fuente semi-negrita';
$string['heading-bold-fontweight'] = 'Peso de fuente negrita';
$string['heading-exbold-fontweight'] = 'Peso de fuente extra-negrita';
// Usage tracking.
$string["usagedatatracker"] = "Rastreador de datos de uso";
$string['enableusagetracking'] = "Activar seguimiento de uso";
$string['enableusagetrackingdesc'] = "<strong>AVISO DE SEGUIMIENTO DE USO</strong>

<hr class='text-muted' />

<p>Edwiser ahora recopilará datos anónimos para generar estadísticas de uso del producto.</p>

<p>Esta información nos ayudará a guiar el desarrollo en la dirección correcta y a hacer prosperar la comunidad de Edwiser.</p>

<p>Dicho esto, no recopilamos sus datos personales ni los de sus estudiantes durante este proceso. Puede desactivar esto desde el plugin cuando lo desee para optar por no participar en este servicio.</p>

<p>Se encuentra disponible un resumen de los datos recopilados <strong><a href='https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products' target='_blank'>aquí</a></strong>.</p>";

$string['profileinterestinfo'] = 'Para editar intereses, vaya a Configuración de perfil -> Editar perfil ->';
$string['profileinterest'] = 'Intereses';
$string['citytowntext'] = 'Ciudad/Pueblo';
$string['selectcountrystring'] = 'Seleccionar un país...';

$string['heading-fontweight_desc'] = 'Configurar el peso de la fuente de los encabezados para todo el sitio.';
$string['small-para-fontweight_desc'] = 'Configurar el peso de la fuente para párrafos pequeños en todo el sitio.';
$string['small-info-fontweight_desc'] = 'Configurar el peso de la fuente para información pequeña en todo el sitio.';

$string['full-width-top'] = 'Superior de ancho completo';
$string['full-bottom'] = 'Inferior de ancho completo';


$string['homepageedwpagebuilderoption'] = "Usar Edwiser Pagebuilder para la página de inicio";

$string['livecustomizer'] = "Personalizador en vivo";

$string['loaderimagehead'] = 'Imagen de carga del sitio';
$string['loaderimagedesc'] = 'Elige la imagen de carga para tu sitio';

$string['region-full-bottom'] = 'Región inferior de ancho completo';
$string['region-full-width-top'] = 'Región superior de ancho completo';

$string['homepagetransparentheadertitle'] = 'Estilo de encabezado transparente';
$string['homepagetransparentheaderdesc']  = "Haz que el encabezado de tu página de inicio sea transparente";

$string['frontpageheadercolortitle'] = 'Elige el color del texto del encabezado';
$string['frontpageheadercolordesc']  = "Elige el color del texto del encabezado";

$string['transparentheaderheader'] = 'Estilo del encabezado de la página de inicio';
$string['transparentheaderheaderdesc'] = 'Habilitar / deshabilitar el estilo de encabezado transparente';

$string['hidehomepageelement'] = 'Ocultar elementos de la página de inicio';
$string['hidehomepageelementdesc'] = 'Ocultar encabezado de contenido, subnavegación y sección de actividad';

$string['hideheadercontenttitle'] = 'Ocultar encabezado de contenido';
$string['hideheadercontentdesc'] = 'Si se habilita, se eliminarán el nombre del sitio y la navegación secundaria de Moodle en la página de inicio';

$string['hideactivitysectiontitle'] = 'Ocultar sección de actividad';
$string['hideactivitysectiondesc'] = 'Si se habilita, se ocultará la sección de actividad en la página de inicio.';

$string['floataddblockbtnregionselectionmsg'] = 'Los nuevos bloques se agregarán a la región "{$a}" actualmente visible';

// settings page deprication design strings
$string['settingpage-dep-top-st1'] = '¡Introduciendo una mejor manera de construir y personalizar páginas de inicio!';
$string['settingpage-dep-top-st2'] = 'Nos complace presentar Edwiser RemUI Page Builder para crear páginas de inicio junto con una biblioteca de plantillas recién diseñadas que incluye más de 30 plantillas de bloques y 7 diseños de página de inicio';
$string['settingpage-dep-top-st3'] = '1. Actualice Edwiser RemUI Page Builder a la versión v4.2.0 y superior desde <a href="https://edwiser.org/my-account/" target="_blank">aquí</a>';

$string['settingpagedepbottomst1'] = 'Seleccione el Constructor de Páginas en el menú desplegable anterior y vaya a la página de inicio para crear un nuevo diseño de página de inicio.';
$string['settingpagedepbottomst2'] = 'Más información';
$string['settingpagedepbottomst3'] = 'O';

$string['settingpagedepbottomsecondaryst1'] = 'Migre automáticamente el contenido del constructor de la página de inicio al Constructor de Páginas de Edwiser.';
$string['settingpagedepbottomsecondaryst2'] = '<span class="para-semibold-1 m-0">Nota:</span> Se requiere el plugin del Constructor de Páginas Edwiser RemUI versión v4.2.0 y el plugin del constructor de la página de inicio versión v4.1.3.';
$string['settingpagedepbottomsecondaryst3'] = '¿Qué sucederá?';
$string['settingpagedepbottomsecondaryst4'] = 'El código y el contenido de cada sección de la página de inicio actual se trasladarán a un bloque HTML personalizado en Edwiser RemUI Page Builder. El diseño y el contenido de la página seguirán siendo los mismos, y podrás editarlo fácilmente de una manera <strong>sin código usando Edwiser RemUI Page Builder</strong>.';
$string['settingpagedepbottomsecondaryst5'] = '<span class="para-semibold-1 m-0">Nota:</span> Esta es la última actualización sobre el Constructor de Páginas de Inicio. Ahora se ha fusionado en el Constructor de Páginas de Edwiser';



$string['upgradeherelinktext'] = 'actualizar aquí';

$string['addnewpage'] = "Agregar una nueva página";

$string['edwiserfeedback'] = "Comentarios de Edwiser";
$string['edwiserhelp'] = "Ayuda de Moodle";
$string['edwisersupport'] = "Soporte de Edwiser";


// Course page new settings and improvement stirings
$string['courseinfocontrolhead'] = "Control de información del curso";
$string['courseinfocontroldesc'] = "Controla la visibilidad de la información relacionada con el curso en todo el sitio";

$string['coursedatevisibilityhead'] = "Mostrar 'Fecha' en el curso";
$string['coursedatevisibilitydesc'] = "Mostrar 'Fecha' en el curso";

$string['hidedate'] = "No mostrar";
$string['showstartdate'] = "Mostrar fecha de inicio";
$string['showupdatedate'] = "Mostrar fecha de actualización";
$string['showstartwhenend'] = "Mostrar inicio y fin";
$string['enrolleduserscountvisibilityhead'] = "Mostrar información de 'Estudiantes inscritos'";
$string['enrolleduserscountvisibilitydesc'] = "Desactivar para ocultar la información de 'Estudiantes inscritos'";

$string['lessonsvisiblityoncoursecardhead'] = "Mostrar información de 'Lecciones'";
$string['lessonsvisiblityoncoursecarddesc'] = "Desactivar para ocultar la información de 'Lecciones'";

$string['coursecardsettingshead'] = "Tarjeta de curso";
$string['coursecardsettingsdesc'] = "Configuraciones relacionadas con la tarjeta del curso";

$string['headeroverlayopacityhead'] = "Cambiar la opacidad del superpuesto";
$string['headeroverlayopacitydesc'] = "El valor predeterminado ya está establecido en '100'. Para ajustar la opacidad, ingresa un valor entre 0 y 100";

$string['showless'] = 'Mostrar menos';
$string['showmore'] = 'Mostrar más';

$string['coursestarted'] = "Comenzado";
$string['courseupdated'] = "Actualizado";

$string['coursecardlessonssingletext'] = 'Lección';
$string['coursecardsenrolledetxt'] = 'Inscritos';

$string['showenrolledtexthead'] = 'Mostrar título \'Inscritos\'';
$string['showenrolledtextdesc'] = '';

$string['showenrolledtextinputhead'] = '';
$string['showenrolledtextinputdesc'] = 'Renombrar el título \'Inscritos\'.<br><strong>Se recomienda un máximo de 8 caracteres</strong>';
$string['showenrolledtextinputdefaulttext'] = 'Inscritos';

$string['showlessontexthead'] = 'Mostrar título \'Lección\'';
$string['showlessontextdesc'] = '';

$string['showlessontextinputhead'] = '';
$string['showlessontextinputdesc'] = 'Renombrar el título \'Lecciones\'.<br><strong>Se recomienda un máximo de 8 caracteres</strong>';
$string['showlessontextinputdefaulttext'] = 'Lecciones';

$string['editcoursetitle'] = 'Editar título del curso';
$string['changecategory'] = 'Cambiar categoría';
$string['editreviewapproval'] = 'Editar aprobación de reseñas';
$string['addchangevideo'] = 'Agregar/Cambiar video';
$string['novideomessage'] = 'No hay video.<br>Haz clic en el enlace de arriba para agregar un video.';
$string['changecourseimage'] = 'Cambiar imagen del curso';
$string['changebtntextandlink'] = 'Añadir enlace y precio';
$string['edit'] = 'Editar';
$string['viewalltext'] = 'Ver todo';
$string['addremuicustomfield'] = 'Agregar campo personalizado de RemUI';
$string['editremuicustomfield'] = 'Editar campo personalizado de RemUI';
$string['howtoaddcustomfield'] = '¿Cómo agregar y editar campos personalizados de RemUI?';
$string['changebtntext'] = 'Cambiar texto del botón';
$string['addlink'] = 'Agregar enlace';
$string['save'] = 'Guardar';
$string['cancel'] = 'Cancelar';
$string['updateenrollmentmethods'] = 'Actualizar métodos de <span class="text-lowercase">{$a}</span>';
$string['hideenrollmentoptions'] = 'Ocultar opciones de <span class="text-lowercase">{$a}</span>';
$string['showenrollmentoptions'] = 'Mostrar opciones de <span class="text-lowercase">{$a}</span>';
$string['editcoursetext'] = 'Editar texto del curso';
$string['editcoursecontent'] = 'Editar contenido del curso';
$string['manageinstructors'] = 'Gestionar instructores';
$string['message'] = 'Mensaje';
$string['email'] = 'Correo electrónico:';
$string['editcoursessectionsettings'] = 'Editar configuraciones de sección de cursos';
$string['sectionishiddenmessage'] = 'Esta sección está oculta.<br>Para hacerla visible, haz clic en el enlace de arriba "Mostrar opciones de inscripción"';
$string['noreviewmessage'] = 'Actualmente no hay reseñas.<br> Para ver reseñas pendientes de aprobación, haz clic en el enlace "Editar aprobación de reseñas".';
$string['backtothecourse'] = 'Volver al curso';
$string['viewcourseenrollmentpage'] = 'Ver página de inscripción del curso <span class="text-lowercase">{$a}</span>';
$string['unenroll'] = 'Anular inscripción';
$string['toactivateenrollmenttext'] = 'para activar el enlace de la página de inscripción';
$string['showhidefreelabel'] = 'Mostrar/Ocultar etiqueta \'GRATIS\'';
$string['norelatedcoursemessage'] = 'La sección de \'Cursos relacionados\' está oculta.<br>Para hacerla visible, haz clic en el enlace de arriba "Editar configuraciones de sección de cursos"';
$string['nolatestcoursemessage'] = 'La sección de \'Últimos cursos\' está oculta.<br>Para hacerla visible, haz clic en el enlace de arriba "Editar configuraciones de sección de cursos"';
$string['showhidefreelabel'] = 'Mostrar/Ocultar etiqueta \'GRATIS\'';
$string['editpricing'] = 'Editar precios';
$string['nocontentmessage'] = 'No hay contenido en esta sección.<br>Para agregar contenido, haz clic en el enlace de arriba "Editar texto del curso"';
$string['noinstructormessage'] = 'No hay instructores inscritos en este curso.<br>Para agregar un instructor, haz clic en el enlace de arriba "Gestionar instructores"';
$string['noinstructor'] = 'Sin instructor';

// Dark mode settings strings
$string['darkmodetitilestring'] = 'Modo oscuro';
$string['lightmodetitlestring'] = 'Modo claro';
$string['darkmodesettingshead'] = 'Configuraciones del modo oscuro';
$string['darkmodesettingsheaddesc'] = 'Controla el modo claro y oscuro de tu sitio web';
$string['enabledarkmode'] = 'Habilitar funcionalidad de modo oscuro';
$string['enabledarkmodedesc'] = '';
$string['dmoption_disable'] = 'Desactivar';
$string['dmoption_allowonallpages'] = 'Permitir en todas las páginas';
$string['dmoption_excludepages'] = 'Permitir en todas las páginas excepto estas páginas';
$string['dmoption_includepages'] = 'Permitir solo en estas páginas';
$string['darkmodeincludepages'] = 'Incluir solo en estas páginas';
$string['darkmodeincludepagesdesc']  = '<div><strong>Para gestionar el modo oscuro en páginas específicas, simplemente agrega la URL de la página.</strong>
<pre>Ejemplo:
    Para incluir/excluir el modo oscuro en una página de curso específica (por ejemplo, el curso con id=2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>Para gestionar el modo oscuro en grupos de páginas</strong>
<pre>Ejemplo:
    Para incluir/excluir el modo oscuro en todas las páginas de cursos
    <moodlesite.com>/course/view.php%
</pre>
Para una explicación más detallada <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">haz clic aquí</a>.</div>';

$string['darkmodeexcludepages'] = 'Excluir páginas';
$string['darkmodeexcludepagesdesc']  = '<div><strong>Para gestionar el modo oscuro en páginas específicas, simplemente agrega la URL de la página.</strong>
<pre>Ejemplo:
    Para incluir/excluir el modo oscuro en una página de curso específica (por ejemplo, el curso con id=2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>Para gestionar el modo oscuro en grupos de páginas</strong>
<pre>Ejemplo:
    Para incluir/excluir el modo oscuro en todas las páginas de cursos
    <moodlesite.com>/course/view.php%
</pre>
Para una explicación más detallada <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">haz clic aquí</a>.</div>';

$string['customizerdarkmodewarning'] = "Ten en cuenta que los cambios realizados en el Personalizador Visual se aplicarán al 'modo claro' del sitio y se reflejarán automáticamente en el 'modo oscuro' también.";
$string['customizerdarkmodedonotshowbtntext'] = 'No mostrar de nuevo';
$string['customizerdarkmodeok'] = 'Aceptar';
$string['previewswitchon'] = 'Encender';
$string['previewswitchoff'] = 'Apagar';
$string['darkmodepreview'] =  'Vista previa del modo oscuro';
$string['darkmodecustomizernote']='<li>En el ‘Personalizador visual’, todos los cambios se realizarán en el ‘modo claro’ del sitio y se reflejarán automáticamente en el ‘modo oscuro’.</li>
<li>La configuración del Personalizador visual se desactivará al previsualizar en el modo oscuro.</li>';
$string["switchtodm"] = "Modo oscuro";
$string["switchtolm"] = "Modo claro";
$string["disabledmwarning"] = "Para habilitar el Personalizador visual, apaga la vista previa del modo oscuro.";


$string["here"] = "aquí";
$string["clickhere"] = "Haz clic aquí";
$string["settingpagedepbottomsecondaryst2b"] = '<a href="https://edwiser.org/my-account/" target="_blank" >Haz clic aquí</a> para descargar y actualizar los complementos a su última versión.';
$string['settingpage-dep-top-st4'] = '1. Descarga e instala el Constructor de Páginas Edwiser RemUI a la versión v4.2.0 y superior desde <a href="https://edwiser.org/my-account/" target="_blank">aquí</a>';
$string['viewcoursetitle'] = 'Ver curso';
$string['okay'] = '¡Aceptar!';
$string['forcefulmigrate'] = 'Migración forzada';

$string['moodleblocks'] = 'Bloques de Moodle';

$string['citytown'] = 'Ciudad/Pueblo';
$string['searchtext'] = 'Texto de búsqueda';
$string['enablesiteloader'] = "Habilitar/Deshabilitar imagen de carga";
$string['enablesiteloaderdesc'] = "Para deshabilitar el GIF de carga en el sitio, desmarque la casilla denominada \"Habilitar/Deshabilitar imagen de carga\". Para habilitarlo, simplemente marque la casilla.";
$string['aria:courseimage'] = 'Imagen del curso';

$string['addcustomprice'] = 'Agregar un precio personalizado';
$string['enablepricingsettingstext'] = 'Habilitar el precio predeterminado eliminará el "precio personalizado y el enlace de inscripción personalizado".';
$string['enabledefaultpricing'] = 'Habilitar precio predeterminado';
$string["dashboardstatsupdate"] = "Actualización de estadísticas de RemUI";

$string["filters"] = "Filtros";
$string["applyfilters"] = "Aplicar filtros";
$string["clear"] = "Limpiar";
$string["level"] = "Nivel";
$string["ratings"] = "Calificaciones";
$string["free"] = "Gratis";
$string["paid"] = "Pagado";
$string["rating4"] = "4 y superior";
$string["rating3"] = "3 y superior";
$string["newest"] = "Más reciente";
$string["oldest"] = "Más antiguo";
$string["highrating"] = "Alta calificación";
$string["lowrating"] = "Baja calificación";
$string["date"] = "Fecha";
$string["alphabetical"] = "Alfabético";
$string["showcourseperpage"] = "Mostrar curso por página";
$string["close"] = "Cerrar";
$string["row2"] = "Mostrar:2 fila";
$string["row3"] = "Mostrar:3 filas";
$string["row4"] = "Mostrar:4 filas";
$string["row5"] = "Mostrar:5 filas";
$string["row6"] = "Mostrar:6 filas";

$string["filteremptymsg"] = "NOTA: Para ver los filtros, agregue propiedades de filtro como Niveles, Precio, Calificaciones e Idiomas al curso.";

$string['sectionaddmax'] = 'Has alcanzado el número máximo de secciones permitidas para un curso...';
$string['prevsubsectionbuttontext'] = 'Subsección anterior';
$string['nextsubsectionbuttontext'] = 'Siguiente subsección';
