<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package   theme_remui
 * @copyright (c) 2023 WisdmLabs (https://wisdmlabs.com/) <support@wisdmlabs.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['advancedsettings'] = 'الإعدادات المتقدمة';
$string['backgroundimage'] = 'صورة الخلفية';
$string['backgroundimage_desc'] = 'الصورة المعروضة كخلفية للموقع. الصورة التي تقوم بتحميلها هنا ستتم استبدال صورة الخلفية في ملفات النماذج الثابتة للسمة.';
$string['brandcolor'] = 'لون العلامة التجارية';
$string['brandcolor_desc'] = 'لون العلامة التجارية.';
$string['bootswatch'] = 'Bootswatch';
$string['bootswatch_desc'] = 'مجموعة من المتغيرات وأنماط CSS التي تخص Bootstrap للتنسيق.';
$string['choosereadme'] = 'Edwiser RemUI هو قالب Moodle قابل للتخصيص مصمم لتحسين تجربة التعلم الإلكتروني عن طريق معالجة التحديات مثل التخصيص المحدود ومشاكل واجهة المستخدم. مع تصميمه الحديث والبديهي وميزاته الشاملة، يمكنك بسهولة إنشاء موقع مرئي رائع يعزز تفاعل الطلاب ويقدم تجربة سيحبها المتعلمون!';
$string['currentinparentheses'] = '(الحالي)';
$string['configtitle'] = 'Edwiser RemUI';
$string['generalsettings'] = 'الإعدادات الأساسية';
$string['loginbackgroundimage'] = 'صورة الخلفية لصفحة تسجيل الدخول';
$string['loginbackgroundimage_desc'] = 'الصورة المعروضة كخلفية لصفحة تسجيل الدخول.';
$string['nobootswatch'] = 'لا شيء';
$string['pluginname'] = 'Edwiser RemUI';
$string['presetfiles'] = 'ملفات السمات الثابتة الإضافية';
$string['presetfiles_desc'] = 'يمكن استخدام ملفات السمات الثابتة لتغيير مظهر السمة بشكل كبير. انظر <a href="https://docs.moodle.org/dev/remui_Presets">ملفات السمات الثابتة لـ RemUI</a> لمزيد من المعلومات حول إنشاء ومشاركة ملفات السمات الخاصة بك، وانظر إلى <a href="https://archive.moodle.net/remui">مستودع السمات الثابتة</a> لمشاركة السمات التي قام بها الآخرون.';
$string['preset'] = 'السمة الثابتة';
$string['preset_desc'] = 'اختر سمة ثابتة لتغيير مظهر السمة بشكل عام.';
$string['privacy:metadata'] = 'السمة RemUI لا تخزن أي بيانات شخصية عن أي مستخدم.';
$string['rawscss'] = 'SCSS الخام';
$string['rawscss_desc'] = 'استخدم هذا الحقل لتقديم رموز SCSS أو CSS سيتم حقنها في نهاية ورقة الأنماط.';
$string['rawscsspre'] = 'SCSS الابتدائي الخام';
$string['rawscsspre_desc'] = 'يمكنك استخدام هذا الحقل لتقديم رموز SCSS الابتدائية، سيتم حقنها قبل كل شيء آخر. في معظم الأوقات ستستخدم هذا الإعداد لتعريف المتغيرات.';
$string['region-side-pre'] = 'اليمين';
$string['region-side-top'] = 'الأعلى';
$string['region-side-bottom'] = 'الأسفل';
$string['showfooter'] = 'عرض التذييل';
$string['unaddableblocks'] = 'الكتل غير القابلة للإضافة';
$string['unaddableblocks_desc'] = 'الكتل المحددة غير ضرورية عند استخدام هذه السمة ولن تظهر في قائمة "إضافة كتلة".';
$string['privacy:metadata:preference:draweropenblock'] = 'تفضيل المستخدم لإظهار أو إخفاء اللوحة مع الكتل.';
$string['privacy:metadata:preference:draweropenindex'] = 'تفضيل المستخدم لإظهار أو إخفاء درج فهرس الدورة.';
$string['privacy:metadata:preference:draweropennav'] = 'تفضيل المستخدم لإظهار أو إخفاء قائمة تصفح اللوحة.';
$string['privacy:drawerindexclosed'] = 'التفضيل الحالي لدرج الفهرس مغلق.';
$string['privacy:drawerindexopen'] = 'التفضيل الحالي لدرج الفهرس مفتوح.';
$string['privacy:drawerblockclosed'] = 'التفضيل الحالي للوحة الكتل مغلق.';
$string['privacy:drawerblockopen'] = 'التفضيل الحالي للوحة الكتل مفتوح.';
$string['privacy:drawernavclosed'] = 'التفضيل الحالي لقائمة التصفح مغلقة.';
$string['privacy:drawernavopen'] = 'التفضيل الحالي لقائمة التصفح مفتوحة.';

// Deprecated since Moodle 4.0.
$string['totop'] = 'العودة إلى الأعلى';

// Edwiser RemUI Settings Page Strings.

// Settings Tabs strings.
$string['homepagesettings'] = 'الصفحة الرئيسية';
$string['coursesettings'] = "صفحة الدورة";
$string['footersettings'] = 'التذييل';
$string["formsettings"] = "النماذج";
$string["iconsettings"] = "الأيقونات";
$string['loginsettings'] = 'صفحة تسجيل الدخول';

$string['versionforheading'] = '<span class="small remuiversion"> الإصدار {$a}</span>';
$string['themeversionforinfo'] = '<span>الإصدار المثبت حاليًا: Edwiser RemUI v{$a}</span>';

// General Settings.
$string['mergemessagingsidebar'] = 'دمج لوحة الرسائل';
$string['mergemessagingsidebardesc'] = 'دمج لوحة الرسائل في الشريط الجانبي الأيمن';
$string['logoorsitename'] = 'اختيار شكل شعار الموقع';
$string['logoorsitenamedesc'] = 'شعار فقط - شعار العلامة التجارية الكبير<br /> شعار صغير - شعار العلامة التجارية الصغير <br /> رمز فقط - رمز كعلامة تجارية <br/> رمز واسم الموقع - رمز مع اسم الموقع';
$string['onlylogo'] = 'شعار فقط';
$string['logo'] = 'شعار';
$string['logomini'] = 'شعار صغير';
$string['icononly'] = 'رمز فقط';
$string['iconsitename'] = 'رمز واسم الموقع';
$string['logodesc'] = 'يمكنك إضافة الشعار ليظهر في الرأس. ملاحظة - الارتفاع المفضل هو 50 بكسل. في حال رغبتك في التخصيص، يمكنك القيام بذلك من مربع CSS المخصص.';
$string['logominidesc'] = 'يمكنك إضافة شعار صغير ليظهر في الرأس عند طي الشريط الجانبي. ملاحظة - الارتفاع المفضل هو 50 بكسل. في حال رغبتك في التخصيص، يمكنك القيام بذلك من مربع CSS المخصص.';
$string['siteicon'] = 'رمز الموقع';
$string['siteicondesc'] = 'لا تملك شعارًا؟ يمكنك اختيار واحد من <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new" ><b style="color:#17a2b8!important">القائمة</b></a>. <br /> فقط أدخل النص بعد "fa-".';
$string['navlogin_popup'] = 'تمكين نافذة تسجيل الدخول الفوري';
$string['navlogin_popupdesc'] = 'تمكين نافذة تسجيل الدخول الفوري لتسجيل الدخول بسرعة دون إعادة توجيه إلى صفحة تسجيل الدخول.';
$string['coursecategories'] = 'الفئات';
$string['enablecoursecategorymenu'] = "القائمة المنسدلة للفئة في الرأس";
$string['enablecoursecategorymenudesc'] = "احتفظ بتفعيل هذا إذا كنت ترغب في عرض قائمة الفئات المنسدلة في الرأس.";
$string['coursepagesettings'] = "صفحة الدورة";
$string['coursepagesettingsdesc'] = "إعدادات ذات صلة بالدورات.";
$string['coursecategoriestext'] = "إعادة تسمية القائمة المنسدلة للفئة في الرأس";
$string['coursecategoriestextdesc'] = "يمكنك إضافة اسم مخصص لقائمة الفئات المنسدلة في الرأس.";
$string['enablerecentcourses'] = 'تمكين الدورات الحديثة';
$string['enablerecentcoursesdesc'] = 'إذا تم تمكينها، ستظهر قائمة الدورات الحديثة في الرأس.';
$string['recent'] = 'الحديثة';
$string['recentcoursesmenu'] = 'قائمة الدورات الحديثة';
$string['searchcatplaceholdertext'] = 'البحث في الفئات';
$string['viewallnotifications'] = 'عرض جميع الإشعارات';
$string['forgotpassword'] = 'هل نسيت كلمة المرور؟';
$string['enableannouncement'] = "تمكين الإعلان عبر الموقع";
$string['enableannouncementdesc'] = "تمكين إعلان عبر الموقع لجميع المستخدمين.";
$string['enabledismissannouncement'] = "تمكين الإعلان القابل للإغلاق عبر الموقع";
$string['enabledismissannouncementdesc'] = "إذا تم تمكينه، يُسمح للمستخدمين بإغلاق الإعلان.";
$string['brandlogo'] = 'شعار العلامة التجارية';
$string['brandname'] = 'اسم العلامة التجارية';

$string['announcementtext'] = "الإعلان";
$string['announcementtextdesc'] = "رسالة الإعلان التي ستعرض على مستوى الموقع.";
$string['announcementtype'] = "نوع الإعلان";
$string['announcementtypedesc'] = "حدد نوع الإعلان لعرض لون خلفية مختلف للإعلان.";
$string['typeinfo'] = "معلومات";
$string['typedanger'] = "عاجل";
$string['typewarning'] = "تحذير";
$string['typesuccess'] = "نجاح";

// Google Analytics.
$string['googleanalytics'] = 'معرف تتبع Google Analytics';
$string['googleanalyticsdesc'] = 'الرجاء إدخال معرف تتبع Google Analytics الخاص بك لتمكين التحليلات على موقعك على الويب. يجب أن يكون تنسيق معرف التتبع كما يلي [UA-XXXXX-Y]. <br/> يرجى أن تكون على علم بأنه من خلال تضمين هذا الإعداد، ستقوم بإرسال بيانات إلى Google Analytics ويجب عليك التأكد من تحذير مستخدميك حول ذلك. منتجنا لا يخزن أي من البيانات التي يتم إرسالها إلى Google Analytics.';
$string['favicon'] = 'رمز الموقع';
$string['favicosize'] = 'الحجم المتوقع هو 16x16 بكسل';
$string['favicondesc'] = 'رمز "المفضلة" لموقعك على الويب. إنه تذكير بصري لهوية الموقع ويتم عرضه في شريط العنوان أو علامات المتصفح.';
$string['fontselect'] = 'محدد نوع الخط';
$string['fontselectdesc'] = 'اختيار من بين الخطوط القياسية أو <a href="https://fonts.google.com/" target="_new">خطوط Google على الويب</a>. يرجى حفظ لعرض الخيارات المتاحة لاختيارك. ملاحظة: إذا تم تعيين محدد الخطوط البصرية إلى الخطوط القياسية، سيتم تطبيق خطوط Google على الويب.';
$string['fontname'] = 'خط الموقع';
$string['fontnamedesc'] = 'أدخل اسم الخط الدقيق المستخدم لـ Moodle.';
$string['fonttypestandard'] = 'الخط القياسي';
$string['fonttypegoogle'] = 'خطوط Google على الويب';

$string['sendfeedback'] = "إرسال ملاحظات لـ Edwiser";
$string['enableedwfeedback'] = "ملاحظات ودعم Edwiser";
$string['enableedwfeedbackdesc'] = "تمكين ملاحظات ودعم Edwiser، مرئي للمسؤولين فقط.";
$string["checkfaq"] = "Edwiser RemUI - تحقق من الأسئلة الشائعة";
$string['poweredbyedwiser'] = 'مدعوم بواسطة Edwiser';
$string['poweredbyedwiserdesc'] = 'ألغ تحديد الخانة لإزالة \'مدعوم بواسطة Edwiser\' من موقعك.';
$string['enabledictionary'] = 'تمكين القاموس';
$string['enabledictionarydesc'] = 'إذا تم تمكينه، سيتم تنشيط ميزة القاموس التي ستظهر معاني النص المحدد في نافذة منبثقة.';
$string['customcss'] = 'CSS مخصص';
$string['customcssdesc'] = 'يمكنك تخصيص CSS من المربع أعلاه. ستُعكس التغييرات على جميع صفحات موقعك.';
// Footer Content.
$string['followus'] = 'تابعنا';
$string['poweredby'] = 'مشغل بواسطة';

// One click report  bug/feedback.
$string['sendfeedback'] = "إرسال ملاحظات لـ Edwiser";
$string['descriptionmodal_text1'] = "<p>تتيح لك الملاحظات إرسال اقتراحات حول منتجاتنا. نرحب بتقارير المشاكل وأفكار الميزات والتعليقات العامة.</p><p>ابدأ بكتابة وصف موجز:</p>";
$string['descriptionmodal_text2'] = "<p>بعد ذلك سنتيح لك تحديد المناطق المتعلقة بالصفحة بالنسبة لوصفك.</p>";
$string['emptydescription_error'] = "يرجى إدخال وصف.";
$string['incorrectemail_error'] = "الرجاء إدخال عنوان بريد إلكتروني صحيح.";

$string['highlightmodal_text1'] = "انقر واسحب على الصفحة لمساعدتنا في فهم ملاحظاتك بشكل أفضل. يمكنك تحريك هذا الحوار إذا كان في الطريق.";
$string['highlight_button'] = "تسليط الضوء على المنطقة";
$string['blackout_button'] = "إخفاء المعلومات";
$string['highlight_button_tooltip'] = "تسليط الضوء على المناطق ذات الصلة بملاحظاتك.";
$string['blackout_button_tooltip'] = "إخفاء أي معلومات شخصية.";

$string['feedbackmodal_next'] = 'التقاط لقطة شاشة والمتابعة';
$string['feedbackmodal_skipnext'] = 'تخطي والاستمرار';
$string['feedbackmodal_previous'] = 'السابق';
$string['feedbackmodal_submit'] = 'إرسال';
$string['feedbackmodal_ok'] = 'حسنا';

$string['description_heading'] = 'الوصف';
$string['feedback_email_heading'] = 'البريد الإلكتروني';
$string['additional_info'] = 'معلومات إضافية';
$string['additional_info_none'] = 'لا شيء';
$string['additional_info_browser'] = 'معلومات المتصفح';
$string['additional_info_page'] = 'معلومات الصفحة';
$string['additional_info_pagestructure'] = 'هيكل الصفحة';
$string['feedback_screenshot'] = 'لقطة شاشة';
$string['feebdack_datacollected_desc'] = 'يمكن الاطلاع على نظرة عامة على البيانات المجمعة <strong><a href="https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products" target="_blank">هنا</a></strong>.';

$string['submit_loading'] = 'جار التحميل...';
$string['submit_success'] = 'شكرًا لملاحظاتك. نقدر كل قطعة من الملاحظات التي نتلقاها.';
$string['submit_error'] = 'للأسف، حدث خطأ أثناء إرسال ملاحظاتك. يرجى المحاولة مرة أخرى.';
$string['send_feedback_license_error'] = "يرجى تنشيط الترخيص للحصول على دعم المنتج.";
$string['disabled'] = 'معطل';

$string['nocoursefound'] = 'لم يتم العثور على دورة';

$string['pagewidth'] = 'تخطيط السمة';
$string['pagewidthdesc'] = 'هنا يمكنك اختيار حجم التخطيط للصفحات.';
$string['defaultpermoodle'] = 'عرض ضيق (افتراضي Moodle)';
$string['fullwidthlayout'] = 'عرض كامل';
// Footer Page Settings.
$string['footersettings'] = 'التعديلات';
$string['socialmedia'] = 'وسائل التواصل الاجتماعي';
$string['socialmediadesc'] = 'أدخل روابط وسائل التواصل الاجتماعي لموقعك.';
$string['facebooksetting'] = 'فيسبوك';
$string['facebooksettingdesc'] = 'أدخل رابط صفحة فيسبوك موقعك. على سبيل المثال: https://www.facebook.com/pagename';
$string['twittersetting'] = 'تويتر';
$string['twittersettingdesc'] = 'أدخل رابط صفحة تويتر موقعك. على سبيل المثال: https://www.twitter.com/pagename';
$string['linkedinsetting'] = 'لينكد إن';
$string['linkedinsettingdesc'] = 'أدخل رابط صفحة لينكد إن موقعك. على سبيل المثال: https://www.linkedin.com/in/pagename';
$string['gplussetting'] = 'جوجل بلس';
$string['gplussettingdesc'] = 'أدخل رابط صفحة جوجل بلس موقعك. على سبيل المثال: https://plus.google.com/pagename';
$string['youtubesetting'] = 'يوتيوب';
$string['youtubesettingdesc'] = 'أدخل رابط صفحة يوتيوب موقعك. على سبيل المثال: https://www.youtube.com/channel/UCU1u6QtAAPJrV0v0_c2EISA';
$string['instagramsetting'] = 'إنستجرام';
$string['instagramsettingdesc'] = 'أدخل رابط صفحة إنستجرام موقعك. على سبيل المثال: https://www.instagram.com/name';
$string['pinterestsetting'] = 'بينتيريست';
$string['pinterestsettingdesc'] = 'أدخل رابط صفحة بينتيريست موقعك. على سبيل المثال: https://www.pinterest.com/name';
$string['quorasetting'] = 'كوورا';
$string['quorasettingdesc'] = 'أدخل رابط صفحة كوورا موقعك. على سبيل المثال: https://www.quora.com/name';
$string['footerbottomtext'] = 'نص أسفل النافذة';
$string['footerbottomlink'] = 'رابط أسفل النافذة الأيسر';
$string['footerbottomlinkdesc'] = 'أدخل الرابط لقسم أسفل النافذة الأيسر. على سبيل المثال: http://www.yourcompany.com';
$string['footercolumn1heading'] = 'محتوى التذييل للعمود الأول (اليسار)';
$string['footercolumn1headingdesc'] = 'يتعلق هذا القسم بالجزء السفلي (العمود 1) من الصفحة الرئيسية الخاصة بك.';
$string['footercolumn1title'] = 'عنوان العمود الأول للتذييل';
$string['footercolumn1titledesc'] = 'إضافة عنوان لهذا العمود.';
$string['footercolumncustomhtml'] = 'محتوى مخصص';
$string['footercolumn1customhtmldesc'] = 'يمكنك تخصيص HTML لهذا العمود باستخدام المربع المخصص أعلاه.';
$string['footercolumn2heading'] = 'محتوى التذييل للعمود الثاني (الوسط)';
$string['footercolumn2headingdesc'] = 'يتعلق هذا القسم بالجزء السفلي (العمود 2) من الصفحة الرئيسية الخاصة بك.';
$string['footercolumn2title'] = 'عنوان العمود الثاني للتذييل';
$string['footercolumn2titledesc'] = 'إضافة عنوان لهذا العمود.';
$string['footercolumn2customhtml'] = 'HTML مخصص';
$string['footercolumn2customhtmldesc'] = 'يمكنك تخصيص HTML لهذا العمود باستخدام المربع المخصص أعلاه.';
$string['footercolumn3heading'] = 'محتوى التذييل للعمود الثالث (الوسط)';
$string['footercolumn3headingdesc'] = 'يتعلق هذا القسم بالجزء السفلي (العمود 3) من الصفحة الرئيسية الخاصة بك.';
$string['footercolumn3title'] = 'عنوان العمود الثالث للتذييل';
$string['footercolumn3titledesc'] = 'إضافة عنوان لهذا العمود.';
$string['footercolumn3customhtml'] = 'HTML مخصص';
$string['footercolumn3customhtmldesc'] = 'يمكنك تخصيص HTML لهذا العمود باستخدام المربع المخصص أعلاه.';
$string['footercolumn4heading'] = 'محتوى التذييل للعمود الرابع (اليمين)';
$string['footercolumn4headingdesc'] = 'يتعلق هذا القسم بالجزء السفلي (العمود 4) من الصفحة الرئيسية الخاصة بك.';
$string['footercolumn4title'] = 'عنوان العمود الرابع للتذييل';
$string['footercolumn4titledesc'] = 'إضافة عنوان لهذا العمود.';
$string['footercolumn4customhtml'] = 'HTML مخصص';
$string['footercolumn4customhtmldesc'] = 'يمكنك تخصيص HTML لهذا العمود باستخدام المربع المخصص أعلاه.';
$string['footerbottomheading'] = 'إعدادات أسفل النافذة';
$string['footerbottomdesc'] = 'هنا يمكنك تحديد رابطك الخاص الذي ترغب في إدخاله في الجزء السفلي من النافذة';
$string['footerbottomtextdesc'] = 'إضافة نص إلى إعدادات أسفل النافذة.';
$string['footercopyrightsshow'] = 'إظهار';
$string['footercopyright'] = 'عرض حقوق الطبع والنشر';
$string['footercopyrights'] = '[site] © [year]. جميع الحقوق محفوظة.';
$string['footercopyrightsdesc'] = 'إضافة محتوى حقوق الطبع والنشر في أسفل الصفحة.';
$string['footercopyrightstags'] = 'العلامات:<br>[site] - اسم الموقع<br>[year] - السنة الحالية';
$string['footerbottomlink'] = 'رابط أسفل النافذة الأيسر';
$string['footerbottomlinkdesc'] = 'أدخل الرابط لقسم أسفل النافذة الأيسر. على سبيل المثال: http://www.yourcompany.com';
$string['footerbottomtext'] = 'نص أسفل النافذة الأيسر';
$string['footerbottomlink'] = 'رابط أسفل النافذة الأيسر';
$string['copyrighttextarea'] = 'محتوى حقوق الطبع والنشر';
$string['footercolumnsize'] = 'عدد الودجات';
$string['one'] = 'واحد';
$string['two'] = 'اثنان';
$string['three'] = 'ثلاثة';
$string['four'] = 'أربعة';
$string['showsocialmediaicon'] = 'إظهار أيقونات وسائل التواصل الاجتماعي';
$string['footercolumntype'] = 'النوع';
$string['footercolumncustommenudesc'] = 'أضف عناصر القائمة الخاصة بك بهذا التنسيق على سبيل المثال <br><pre>[
    {
        "text": "أضف نصك هنا",
        "address": "http://XYZ.abc"
    },
    {
        "text": "أضف نصك هنا",
        "address": "http://XYZ.abc"
    }, ...
]</pre>
<b style="color:red;">ملاحظة:</b> لإضافة محتوى بسهولة إلى التذييل قم بتخصيص منطقة التذييل بمساعدتنا <a href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer" onclick= location.href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#theme_remui_edwiserpersonalizer";location.reload();>المُناسب البصري </a>';
$string['gotop'] = 'العودة للأعلى';

$string['menu'] = 'القائمة';
$string['content'] = 'المحتوى';
$string['footercolumntypedesc'] = 'يمكنك اختيار نوع ودجت التذييل';
$string['socialmediaicondesc'] = 'سيتم عرض أيقونات وسائل التواصل الاجتماعي في هذا القسم';
$string['footercolumncustommmenu'] = 'إضافة عناصر القائمة';
$string['follometext'] = 'تابعني على {$a}';
$string['footercolumndesc'] = 'حدد عدد الودجات في التذييل';
$string['footershowlogo'] = 'إظهار شعار التذييل';
$string['footershowlogodesc'] = 'عرض الشعار في التذييل الثانوي.';

$string['footertermsandconditionsshow'] = 'إظهار الشروط والأحكام';
$string['footertermsandconditions'] = 'رابط الشروط والأحكام';
$string['footertermsandconditionsdesc'] = 'يمكنك إضافة رابط لصفحة الشروط والأحكام.';
$string['footertermsandconditionsshowdesc'] = 'شروط وأحكام التذييل';
$string['footerprivacypolicyshowdesc'] = 'رابط سياسة الخصوصية';

$string['footerprivacypolicyshow'] = 'إظهار سياسة الخصوصية';
$string['footerprivacypolicy'] = 'رابط سياسة الخصوصية';
$string['footerprivacypolicydesc'] = 'يمكنك إضافة رابط لصفحة سياسة الخصوصية.';
$string['termsandconditions'] = 'الشروط والأحكام';
$string['privacypolicy'] = 'سياسة الخصوصية';
$string['typeamessage'] = "اكتب رسالتك هنا";
$string['allcontacts'] = "كل الاتصالات";

// Profile Page.
$string['administrator'] = 'مدير';
$string['contacts'] = 'جهات الاتصال';
$string['blogentries'] = 'مدخلات المدونة';
$string['discussions'] = 'المناقشات';
$string['aboutme'] = 'عني';
$string['courses'] = 'الدورات';
$string['interests'] = 'الاهتمامات';
$string['institution'] = 'القسم والمؤسسة';
$string['location'] = 'الموقع';
$string['description'] = 'الوصف';
$string['editprofile'] = 'تعديل الملف الشخصي';
$string['start_date'] = 'تاريخ البدء';
$string['complete'] = 'اكتمل';
$string['surname'] = 'اسم العائلة';
$string['actioncouldnotbeperformed'] = 'تعذر إجراء العملية!';
$string['enterfirstname'] = 'يرجى إدخال الاسم الأول الخاص بك.';
$string['enterlastname'] = 'الرجاء إدخال اسمك الأخير.';
$string['entervalidphoneno'] = 'أدخل رقم هاتف صالح';
$string['enteremailid'] = 'الرجاء إدخال بريدك الإلكتروني.';
$string['enterproperemailid'] = 'الرجاء إدخال بريد إلكتروني صحيح.';
$string['detailssavedsuccessfully'] = 'تم حفظ التفاصيل بنجاح!';
$string['fullname']  = 'الاسم الكامل';
$string['viewcourselow'] = "عرض دورة";
$string['focusmodesettings'] = 'إعدادات وضع التركيز';
$string['focusmode'] = 'وضع التركيز';
$string['enablefocusmode'] = 'تمكين وضع التركيز';
$string['togglefocusmode'] = "تبديل وضع التركيز";
$string['enablefocusmodedesc'] = 'إذا تم تمكينه، سيظهر زر للتبديل إلى التعلم خاليًا من الانحراف على صفحة الدورة.';
$string['focusmodeenabled'] = 'تم تمكين وضع التركيز';
$string['focusmodedisabled'] = 'تم تعطيل وضع التركيز';
$string['coursedata'] = 'بيانات الدورة';
$string['prev'] = 'السابق';
$string['next'] = 'التالي';
$string['enablecoursestats'] = 'تمكين إحصاءات الدورة';
$string['enablecoursestatsdesc'] = 'إذا تم تمكينه، سيتمكن المسؤول والمدير والمعلم من رؤية إحصاءات المستخدم المتعلقة بالدورة المسجلة على صفحة الدورة الفردية.';

// Course Stats.
$string['notenrolledanycourse'] = 'لم يتم تسجيل في أي دورة.';
$string['enrolledusers'] = 'الطلاب المسجلين';
$string['studentcompleted'] = 'الطلاب المكتملين';
$string['inprogress'] = 'قيد التقدم';
$string['yettostart'] = 'لم يبدأ بعد';
$string['completepercent'] = '{$a}% من الدورة تمت';
$string['seeallmycourses'] = "<span class='d-none d-lg-block'>رؤية جميع دوراتي</span>&nbsp;<span>قيد التقدم</span>";
$string['noactivity'] = 'لا توجد أنشطة في الدورة';
$string['activitydata'] = '{$a->complete} من {$a->total} الأنشطة المكتملة';
// Login Page Strings.
$string['loginsettingpic'] = 'تحميل صورة الخلفية';
$string['loginsettingpicdesc'] = 'تحميل صورة كخلفية لنموذج تسجيل الدخول.';
$string['loginpagelayout'] = 'تخطيط نموذج تسجيل الدخول';
$string['loginpagelayoutdesc'] = 'اختيار تصميم صفحة تسجيل الدخول.';
$string['logincenter'] = 'الوسط';
$string['loginleft'] = 'الجانب الأيسر';
$string['loginright'] = 'الجانب الأيمن';
$string['brandlogopos'] = "عرض الشعار على صفحة تسجيل الدخول";
$string['brandlogoposdesc'] = "إذا تم تمكينه، سيتم عرض شعار العلامة التجارية على صفحة تسجيل الدخول.";
$string['hiddenlogo'] = "تعطيل";
$string['sidebarregionlogo'] = 'على بطاقة تسجيل الدخول';
$string['maincontentregionlogo'] = 'في المنطقة المركزية';
$string['loginpanellogo'] = 'شعار الرأس (صفحة تسجيل الدخول)';
$string['loginpanellogodesc'] = 'يعتمد على <strong>اختيار إعداد شعار الموقع</strong>';
$string['signuptextcolor'] = 'لون وصف الموقع';
$string['signuptextcolordesc'] = 'اختر لون النص لوصف الموقع.';
$string['brandlogotext'] = "وصف الموقع";
$string['loginpagesitedescription'] = 'وصف موقع صفحة تسجيل الدخول';
$string['brandlogotextdesc'] = "إضافة نص لوصف الموقع الذي سيظهر على صفحة تسجيل الدخول والتسجيل. اترك هذا فارغًا إذا لم ترغب في وضع أي وصف.";
$string['createnewaccount'] = 'إنشاء حساب جديد';
$string['welcometobrand'] = 'مرحبًا، مرحبًا بك في {$a}';
$string['entertologin'] = "أدخل تفاصيلك لتسجيل الدخول إلى حسابك";
$string['forgotaccount'] = 'هل نسيت كلمة المرور؟';
$string['potentialidps'] = 'أو قم بتسجيل الدخول باستخدام حسابك';
$string['firsttime'] = 'أول مرة تستخدم هذا الموقع';

// Signup Page.
$string['createnewaccount'] = 'إنشاء حساب جديد';

// Course Page Settings.
$string['coursesettings'] = "صفحة الدورة";
$string['enrolpagesettings'] = "إعدادات صفحة التسجيل";
$string['enrolpagesettingsdesc'] = "إدارة محتوى صفحة التسجيل هنا.";
$string['coursearchivepagesettings'] = 'إعدادات صفحة أرشيف الدورة';
$string['coursearchivepagesettingsdesc'] = 'إدارة تخطيط ومحتوى صفحة أرشيف الدورة.';
$string['courseperpage'] = 'الدورات لكل صفحة';
$string['courseperpagedesc'] = "<strong>عرض 'الشبكة' للدورات:</strong> عن طريق اختيار عدد بطاقات الدورات في الإعدادات أعلاه، ستقوم صفحة أرشيف الدورات بضبط العرض تلقائيًا، وتنظيم البطاقات في صفوف تنشأ ديناميكيًا.<br>
<strong style='display: inline-block;margin-top: 8px;'>عرض 'القائمة والملخص' للدورات:</strong> سيتم عرض الدورات وفقًا للاختيار الذي تم إجراؤه في الإعدا";
$string['none'] = 'لا شيء';
$string['fade'] = 'تلاشي';
$string['slide-top'] = 'انزلاق للأعلى';
$string['slide-bottom'] = 'انزلاق للأسفل';
$string['slide-right'] = 'انزلاق لليمين';
$string['scale-up'] = 'تكبير';
$string['scale-down'] = 'تصغير';
$string['courseanimation'] = 'تحريك بطاقة الدورة';
$string['courseanimationdesc'] = 'اختيار تحريك بطاقة الدورة للظهور على صفحة أرشيف الدورة.';

$string['currency'] = 'USD';
$string['currency_symbol'] = '$';
$string['enrolment_payment'] = 'عرض تسمية \'مجاناً\' على الدورة بتكلفة التسجيل "0"';
$string['enrolment_payment_desc'] = 'يحدد هذا الإعداد ما إذا كان يتم عرض تسمية "مجاناً" للدورات بدون رسوم تسجيل. إذا تم تعيينه إلى "لا"، فلن يظهر اللافتة على صفحة التسجيل.';
$string['allrequirepayment'] = 'لا';
$string['somearefree'] = 'نعم';
$string['allarefree'] = 'جميع الدورات مجانية';

$string['showcoursepricing'] = 'عرض تسعير الدورة';
$string['showcoursepricingdesc'] = 'تمكين هذا الإعداد لعرض قسم التسعير على صفحة التسجيل.';
$string['fullwidthcourseheader'] = 'ترويسة الدورة بعرض كامل';
$string['fullwidthcourseheaderdesc'] = 'تمكين هذا الإعداد لجعل ترويسة الدورة بعرض كامل.';

$string['price'] = 'السعر';
$string['course_free'] = 'مجانًا';
$string['enrolnow'] = 'سجل الآن في {$a}';
$string['buyand'] = 'شراء & ';
$string['notags'] = 'لا توجد علامات.';
$string['tags'] = 'العلامات';

$string['enrolment_layout'] = 'تخطيط صفحة التسجيل';
$string['enrolment_layout_desc'] = 'تمكين تخطيط Edwiser لتصميم صفحة التسجيل المحسن والجديد.';
$string['disable'] = 'تعطيل';
$string['defaultlayout'] = 'التخطيط الافتراضي لـ Moodle';
$string['enable_layout1'] = 'تخطيط Edwiser';

$string['webpage'] = "صفحة الويب";
$string['categorypagelayout'] = 'تخطيط صفحة أرشيف الدورة';
$string['categorypagelayoutdesc'] = 'اختيار بين تخطيطات صفحة أرشيف الدورة.';
$string['edwiserlayout'] = 'تخطيط Edwiser';
$string['categoryfilter'] = 'فلترة الفئة';

$string['skill0'] = 'غير معنونة';
$string['skill1'] = 'مبتدئ';
$string['skill2'] = 'متوسط';
$string['skill3'] = 'متقدم';

$string['lastupdatedon'] = 'آخر تحديث في ';

$string['courseoverview'] = "نظرة عامة على الدورة";
$string['coursecontent'] = "محتوى الدورة";
$string['instructors'] = "المدربون";
$string['reviews'] = "المراجعات";
$string['curatedby'] = 'المدربون';
$string["studentsenrolled"] = 'الطلاب المسجلين';
$string['lesson'] = 'الدرس';
$string['category'] = 'الفئة';
$string['review'] = 'المراجعة';
$string['length'] = 'المدة';
$string['lecture'] = 'المحاضرة';
$string['startdate'] = 'تاريخ البدء';
$string['skilllevel'] = 'مستوى المهارة';
$string['language'] = 'اللغة';
$string['certificate'] = 'الشهادة';
$string['students'] = 'الطلاب';
$string['courses'] = 'الدورات';

// Course archive.
$string['cachedef_courses'] = 'ذاكرة التخزين المؤقت للدورات';
$string['cachedef_guestcourses'] = 'ذاكرة التخزين المؤقت للدورات الضيف';
$string['cachedef_updates'] = 'ذاكرة التخزين المؤقت للتحديثات';
$string['mycourses'] = "دوراتي";
$string['allcategories'] = 'كل الفئات';
$string['categorysort'] = 'فرز الفئات';
$string['sortdefault'] = 'فرز (بدون)';
$string['sortascending'] = 'من أ إلى ي';
$string['sortdescending'] = 'من ي إلى أ';

// Frontpage Old String.
// Home Page Settings.
$string['homepagesettings'] = 'الصفحة الرئيسية';
$string['frontpagedesign'] = 'تصميم الصفحة الرئيسية';
$string['frontpagedesigndesc'] = 'تمكين مُنشئ الصفحة الرئيسية القديم أو بُناء الصفحة الرئيسية Edwiser RemUI';
$string['frontpagechooser'] = 'اختيار تصميم الصفحة الرئيسية';
$string['frontpagechooserdesc'] = 'اختر تصميم الصفحة الرئيسية الخاص بك.';
$string['frontpagedesignold'] = 'مُنشئ الصفحة الرئيسية القديم';
$string['frontpagedesignolddesc'] = 'لوحة تحكم افتراضية مثل السابق.';
$string['frontpagedesignnew'] = 'تصميم جديد';
$string['frontpagedesignnewdesc'] = 'تصميم جديد ومنعش مع عدة أقسام. يمكنك تكوين الأقسام بشكل فردي على الصفحة الرئيسية.';
$string['newhomepagedescription'] = 'انقر على \'الصفحة الرئيسية\' من شريط التنقل للانتقال إلى \'مُنشئ الصفحة الرئيسية\' وإنشاء صفحة رئيسية خاصة بك
<br><div><b style="color:red;">ملاحظة:</b> سيتم إيقاف مُنشئ الصفحة الرئيسية قريبًا</div>
<br><div><a id="homepage-edwpagebuilder-migratorbtn" href="#" class="btn btn-primary ">نقل الصفحة الرئيسية إلى مُنشئ الصفحات</a></div>نقل الصفحة الرئيسية إلى مُنشئ الصفحات';
$string['frontpageloader'] = 'تحميل صورة الرئيسية';
$string['frontpageloaderdesc'] = 'يحل هذا الصورة الافتراضية بصورتك';
$string['frontpageimagecontent'] = 'محتوى الرأس';
$string['frontpageimagecontentdesc'] = ' يتعلق هذا القسم بالجزء العلوي من الصفحة الرئيسية.';
$string['frontpageimagecontentstyle'] = 'نمط';
$string['frontpageimagecontentstyledesc'] = 'يمكنك اختيار بين ثابت ومنزلق.';
$string['staticcontent'] = 'ثابت';
$string['slidercontent'] = 'منزلق';
$string['addtext'] = 'إضافة نص';
$string['defaultaddtext'] = 'التعليم هو طريق مجرب للتقدم.';
$string['addtextdesc'] = 'هنا يمكنك إضافة النص الذي سيتم عرضه على الصفحة الرئيسية، يفضل استخدام HTML.';
$string['uploadimage'] = 'تحميل صورة';
$string['uploadimagedesc'] = 'يمكنك تحميل صورة كمحتوى للشريحة';
$string['video'] = 'رمز مضمن لمقطع الفيديو';
$string['videodesc'] = ' هنا، يمكنك إدخال رمز مضمن لمقطع الفيديو الذي سيتم تضمينه.';
$string['contenttype'] = 'اختر نوع المحتوى';
$string['contentdesc'] = 'يمكنك اختيار صورة أو إعطاء رابط فيديو.';
$string['imageorvideo'] = 'صورة / فيديو';
$string['image'] = 'صورة';
$string['videourl'] = 'رابط الفيديو';
$string['slideinterval'] = 'فاصل الشرائح';
$string['slideintervalplaceholder'] = 'عدد صحيح إيجابي بالميللي ثانية.';
$string['slideintervaldesc'] = 'يمكنك تعيين وقت التحويل بين الشرائح. إذا كان هناك شريحة واحدة، فلن يكون لهذا الخيار تأثير. إذا كان الفاصل غير صحيح (فارغ أو 0 أو أقل من 0)، سيكون الفاصل الزمني الافتراضي 5000 ميللي ثانية.';
$string['slidercount'] = 'عدد الشرائح';
$string['slidercountdesc'] = '';
$string['one'] = '1';
$string['two'] = '2';
$string['three'] = '3';
$string['four'] = '4';
$string['five'] = '5';
$string['six'] = '6';
$string['eight'] = '8';
$string['nine'] = '9';
$string['twelve'] = '12';
$string['slideimage'] = 'تحميل الصور للشرائح';
$string['slideimagedesc'] = 'يمكنك تحميل صورة كمحتوى لهذه الشريحة.';
$string['sliderurl'] = 'إضافة رابط لزر الشريحة';
$string['slidertext'] = 'إضافة نص للشريحة';
$string['defaultslidertext'] = '';
$string['slidertextdesc'] = 'يمكنك إدخال محتوى النص لهذه الشريحة، يفضل استخدام HTML.';
$string['sliderbuttontext'] = 'إضافة نص الزر على الشريحة';
$string['sliderbuttontextdesc'] = 'يمكنك إضافة نص إلى الزر على هذه الشريحة.';
$string['sliderurldesc'] = 'يمكنك إدخال رابط الصفحة التي سيتم توجيه المستخدم إليها عند النقر فوق الزر.';
$string['sliderautoplay'] = 'تعيين تلقائي للشرائح';
$string['sliderautoplaydesc'] = 'حدد \'نعم\' إذا كنت ترغب في التحول التلقائي في عرض الشرائح.';
$string['true'] = 'نعم';
$string['false'] = 'لا';
$string['frontpageblocks'] = 'محتوى الجسم';
$string['frontpageblocksdesc'] = 'يمكنك إدخال عنوان لجسم موقعك';
$string['frontpageblockdisplay'] = 'قسم من حولنا';
$string['frontpageblockdisplaydesc'] = 'يمكنك إظهار أو إخفاء قسم "من حولنا"، كما يمكنك إظهار قسم "من حولنا" في تنسيق الشبكة';
$string['donotshowaboutus'] = 'عدم الإظهار';
$string['showaboutusinrow'] = 'إظهار القسم في صف واحد';
$string['showaboutusingridblock'] = 'إظهار القسم في كتلة الشبكة';
// About Us.
$string['frontpageaboutus'] = 'من نحن على الصفحة الرئيسية';
$string['frontpageaboutusdesc'] = 'هذا القسم مخصص لمن نحن على الصفحة الرئيسية';
$string['frontpageaboutustitledesc'] = 'إضافة عنوان لقسم من نحن';
$string['frontpageaboutusbody'] = 'وصف لقسم من نحن';
$string['frontpageaboutusbodydesc'] = 'وصف موجز حول هذا القسم';
$string['enablesectionbutton'] = 'تمكين أزرار على الأقسام';
$string['enablesectionbuttondesc'] = 'تمكين الأزرار في أقسام النص.';
$string['sectionbuttontextdesc'] = 'أدخل نص الزر لهذا القسم.';
$string['sectionbuttonlinkdesc'] = 'أدخل رابط URL لهذا القسم.';
$string['frontpageblocksectiondesc'] = 'إضافة عنوان لهذا القسم.';

// Block section 1.
$string['frontpageblocksection1'] = 'عنوان النص للقسم الأول';
$string['frontpageblockdescriptionsection1'] = 'وصف النص للقسم الأول';
$string['frontpageblockiconsection1'] = 'أيقونة Font-Awesome للقسم الأول';
$string['sectionbuttontext1'] = 'نص الزر للقسم الأول';
$string['sectionbuttonlink1'] = 'رابط URL للقسم الأول';

// Block section 2.
$string['frontpageblocksection2'] = 'عنوان النص للقسم الثاني';
$string['frontpageblockdescriptionsection2'] = 'وصف النص للقسم الثاني';
$string['frontpageblockiconsection2'] = 'أيقونة Font-Awesome للقسم الثاني';
$string['sectionbuttontext2'] = 'نص الزر للقسم الثاني';
$string['sectionbuttonlink2'] = 'رابط URL للقسم الثاني';

// Block section 3.
$string['frontpageblocksection3'] = 'عنوان النص للقسم الثالث';
$string['frontpageblockdescriptionsection3'] = 'وصف النص للقسم الثالث';
$string['frontpageblockiconsection3'] = 'أيقونة Font-Awesome للقسم الثالث';
$string['sectionbuttontext3'] = 'نص الزر للقسم الثالث';
$string['sectionbuttonlink3'] = 'رابط URL للقسم الثالث';

// Block section 4.
$string['frontpageblocksection4'] = 'عنوان النص للقسم الرابع';
$string['frontpageblockdescriptionsection4'] = 'وصف النص للقسم الرابع';
$string['frontpageblockiconsection4'] = 'أيقونة Font-Awesome للقسم الرابع';
$string['sectionbuttontext4'] = 'نص الزر للقسم الرابع';
$string['sectionbuttonlink4'] = 'رابط URL للقسم الرابع';
$string['defaultdescriptionsection'] = 'استغلال تكنولوجيات في الوقت المناسب عبر سيناريوهات الشركات بشكل شامل.';
$string['frontpagetestimonial'] = 'شهادة على الصفحة الرئيسية';
$string['frontpagetestimonialdesc'] = 'قسم الشهادة على الصفحة الرئيسية';
$string['enablefrontpageaboutus'] = 'تمكين قسم الشهادة';
$string['enablefrontpageaboutusdesc'] = 'تمكين قسم الشهادة على الصفحة الرئيسية.';
$string['frontpageaboutusheading'] = 'عنوان الشهادة';
$string['frontpageaboutusheadingdesc'] = 'عنوان النص الافتراضي للقسم';
$string['frontpageaboutustext'] = 'نص الشهادة';
$string['frontpageaboutustextdesc'] = 'أدخل نص الشهادة للصفحة الرئيسية.';
$string['frontpageaboutusdefault'] = '<p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
              Ut enim ad minim veniam.</p>';
$string['testimonialcount'] = 'عدد الشهادات';
$string['testimonialcountdesc'] = 'عدد الشهادات لعرضها.';
$string['testimonialimage'] = 'صورة الشهادة';
$string['testimonialimagedesc'] = 'صورة الشخص لعرضها مع الشهادة';
$string['testimonialname'] = 'اسم الشخص';
$string['testimonialnamedesc'] = 'اسم الشخص';
$string['testimonialdesignation'] = 'مسمى الشخص';
$string['testimonialdesignationdesc'] = 'مسمى الشخص.';
$string['testimonialtext'] = 'شهادة الشخص';
$string['testimonialtextdesc'] = 'ما يقوله الشخص';
$string['frontpageblockimage'] = 'رفع الصورة';
$string['frontpageblockimagedesc'] = 'يمكنك رفع صورة كمحتوى لهذا القسم.';
$string['frontpageblockiconsectiondesc'] = 'يمكنك اختيار أي أيقونة من <a href="https://fontawesome.com/v4.7.0/cheatsheet/" target="_new">هنا</a>. فقط أدخل النص بعد "fa-".';
$string['frontpageblockdescriptionsectiondesc'] = 'وصف موجز حول العنوان.';

// Course.
$string['graderreport'] = 'تقرير المصحح';
$string['enroluser'] = 'تسجيل المستخدمين';
$string['activityeport'] = 'تقرير النشاط';
$string['editcourse'] = 'تحرير الدورة';
$string['imageforcourse'] = 'صورة للدورة';
// Next Previous Activity.
$string['activityprev'] = 'النشاط السابق';
$string['activitynext'] = 'النشاط التالي';
$string['activitynextpreviousbutton'] = 'تمكين زر النشاط التالي والسابق';
$string['activitynextpreviousbuttondesc'] = 'عند التمكين، سيظهر زر النشاط التالي والسابق على صفحة النشاط الواحد للتبديل بين الأنشطة';
$string['disablenextprevious'] = 'تعطيل';
$string['enablenextprevious'] = 'تمكين';
$string['enablenextpreviouswithname'] = 'تمكين مع اسم النشاط';

// Importer.
$string['importer'] = 'المستورد';
$string['importer-missing'] = 'المكون الإضافي Edwiser Site Importer مفقود. يرجى زيارة <a href="https://edwiser.org">Edwiser</a> لتنزيل هذا المكون الإضافي.';

// Information center.
$string['informationcenter'] = 'مركز المعلومات';
$string['licensenotactive'] = '<strong>تنبيه!</strong> الترخيص غير مفعل , الرجاء <strong>تفعيل</strong> الترخيص في إعدادات RemUI.';
$string['licensenotactiveadmin'] = '<strong>تنبيه!</strong> الترخيص غير مفعل , الرجاء <strong>تفعيل</strong> الترخيص <a class="text-primary" href="'.$CFG->wwwroot.'/admin/settings.php?section=themesettingremui#informationcenter" >هنا</a>.';
$string['activatelicense'] = 'تفعيل الترخيص';
$string['deactivatelicense'] = 'إلغاء تفعيل الترخيص';
$string['renewlicense'] = 'تجديد الترخيص';
$string['deactivated'] = 'معطل';
$string['active'] = 'نشط';
$string['notactive'] = 'غير نشط';
$string['expired'] = 'منتهي الصلاحية';
$string['licensekey'] = 'مفتاح الترخيص';
$string['licensestatus'] = 'حالة الترخيص';
$string['no_activations_left'] = 'تجاوز الحد المسموح به';
$string['activationfailed'] = 'فشل تفعيل مفتاح الترخيص. يرجى المحاولة مرة أخرى لاحقًا.';
$string['noresponsereceived'] = 'لم يتم استلام رد من الخادم. يرجى المحاولة مرة أخرى لاحقًا.';
$string['licensekeydeactivated'] = 'تم إلغاء تفعيل مفتاح الترخيص.';
$string['siteinactive'] = 'الموقع غير نشط (اضغط على تفعيل الترخيص لتفعيل المكون الإضافي).';
$string['entervalidlicensekey'] = 'يرجى إدخال مفتاح ترخيص صالح.';
$string['nolicenselimitleft'] = 'تم الوصول إلى الحد الأقصى للتنشيطات، لا توجد تنشيطات متبقية.';
$string['licensekeyisdisabled'] = 'مفتاح الترخيص الخاص بك معطل.';
$string['licensekeyhasexpired'] = "انتهت صلاحية مفتاح الترخيص الخاص بك. يرجى تجديده.";
$string['licensekeyactivated'] = "تم تفعيل مفتاح الترخيص الخاص بك.";
$string['entervalidlicensekey'] = "يرجى إدخال مفتاح ترخيص صحيح.";
$string['edwiserremuilicenseactivation'] = 'تفعيل ترخيص Edwiser RemUI';
$string['enterlicensekey'] = "أدخل مفتاح الترخيص...";
$string['invalid'] = "غير صالح";

$string['courseheaderdesign'] = 'تصميم رأس صفحة الدورة';
$string['courseheaderdesigndesc'] = 'اختر تصميم رأس صفحة الدورة';
$string['default'] = 'افتراضي';
$string['headerdesign'] = 'تصميم الرأس {$a}';
$string['sidebarcoursemenuheading'] = "قائمة الدورة";

// Notification.
$string['inproductnotification'] = "تحديث تفضيلات المستخدم (إشعار في المنتج) - RemUI";

$string["noti_enrolandcompletion"] = 'ساهمت تصاميم Edwiser RemUI المعاصرة والمهنية بشكل كبير في زيادة إشراك المتعلمين العام بـ <b>{$a->enrolment} تسجيل دورة جديدة و {$a->completion} اكتمال دورة</b> هذا الشهر';

$string["noti_completion"] = 'ساهم Edwiser RemUI في تحسين مستويات الارتباط لديك: لديك <b>{$a->completion} اكتمال دورة</b> هذا الشهر';

$string["noti_enrol"] = 'تبدو تصاميم LMS الخاصة بك رائعة مع Edwiser RemUI: لديك <b>{$a->enrolment} تسجيل دورة جديدة</b> في بوابتك هذا الشهر';

$string["coolthankx"] = "رائع، شكرًا!";

$string['gridview'] = 'عرض الشبكة';
$string['listview'] = 'عرض القائمة';
$string['summaryview'] = 'عرض ملخص';

$string['side-top'] = "محتوى الصندوق الأعلى";
$string['content'] = "الافتراضي Moodle";
$string['side-bottom'] = "محتوى الصندوق السفلي";
$string['side-pre'] = "شريط الأدوات الجانبي الأيمن";

$string['sitenamecolor'] = "لون اسم الموقع أو الرمز.";
$string['sitenamecolordesc'] = "لون نص اسم الموقع والرمز، والذي سيتم تطبيقه أيضًا على صفحة تسجيل الدخول.";

$string['coursesenrolled'] = "الدورات المسجلة";
$string['coursescompleted'] = "الدورات المكتملة";
$string['activitiescompleted'] = "الأنشطة المكتملة";
$string['activitiesdue'] = "الأنشطة المستحقة";

// Customizer Strings
$string['customizer-migrate-notice'] = 'تم نقل إعدادات الألوان إلى الجهاز المُخصص للمُنظم البصري. يرجى النقر على الزر أدناه لفتح المُنظم البصري.';
$string['customizer-close-heading'] = 'إغلاق المُنظم البصري';
$string['customizer-close-description'] = 'سيتم تجاهل التغييرات غير المحفوظة. هل ترغب في المتابعة؟';
$string['reset'] = 'إعادة تعيين';
$string['resetall'] = 'إعادة تعيين الكل';
$string['reset-settings'] = 'إعادة تعيين جميع إعدادات المُنظم البصري';
$string['reset-settings-description'] = '
<div>سيتم استعادة إعدادات المُنظم البصري إلى الإعدادات الافتراضية. هل ترغب في المتابعة؟</div>
<div class="mt-3"><strong>إعادة تعيين الكل:</strong> إعادة تعيين كافة الإعدادات.</div>
<div class="mt-3"><strong>إعادة تعيين:</strong> سيتم إعادة تعيين الإعدادات باستثناء الإعدادات التالية.</div>
';
$string['link'] = 'رابط';
$string['customizer'] = 'المُنظم البصري';
$string['error'] = 'خطأ';
$string['resetdesc'] = 'إعادة ضبط الإعداد إلى آخر حفظ أو الافتراضي عندما لا يتم حفظ شيء';
$string['noaccessright'] = 'عذرًا! ليس لديك حقوق لاستخدام هذه الصفحة';

$string['font-family'] = 'نوع الخط';
$string['font-family_help'] = 'تعيين نوع الخط لـ {$a}';

$string['button-font-family'] = 'نوع الخط';
$string['button-font-family_help'] = 'تعيين نوع الخط لنص الزر';

$string['font-size'] = 'حجم الخط';
$string['font-size_help'] = 'تعيين حجم الخط لـ {$a}';
$string['font-weight'] = 'وزن الخط';
$string['font-weight_help'] = 'تعيين وزن الخط لـ {$a}. خاصية وزن الخط تعيد كيفية عرض النص سميكا أو رفيعا.';
$string['line-height'] = 'ارتفاع السطر';
$string['line-height_help'] = 'تعيين ارتفاع السطر لـ {$a}';
$string['global'] = 'عالمي';
$string['global_help'] = 'يمكنك إدارة الإعدادات العالمية مثل اللون، الخط، العنوان، الأزرار إلخ.';
$string['site'] = 'الموقع';
$string['text-color'] = 'لون النص';
$string['welcome-text-color'] = 'لون نص الترحيب';
$string['text-hover-color'] = 'لون تحويل النص';
$string['text-color_help'] = 'تعيين لون النص لـ {$a}';
$string['content-color'] = 'لون المحتوى';
$string['icon-color'] = 'لون الأيقونة';
$string['icon-hover-color'] = 'لون تحويل الأيقونة';
$string['icon-color_help'] = 'تعيين لون الأيقونة لـ {$a}';
$string['link-color'] = 'لون الرابط';
$string['link-color_help'] = 'تعيين لون الرابط لـ {$a}';
$string['link-hover-color'] = 'لون تحويل الرابط';
$string['link-hover-color_help'] = 'تعيين لون تحويل الرابط لـ {$a}';
$string['typography'] = 'الطباعة';
$string['inherit'] = 'الوراثة';
$string["weight-100"] = '100';
$string["weight-200"] = '200';
$string["weight-300"] = '300';
$string["weight-400"] = '400';
$string["weight-500"] = '500';
$string["weight-600"] = '600';
$string["weight-700"] = '700';
$string["weight-800"] = '800';
$string["weight-900"] = '900';
$string['text-transform'] = 'تحويل النص';
$string['text-transform_help'] = 'خاصية تحويل النص تسيطر على تكبير النص. تحويل النص لـ {$a}.';

$string['button-text-transform'] = 'تحويل النص';
$string['button-text-transform_help'] = 'خاصية تحويل النص تسيطر على تكبير النص. تحويل النص لنص الزر';
$string["default"] = 'الافتراضي';
$string["none"] = 'لا شيء';
$string["capitalize"] = 'بداية الجملة';
$string["uppercase"] = 'أحرف كبيرة';
$string["lowercase"] = 'أحرف صغيرة';
$string['background-color'] = 'لون الخلفية';
$string['background-hover-color'] = 'لون تحويل الخلفية';
$string['background-color_help'] = 'تعيين لون الخلفية لـ {$a}';
$string['background-hover-color'] = 'لون تحويل الخلفية';
$string['background-hover-color_help'] = 'تعيين لون تحويل الخلفية لـ {$a}';
$string['color'] = 'اللون';
$string['customizing'] = 'التخصيص';
$string['savesuccess'] = 'حفظ بنجاح.';
$string['mobile'] = 'الجوال';
$string['tablet'] = 'الجهاز اللوحي';
$string['hide-customizer'] = 'إخفاء المُنظم البصري';
$string['customcss_help'] = 'يمكنك إضافة CSS مخصص. سيتم تطبيق هذا على جميع الصفحات من موقعك.';

// Customizer Global body.
$string['body'] = 'الجسم';
$string['body-font-family_desc'] = 'تعيين نوع الخط للموقع بأكمله. ملاحظة: إذا تم تعيينه إلى القياسي، سيتم تطبيق الخط من إعدادات RemUI.';
$string['body-font-size_desc'] = 'تعيين حجم الخط الأساسي للموقع بأكمله.';
$string['body-fontweight_desc'] = 'تعيين وزن الخط للموقع بأكمله.';
$string['body-text-transform_desc'] = 'تعيين تحويل النص للموقع بأكمله.';
$string['body-lineheight_desc'] = 'تعيين ارتفاع السطر للموقع بأكمله.';
$string['faviconurl_help'] = 'عنوان URL للرمز المفضل';

// Customizer Global heading.
$string['heading'] = 'العنوان';
$string['use-custom-color'] = 'استخدام لون مخصص';
$string['use-custom-color_help'] = 'استخدام لون مخصص لـ {$a}';
$string['typography-heading-all-heading'] = 'العناوين (H1 - H6)';
$string['typography-heading-h1-heading'] = 'العنوان 1';
$string['typography-heading-h2-heading'] = 'العنوان 2';
$string['typography-heading-h3-heading'] = 'العنوان 3';
$string['typography-heading-h4-heading'] = 'العنوان 4';
$string['typography-heading-h5-heading'] = 'العنوان 5';
$string['typography-heading-h6-heading'] = 'العنوان 6';

// Customizer Colors.
$string['primary-color'] = 'اللون الأساسي';
$string['primary-color_help'] = 'تطبيق لون العلامة التجارية الأساسي على الموقع بأكمله. سيتم تطبيق هذا اللون على الأزرار، وروابط النص، عند التحويل وللعناصر النشطة في قائمة رأس الصفحة، عند التحويل وللأيقونات
    <br><b>ملاحظة:</b> لن يؤدي تغيير اللون الأساسي إلى تغيير ألوان الأزرار إذا تم تغيير ألوان الأزرار من إعداداتها الفردية (<b>العام > الأزرار > إعدادات لون الزر</b>). يمكنك إعادة ضبط ألوان الأزرار من إعداداتها الفردية لتغيير الألوان بشكل عام.';

$string['secondary-color'] = 'لون الترقية';
$string['secondary-color_help'] = 'تطبيق لون الترقية على الموقع بأكمله. سيتم تطبيق هذا اللون على الأيقونات في كتلة الإحصائيات على صفحة لوحة القيادة، والعلامات على بطاقات الدورات، وبنرات رأس الدورة.';

$string['page-background'] = 'خلفية الصفحة';
$string['page-background_help'] = 'تعيين خلفية مخصصة لمنطقة محتوى الصفحة. يمكنك اختيار اللون أو التدرج أو الصورة. زاوية التدرج هي 100 درجة.';

$string['page-background-color'] = 'لون خلفية الصفحة';
$string['page-background-color_help'] = 'تعيين لون الخلفية لمنطقة محتوى الصفحة.';

$string['page-background-image'] = 'صورة خلفية الصفحة';
$string['page-background-image_help'] = 'تعيين صورة كخلفية لمنطقة محتوى الصفحة.';

$string['gradient'] = 'تدرج';
$string['gradient-color1'] = 'لون التدرج 1';
$string['gradient-color1_help'] = 'تعيين اللون الأول للتدرج';
$string['gradient-color2'] = 'لون التدرج 2';
$string['gradient-color2_help'] = 'تعيين اللون الثاني للتدرج';
$string['gradient-color-angle'] = 'زاوية التدرج';
$string['gradient-color-angle_help'] = 'تعيين زاوية الألوان التدرجية';

$string['page-background-imageattachment'] = 'تعليق صورة الخلفية';
$string['page-background-imageattachment_help'] = 'تعيين خاصية تعليق الصورة الخلفية.';

$string['image'] = 'صورة';
$string['additional-css'] = 'CSS إضافي';
$string['left-sidebar'] = 'الشريط الجانبي الأيسر';
$string['main-sidebar'] = 'الشريط الجانبي الرئيسي';
$string['sidebar-links'] = 'روابط الشريط الجانبي';
$string['secondary-sidebar'] = 'الشريط الجانبي الثانوي';
$string['header'] = 'رأس الصفحة';
$string['headertypography'] = 'طباعة رأس الصفحة';
$string['headercolors'] = 'ألوان رأس الصفحة';
$string['menu'] = 'القائمة';
$string['site-identity'] = 'هوية الموقع';
$string['primary-header'] = 'الرأس الرئيسي';
$string['color'] = 'اللون';

// Customizer Buttons.
$string['buttons'] = 'الأزرار';
$string['border'] = 'الحدود';
$string['border-width'] = 'عرض الحدود';
$string['border-width_help'] = 'تعيين عرض الحدود لـ {$a}';
$string['border-color'] = 'لون الحدود';
$string['border-color_help'] = 'تعيين لون الحدود لـ {$a}';
$string['border-hover-color'] = 'لون تحويل الحدود';
$string['border-hover-color_help'] = 'تعيين لون تحويل الحدود لـ {$a}';
$string['border-radius'] = 'زاوية الحدود';
$string['border-radius_help'] = 'تعيين زاوية الحدود لـ {$a}';
$string['letter-spacing'] = 'تباعد الأحرف';
$string['letter-spacing_help'] = 'تعيين تباعد الأحرف لـ {$a}';
$string['text'] = 'نص';
$string['padding'] = 'الحشو';
$string['padding-top'] = 'الحشو العلوي';
$string['padding-top_help'] = 'تعيين الحشو العلوي لـ {$a}';
$string['padding-right'] = 'الحشو الأيمن';
$string['padding-right_help'] = 'تعيين الحشو الأيمن لـ {$a}';
$string['padding-bottom'] = 'الحشو السفلي';
$string['padding-bottom_help'] = 'تعيين الحشو السفلي لـ {$a}';
$string['padding-left'] = 'الحشو الأيسر';
$string['padding-left_help'] = 'تعيين الحشو الأيسر لـ {$a}';
$string['secondary'] = 'ثانوي';
$string['colors'] = 'الألوان';
$string['commonbuttonsettings'] = 'الإعدادات الشائعة';
$string['buttonsizesettings'] = 'إعدادات حجم الأزرار';
$string['buttonsizesettingshead'] = '{$a}';
$string['commonfontsettings'] = 'الخط';
$string['buttoncolorsettings'] = 'إعدادات لون الأزرار';

// Customizer Header.
$string['header-background-color_help'] = 'تعيين لون خلفية رأس الصفحة. لن يتم تطبيق هذا إذا تم تمكين <strong>تعيين لون خلفية رأس الصفحة نفس لون خلفية الشعار</strong>.';
$string['site-logo'] = 'شعار الموقع';
$string['header-menu'] = 'قائمة رأس الصفحة';
$string['box-shadow-size'] = 'حجم ظل الصندوق';
$string['box-shadow-size_help'] = 'تعيين حجم ظل الصندوق لرأس الموقع';
$string['box-shadow-blur'] = 'ضبابية ظل الصندوق';
$string['box-shadow-blur_help'] = 'تعيين ضبابية ظل الصندوق لرأس الموقع';
$string['box-shadow-color'] = 'لون ظل الصندوق';
$string['box-shadow-color_help'] = 'تعيين لون ظل الصندوق لرأس الموقع';
$string['layout-desktop'] = 'تخطيط سطح المكتب';
$string['layout-desktop_help'] = 'تعيين تخطيط رأس الصفحة لسطح المكتب';
$string['layout-mobile'] = 'تخطيط الجوال';
$string['layout-mobile_help'] = 'تعيين تخطيط رأس الصفحة للجوال';
$string['header-left'] = 'أيقونة يسار القائمة اليمين';
$string['header-right'] = 'أيقونة يمين القائمة اليسار';
$string['header-top'] = 'أيقونة أعلى القائمة السفلية';
$string['hover'] = 'تحويل';
$string['logo'] = 'شعار';
$string['applynavbarcolor'] = 'تعيين لون خلفية رأس الصفحة نفس لون خلفية الشعار';
$string['applynavbarcolor_help'] = 'سيتم تطبيق لون خلفية الشعار على رأس الصفحة بأكملها. تغيير لون خلفية الشعار سيؤدي إلى تغيير لون خلفية رأس الصفحة. يمكنك لا يزال تطبيق لون النص المخصص ولون التحويل على القوائم في رأس الصفحة.';
$string['header-background-color-warning'] = 'لن يتم استخدامه إذا تم تمكين <strong>تعيين لون خلفية رأس الصفحة نفس لون خلفية الشعار</strong>.';
$string['logosize'] = 'نسبة الأبعاد المتوقعة هي 130:33 لعرض اليسار، 140:33 لعرض اليمين.';
$string['logominisize'] = 'نسبة الأبعاد المتوقعة هي 40:33.';
$string['sitenamewithlogo'] = 'اسم الموقع مع الشعار (العرض العلوي فقط)';

// Customizer Sidebar.
$string['link-text'] = 'نص الرابط';
$string['link-text_help'] = 'تعيين لون نص الرابط لـ {$a}';
$string['link-icon'] = 'أيقونة الرابط';
$string['link-icon_help'] = 'تعيين لون أيقونة الرابط لـ {$a}';
$string['active-link-color'] = 'لون الرابط النشط';
$string['active-link-color_help'] = 'تعيين لون مخصص للرابط النشط لـ {$a}';
$string['active-link-background'] = 'خلفية الرابط النشط';
$string['active-link-background_help'] = 'تعيين لون مخصص لخلفية الرابط النشط لـ {$a}';
$string['link-hover-background'] = 'خلفية تحويل الرابط';
$string['link-hover-background_help'] = 'تعيين خلفية تحويل الرابط إلى {$a}';
$string['link-hover-text'] = 'نص تحويل الرابط';
$string['link-hover-text_help'] = 'تعيين لون نص تحويل الرابط لـ {$a}';

// Customizer Footer.
$string['footer'] = 'التذييل';
$string['basic'] = 'تصميم التذييل';
$string['socialall'] = 'روابط وسائل الإعلام الاجتماعية';
$string['advance'] = 'منطقة التذييل الرئيسية';
$string['footercolumn'] = 'عنصر نوع التذييل';
$string['footercolumnwidgetno'] = 'حدد عدد الحاويات';
$string['footercolumndesc'] = 'عدد الحاويات المعروضة في التذييل.';
$string['footercolumntype'] = 'اختر نوعًا';
$string['footercolumnsettings'] = 'إعدادات عمود التذييل';
$string['footercolumntypedesc'] = 'يمكنك اختيار نوع حاوية التذييل.';
$string['footercolumnsocial'] = 'روابط وسائل الإعلام الاجتماعية';
$string['footercolumnsocialdesc'] = 'حدد الروابط المعروضة. اضغط واحتفظ بـ "ctrl" على لوحة المفاتيح لتحديد الروابط المتعددة';
$string['footercolumntitle'] = 'إضافة عنوان';
$string['footercolumntitledesc'] = 'إضافة عنوان لهذا العنصر.';
$string['footercolumncustomhtml'] = 'المحتوى';
$string['footercolumncustomhtmldesc'] = 'يمكنك تخصيص محتوى هذه الحاوية باستخدام المحرر الموضح أدناه.';
$string['both'] = 'كلاهما';
$string['footercolumnsize'] = 'ضبط عرض الحاوية';
$string['footercolumnsizenote'] = 'اسحب الخط العمودي لضبط حجم الحاوية.';
$string['footercolumnsizedesc'] = 'يمكنك تعيين حجم الحاوية الفردية.';
$string['footercolumnmenu'] = 'القائمة';
$string['footercolumnmenureset'] = 'قوائم عمود التذييل';
$string['footercolumnmenudesc'] = 'الرابط القائمة';
$string['footermenu'] = 'القائمة';
$string['footermenudesc'] = 'إضافة قائمة في عنصر نوع التذييل.';
$string['customizermenuadd'] = 'إضافة عنصر القائمة';
$string['customizermenuedit'] = 'تعديل عنصر القائمة';
$string['customizermenumoveup'] = 'نقل عنصر القائمة لأعلى';
$string['customizermenuemovedown'] = 'نقل عنصر القائمة لأسفل';
$string['customizermenuedelete'] = 'حذف عنصر القائمة';
$string['menutext'] = 'نص';
$string['menuaddress'] = 'عنوان';
$string['menuorientation'] = 'اتجاه القائمة';
$string['menuorientationdesc'] = 'تعيين اتجاه القائمة. يمكن أن يكون الاتجاه عموديًا أو أفقيًا.';
$string['menuorientationvertical'] = 'عمودي';
$string['menuorientationhorizontal'] = 'أفقي';
$string['footerfacebook'] = 'Facebook';
$string['footertwitter'] = 'Twitter';
$string['footerlinkedin'] = 'Linkedin';
$string['footergplus'] = 'Google Plus';
$string['footeryoutube'] = 'Youtube';
$string['footerinstagram'] = 'Instagram';
$string['footerpinterest'] = 'Pinterest';
$string['footerquora'] = 'Quora';
$string['footershowlogo'] = 'إظهار الشعار';
$string['footershowlogodesc'] = 'عرض الشعار في التذييل الثانوي.';
$string['footersecondarysocial'] = 'عرض روابط وسائل الإعلام الاجتماعية';
$string['footersecondarysocialdesc'] = 'عرض روابط وسائل الإعلام الاجتماعية في التذييل الثانوي.';
$string['footertermsandconditionsshow'] = 'إظهار الشروط والأحكام';
$string['footertermsandconditions'] = 'رابط الشروط والأحكام';
$string['footertermsandconditionsdesc'] = 'يمكنك إضافة رابط لصفحة الشروط والأحكام.';
$string['footerprivacypolicyshow'] = 'إظهار سياسة الخصوصية';
$string['footerprivacypolicy'] = 'رابط سياسة الخصوصية';
$string['footerprivacypolicydesc'] = 'يمكنك إضافة رابط لصفحة سياسة الخصوصية.';
$string['footercopyrightsshow'] = 'إظهار محتوى حقوق النشر';
$string['footercopyrights'] = 'محتوى حقوق النشر';
$string['footercopyrightsdesc'] = 'إضافة محتوى حقوق النشر في أسفل الصفحة.';
$string['footercopyrightstags'] = 'العلامات:<br>[site]  -  اسم الموقع<br>[year]  -  السنة الحالية';
$string['termsandconditions'] = 'الشروط والأحكام';
$string['privacypolicy'] = 'سياسة الخصوصية';
$string['footerfont'] = 'الخط';
$string['footerbasiccolumntitle'] = 'عنوان العمود';
$string['divider-color'] = 'لون المفصل';
$string['divider-color_help'] = 'تعيين لون المفصل لـ {$a}';
$string['text-hover-color'] = 'لون نص التحويل';
$string['text-hover-color_help'] = 'تعيين لون نص التحويل لـ {$a}';
$string['link-color'] = 'لون الرابط';
$string['link-color_help'] = 'تعيين لون الرابط لـ {$a}';
$string['link-hover-color'] = 'لون تحويل الرابط';
$string['link-hover-color_help'] = 'تعيين لون تحويل الرابط لـ {$a}';
$string['icon-default-color'] = 'لون الرمز';
$string['icon-default-color_help'] = 'لون الرمز لـ {$a}';
$string['icon-hover-color'] = 'لون تحويل الرمز';
$string['icon-hover-color_help'] = 'لون تحويل الرمز لـ {$a}';
$string['footerfontsize_help'] = 'تعيين حجم الخط';
$string['footer-color-heading1'] = 'ألوان التذييل';
$string['footer-color-heading2'] = 'روابط التذييل';
$string['footer-color-heading3'] = 'أيقونات التذييل';

$string['footerfontfamily'] = 'نوع الخط';
$string['footerfontfamily_help'] = 'نوع الخط';
$string['footerfontsize'] = 'حجم الخط';
$string['footerfontsize_help'] = 'حجم الخط للتذييل';
$string['footerfontweight'] = 'وزن الخط';
$string['footerfontweight_help'] = 'وزن الخط للتذييل';
$string['footerfonttext-transform'] = 'تحويل النص';
$string['footerfonttext-transform_help'] = 'تحويل النص للتذييل';
$string['footerfontlineheight'] = 'تباعد الأسطر';
$string['footerfontlineheight_help'] = 'تباعد الأسطر للتذييل';
$string['footerfontltrspace'] = 'تباعد الأحرف';
$string['footerfontltrspace_help'] = 'تعيين تباعد الأحرف لـ {$a}';

$string['footer-columntitle-fontfamily'] = 'نوع الخط';
$string['footer-columntitle-fontfamily_help'] = 'نوع الخط';
$string['footer-columntitle-fontsize'] = 'حجم الخط';
$string['footer-columntitle-fontsize_help'] = 'حجم عنوان عمود التذييل';
$string['footer-columntitle-fontweight'] = 'وزن الخط';
$string['footer-columntitle-fontweight_help'] = 'وزن عنوان عمود التذييل';
$string['footer-columntitle-textransform'] = 'تحويل النص';
$string['footer-columntitle-textransform_help'] = 'تحويل النص لعنوان عمود التذييل';
$string['footer-columntitle-lineheight'] = 'تباعد الأسطر';
$string['footer-columntitle-lineheight_help'] = 'تباعد الأسطر لعنوان عمود التذييل';
$string['footer-columntitle-ltrspace'] = 'تباعد الأحرف';
$string['footer-columntitle-ltrspace_help'] = 'تعيين تباعد الأحرف لعنوان عمود التذييل';
$string['footer-columntitle-color'] = 'اللون';
$string['footer-columntitle-color_help'] = 'اللون لـ {$a}';

$string['openinnewtab'] = 'فتح في علامة تبويب جديدة';
$string['useheaderlogo'] = 'استخدام نفس الشعار من رأس الصفحة';
$string['secondaryfooterlogo'] = 'إضافة شعار جديد';
$string['logosettings'] = 'إعدادات الشعار';
$string['loginformsettings'] = 'إعدادات نموذج تسجيل الدخول';
$string['loginpagesettings'] = 'إعدادات صفحة تسجيل الدخول';
$string['footersecondary'] = 'منطقة أسفل التذييل';
$string['footer-columns'] = 'أعمدة التذييل';

// Customizer login.
$string['login'] = 'تسجيل الدخول';
$string['panel'] = 'لوحة';
$string['page'] = 'صفحة';
$string['loginbackgroundopacity'] = 'شفافية تغطية الخلفية';
$string['loginbackgroundopacity_help'] = 'تطبيق تغطية على صفحة تسجيل الدخول.';
$string['loginpanelbackgroundcolor_help'] = 'تطبيق لون خلفية على لوحة تسجيل الدخول.';
$string['loginpaneltextcolor_help'] = 'تطبيق لون النص على لوحة تسجيل الدخول.';
$string['loginpanelcontentcolor_help'] = 'تطبيق لون النص على محتوى لوحة تسجيل الدخول.';
$string['loginpanellinkcolor_help'] = 'تطبيق لون الرابط على لوحة تسجيل الدخول.';
$string['loginpanellinkhovercolor_help'] = 'تطبيق لون تحويل الرابط على لوحة تسجيل الدخول.';
$string['login-panel-position'] = 'موضع لوحة تسجيل الدخول';
$string['login-panel-position_help'] = 'تعيين موضع لوحة تسجيل الدخول والتسجيل';

$string['login-page-info'] = '<p><b>ملاحظة: </b>لا يمكن معاينة صفحة تسجيل الدخول في المُنظم البصري لأن المستخدمين الذين لم يقوموا بتسجيل الدخول يمكنهم فقط عرضها. يمكنك اختبار الإعداد بحفظه وفتح صفحة تسجيل الدخول في وضع التصفح الخفي.</p>';

$string['login-page-setting'] = 'نمط خلفية الصفحة';
$string['login-page-backgroundgradient1'] = 'اختيار اللون 1';
$string['login-page-backgroundgradient2'] = 'اختيار اللون 2';
$string['loginpanelbackgroundcolor'] = 'لون خلفية الصفحة';
$string['loginpagebackgroundcolor'] = 'اختيار لون الخلفية';
$string['loginpagebackgroundcolor_help'] = 'تعيين خلفية صفحة تسجيل الدخول. يمكنك اختيار اللون أو التدرج أو الصورة.';
$string['login-page-background_help'] = 'تطبيق لون خلفية على لوحة تسجيل الدخول';

/*Customizer Strings*/
$string['primary'] = 'أساسي';
$string['dashboardsettingdesc'] = 'إعدادات ذات صلة بلوحة المعلومات';
$string['dashboardsetting'] = 'لوحة المعلومات';
$string['dashboardpage'] = 'صفحة لوحة المعلومات';
$string['enabledashboardcoursestats'] = 'تمكين إحصائيات دورة اللوحة';
$string['enabledashboardcoursestatsdesc'] = 'إذا تم تمكينه، سيتم عرض إحصائيات الدورة على صفحة اللوحة';

$string['customizecontrolsclose'] = "إغلاق";

// Quick setup customizer.
$string['quicksetup'] = 'إعداد سريع';
$string['pallet'] = 'لوحة ألوان';
$string['colorpallet'] = 'لوحات الألوان';
$string['currentpallet'] = 'اللوحة الحالية';
$string['currentfont'] = 'الخط الحالي';
$string['colorpalletdesc'] = 'وصف لوحات الألوان';
$string['preset1'] = 'الإعداد المسبق 1';
$string['preset2'] = 'الإعداد المسبق 2';
$string['sitefavicon'] = 'رمز الموقع';

$string['themecolors'] = 'ألوان السمة';
$string['brandcolors-heading'] = 'ألوان العلامة التجارية';
$string['border-color'] = 'لون الحدود';
$string['border-hover-color'] = 'لون تحويل الحدود';
$string['smart-colors-heading'] = "تطبيق الألوان العالمية";
$string['smart-colors-info'] = "<p>سيتم تطبيق الألوان العالمية وظلالها / تظليلاتها على الموقع لإنشاء مجموعة ألوان مبهجة بصريًا</p><p><b>ملاحظة: </b>لديك مرونة لتخصيص ألوان العناصر الفردية في أي وقت عن طريق زيارة إعداداتها المحددة.</p>";
$string['apply'] = "تطبيق";
$string['backgroundsettings'] = 'إعدادات الخلفية';

$string['ascent-background-color'] = 'لون خلفية Ascent';
$string['ascent-background-color_help'] = 'تعيين لون خلفية Ascent. سيتم تطبيق هذا اللون على خلفية العلامات على الموقع باستثناء العلامات على بطاقات الدورات وشريط رأس ترويسة الدورة';
$string['element-background-color'] = 'لون خلفية العنصر';
$string['element-background-color_help'] = 'تعيين لون خلفية العنصر. سيتم تطبيق هذا اللون على خلفية النصوص الصغيرة، خلفية تحويل النصوص عند المرور فوقها، خلفية رؤوس الأقسام، التلميحات، وما إلى ذلك';

$string['light-border-color'] = 'لون حدود فاتح';
$string['themecolors-lightbordercolor_help'] = 'تعيين لون حدود فاتح. سيتم تطبيق هذا اللون كحدود للعناصر ذات الخلفية البيضاء مثل القائمة المنسدلة للإخطار على الرأس، بطاقات الدورات، البحث عن قائمة الدورات وعلى خطوط الفواصل في عناصر الكتلة إلخ';

$string['medium-border-color'] = 'لون حدود متوسط';
$string['themecolors-mediumbordercolor_help'] = 'تعيين لون حدود متوسط. سيتم تطبيق هذا اللون كلون للحدود والخطوط الفاصلة. يُطبق بشكل خاص كلون للقوائم المنسدلة ومربع البحث وأيضًا على خلفية العناصر التي يتم تطبيق لها لون الخلفية (يمكنك العثور على إعداد لون خلفية العنصر تحت <b>ألوان السمة > إعدادات الخلفية</b>) مثل خلفية النصوص الصغيرة، خلفية رؤوس الأقسام، التلميحات، وما إلى ذلك';
$string['borderssettings'] = 'إعدادات الحدود';

// Quick Menu settings.
$string['enablequickmenu'] = 'تمكين القائمة السريعة';
$string['enablequickmenudesc'] = 'قائمة روابط سريعة تعوض لسهولة الوصول إلى الصفحات.';

// Left Navigation Drawer.
$string['coursearchivepage'] = 'صفحة أرشيف الدورة';
$string['createanewcourse'] = 'إنشاء دورة جديدة';
$string['remuisettings'] = 'إعدادات RemUI';

$string['bodysettingslinking'] = 'ربط إعدادات متقدمة للرابط';
$string['bodysettingslinking_help'] = 'عند التمكين، سيتم ربط الإعدادات من الفقرة الصغيرة والنص المعلوماتي الصغير مع إعدادات الجسم.';
$string['bodysettingslinked'] = 'مرتبط بإعدادات الجسم';
$string['normal-para-font'] = "فقرة عادية";
$string['smallpara-font'] = "فقرة صغيرة";
$string['smallinfo-font'] = "نص معلومات صغير";

$string['interactiveicons'] = 'أيقونات تفاعلية';
$string['noninteractiveicons'] = 'أيقونات غير تفاعلية';
$string['singlecolorsicon'] = "أيقونة بلون واحد";
$string['scicon-color'] = 'اللون';
$string['scicon-color_help'] = 'لون حالة الراحة لأيقونة بلون واحد';
$string['scicon-hover'] = 'تحويل';
$string['scicon-hover_help'] = 'لون تحويل حالة الراحة لأيقونة بلون واحد';
$string['scicon-active'] = 'نشط';
$string['scicon-active_help'] = 'لون حالة نشطة لأيقونة بلون واحد';

$string['dualcolorsicon'] = "أيقونة بألوان مزدوجة";
$string['dcicon-color'] = 'اللون';
$string['dcicon-color_help'] = 'لون حالة الراحة لأيقونة بألوان مزدوجة';
$string['dcicon-hover'] = 'تحويل';
$string['dcicon-hover_help'] = 'لون تحويل حالة الراحة لأيقونة بألوان مزدوجة';
$string['dcicon-active'] = 'نشط';
$string['dcicon-active_help'] = 'لون حالة نشطة لأيقونة بألوان مزدوجة';

$string['non-interactive-color'] = 'اللون';
$string['non-interactive-color_help'] = 'لون أيقونة غير تفاعلية';
$string['textlink'] = 'رابط نصي';

$string['header-logo-setting'] = 'إعدادات شعار الرأس';
$string['logo-bg-color'] = 'لون خلفية الشعار';
$string['logo-bg-color_help'] = 'تعيين لون خلفية لشعار العلامة التجارية في الرأس.';
$string['header-design-settings'] = 'إعدادات تصميم الرأس';
$string['hide-show-menu-item'] = 'إخفاء / إظهار عنصر القائمة';
$string['hide-dashboard'] = 'إخفاء لوحة التحكم';
$string['hide-dashboard_help'] = 'بتمكين هذا، سيتم إخفاء عنصر لوحة التحكم في الرأس';
$string['hide-home'] = 'إخفاء الصفحة الرئيسية';
$string['hide-home_help'] = 'بتمكين هذا، سيتم إخفاء عنصر الصفحة الرئيسية في الرأس';
$string['hide-my-courses'] = 'إخفاء دوراتي';
$string['hide-my-courses_help'] = 'بتمكين هذا، سيتم إخفاء عنصر "دوراتي" والدورات المتداخلة في الرأس';
$string['hide-site-admin'] = 'إخفاء إدارة الموقع';
$string['hide-site-admin_help'] = 'بتمكين هذا، سيتم إخفاء عنصر إدارة الموقع في الرأس';
$string['hide-recent-courses'] = 'إخفاء الدورات الحديثة';
$string['hide-recent-courses_help'] = 'بتمكين هذا، سيتم إخفاء القائمة المنسدلة "الدورات الحديثة" في الرأس';
$string['header-menu-element-bg-color'] = 'لون خلفية العنصر';
$string['header-menu-element-bg-color_help'] = 'لون خلفية العنصر';
$string['header-menu-divider-bg-color'] = 'لون فاصل العنصر';
$string['header-menu-divider-bg-color_help'] = 'لون فاصل العنصر';
$string['hds-iconcolor'] = 'لون أيقونة الرأس';
$string['hds-boxshadow'] = 'ظل صندوق الرأس';

$string['hds-menuitems'] = 'عناصر قائمة الرأس';
$string['hds-menu-fontsize_desc'] = 'تعيين حجم الخط لعناصر قائمة الرأس';
$string['hds-menu-color'] = 'لون عنصر القائمة';
$string['hds-menu-color_desc'] = 'تعيين لون عنصر قائمة الرأس';
$string['hds-menu-hover-color'] = 'لون تحويل عنصر القائمة';
$string['hds-menu-hover-color_desc'] = 'تعيين لون تحويل عنصر قائمة الرأس';
$string['hds-menu-active-color'] = 'لون الحالة النشطة لعنصر القائمة';
$string['hds-menu-active-color_desc'] = 'تعيين لون الحالة النشطة لعنصر قائمة الرأس';

$string['hds-icon-color'] = 'لون الأيقونات';
$string['hds-icon-color_help'] = 'لون الأيقونات في قائمة الرأس';
$string['hds-icon-hover-color'] = 'لون تحويل الأيقونات';
$string['hds-icon-hover-color_help'] = 'لون تحويل الأيقونات في قائمة الرأس';
$string['hds-icon-active-color'] = 'لون الحالة النشطة للأيقونات';
$string['hds-icon-active-color'] = 'لون الرموز نشط';
$string['hds-icon-active-color_help'] = 'لون رموز قائمة الترويسة في حالة النشاط';

$string['preset1'] = "الإعداد المسبق 1";
$string['preset2'] = "الإعداد المسبق 2";
$string['preset3'] = "الإعداد المسبق 3";
$string['fonts'] = "الخطوط";
$string['show'] = "عرض";
$string['hide'] = "إخفاء";

$string['other-bg-color'] = 'ألوان الخلفية الأخرى';
$string['text-link-panel'] = 'رابط نصي';
$string['colorpalletes'] = 'لوحات الألوان';
$string['selectpallete'] = 'اختر اللوحة';
$string['selectfont'] = 'اختر الخط';

$string['socialiconspanel'] = "لوحة الرموز الاجتماعية";
$string['social-icons-info'] = "<p>لعرض الرموز الاجتماعية في الجزء السفلي من أي عمود به محتوى، اذهب إلى <b>التذييل > منطقة التذييل الرئيسية > ويدجيت > حدد النوع = المحتوى </b> وقم بتشغيل إعداد عرض الرموز الاجتماعية.</p>";
$string['social-icons-heading'] = "الرموز الاجتماعية";
$string["custommenulinktext"] = 'عناصر القائمة المخصصة';
$string["custommenulink"] = '<h6>عناصر القائمة المخصصة</h6><p> لإضافة / تحرير / حذف عناصر القائمة المخصصة، اذهب إلى إدارة الموقع > المظهر > إعدادات النسق > <a href="{$a}/admin/settings.php?section=themesettings#admin-custommenuitems" target ="_blank" class="text-decoration-none">عناصر القائمة المخصصة للمسؤول</a> <p>';
$string['note'] = 'ملاحظة';
$string['social-media-selection-note'] = "<p>اضغط على Ctrl لتحديد / إلغاء تحديد الوسائط</p>";

$string['editmodeswitch'] = "تبديل وضع التحرير";
$string['continue'] = 'متابعة';
$string['viewcourse'] = 'عرض الدورة';
$string['hiddencourse'] = 'الدورة المخفية';
$string['openquickmenu'] = 'فتح القائمة السريعة';
$string['closequickmenu'] = 'إغلاق القائمة السريعة';
$string['start'] = 'بدء';

$string['readmore'] = 'قراءة المزيد';
$string['readless'] = 'قراءة أقل';
$string['setting'] = 'الإعدادات';
$string['lastaccess'] = 'آخر الوصول ';
$string['certificate'] = 'الشهادات';
$string['badge'] = 'الشارات';
$string['firstname'] = 'الاسم الأول';
$string['lastname'] = 'الاسم الأخير';
$string['badgefrom'] = 'الشارات من {$a}';
$string['timelinenoevenettext'] = 'لا توجد أنشطة قادمة بسبب';
$string['description']  = 'الوصف';
$string['instructorcounttitle'] = "مدرسون إضافيون متاحون في الدورة";

$string['personalizer'] = "التخصيص المرئي";
$string['edwpersonalizer'] = "التخصيص المرئي";
$string['editinpersonalizer'] = "تعديل باستخدام المخصص";
$string['activepersonalizer'] = "عرض في التخصيص المرئي Edwiser.";
$string['searchtotalcount'] = 'عرض {$a} نتائج';
$string['noresutssearchmsg'] = "<h4 class ='p-p-6 text-center m-0 '>لا يوجد شيء لعرضه</h4>";
$string['globarsearchresult'] = "نتائج البحث العالمية";
$string['searchresultdesctext']  = 'عرض النتائج ل';
$string['noresultfoundmg'] = "<h4 class ='p-p-6 text-center m-0 '>لم يتم العثور على نتائج</h4>";

$string['enrol_relatedcourses'] = 'الدورات ذات الصلة';
$string['enrol_latestcourses'] = 'أحدث الدورات';
$string['enrol_coursecardesc'] = 'اكتشف البرنامج المثالي لك في دوراتنا.';
$string['enrol_viewall'] = 'عرض الكل';

$string['showrelatedcourse'] = "عرض الدورات ذات الصلة";
$string['showrelatedcoursedesc'] = "تمكين هذا الإعداد لعرض الدورات ذات الصلة على صفحة التسجيل.";

$string['showlatestcourse'] = 'عرض أحدث الدورات';
$string['showlatestcoursedesc'] = 'تمكين هذا الإعداد لعرض أحدث الدورات على صفحة التسجيل.';

$string['latestcoursecount'] = 'عدد كتل الدورات الأحدث';
$string['latestcoursecountdesc'] = 'تعيين عدد الدورات الأحدث المعروضة على صفحة التسجيل';

$string['allcourescattext'] = 'جميع الفئات';
$string['archivecoursecounttext'] = 'دورات';
$string['coursecardlessonstext'] = 'الدروس';
$string['prevsectionbuttontext'] = 'القسم السابق';
$string['nextsectionbuttontext'] = 'القسم التالي';

$string['eight'] = '8';
$string['twelve'] = '12';
$string['sixteen'] = '16';
$string['twenty'] = '20';

// My Course Page.
$string['resume'] = 'استئناف';
$string['start'] = 'بدء';
$string['completed'] = 'مكتمل';

$string['siteannouncementheading'] = 'إعلان الموقع على نطاق واسع';
$string['siteannouncementheadingdesc'] = 'تمكين إعلان الموقع على نطاق واسع لجميع المستخدمين.';
$string['seosettingsheading'] = 'إعدادات SEO';
$string['seosettingsheadingdesc'] = 'تحسين رؤية موقع الويب الخاص بك في محركات البحث.';
$string['sitecustomizationhead'] = 'تخصيص الموقع';
$string['sitecustomizationheaddesc'] = 'اختيار الخطوط، حجم التخطيط للصفحات ويمكنك تخصيصها بواسطة CSS.';
$string['advancefeatureshead'] = 'إعدادات الميزات المتقدمة';
$string['advancefeaturesheaddesc'] = 'تحسين تجربتك التعليمية مع الإعدادات المتقدمة.';
$string['mainfooterareahead'] = 'منطقة التذييل الرئيسية';
$string['mainfooterareaheaddesc'] = 'إعدادات منطقة التذييل الرئيسية';

// heading-advance weight settings
$string['heading-adv-setting'] = 'إعدادات وزن الرأس السابق';
$string['heading-regular-fontweight'] = 'وزن الخط العادي';
$string['heading-semibold-fontweight'] = 'وزن الخط نصف العريض';
$string['heading-bold-fontweight'] = 'وزن الخط العريض';
$string['heading-exbold-fontweight'] = 'وزن الخط الخارق للعريض';

// Usage tracking.
$string['usagedatatracker'] = 'تتبع بيانات الاستخدام';
$string['enableusagetracking'] = 'تمكين تتبع الاستخدام';
$string['enableusagetrackingdesc'] = "<strong>ملاحظة حول تتبع الاستخدام</strong>

<hr class='text-muted' />

<p>سيقوم Edwiser الآن بجمع البيانات المجهولة لإنشاء إحصائيات استخدام المنتج.</p>

<p>ستساعدنا هذه المعلومات في توجيه التطوير في الاتجاه الصحيح وازدهار مجتمع Edwiser.</p>

<p>ومع ذلك، نحن لا نجمع بياناتك الشخصية أو بيانات طلابك أثناء هذه العملية. يمكنك تعطيل هذا من الإضافة في أي وقت ترغب في الاستبعاد من هذه الخدمة.</p>

<p>يمكن العثور على نظرة عامة على البيانات المجمعة <strong><a href='https://forums.edwiser.org/topic/67/anonymously-tracking-the-usage-of-edwiser-products' target='_blank'>هنا</a></strong>.</p>";

$string['profileinterestinfo'] = 'لتحرير الاهتمامات، اذهب إلى إعدادات الملف الشخصي -> تحرير الملف الشخصي ->';
$string['profileinterest'] = 'الاهتمامات';
$string['citytowntext'] = 'المدينة / البلدة';
$string['selectcountrystring'] = 'اختر البلد...';

$string['heading-fontweight_desc'] = 'تعيين وزن الخط للعناوين للموقع بأكمله.';
$string['small-para-fontweight_desc'] = 'تعيين وزن الخط للفقرة الصغيرة للموقع بأكمله.';
$string['small-info-fontweight_desc'] = 'تعيين وزن الخط للمعلومات الصغيرة للموقع بأكمله.';

$string['full-width-top'] = 'أعلى بعرض كامل';
$string['full-bottom'] = 'أسفل بعرض كامل';


$string['homepageedwpagebuilderoption'] = "استخدام Edwiser Pagebuilder للصفحة الرئيسية";

$string['livecustomizer'] = "مُخصص الحي";

$string['loaderimagehead'] = 'صورة تحميل الموقع';
$string['loaderimagedesc'] = 'اختيار صورة تحميل لموقعك';

$string['region-full-bottom'] = 'المنطقة السفلية بعرض كامل';
$string['region-full-width-top'] = 'المنطقة العلوية بعرض كامل';

$string['homepagetransparentheadertitle'] = 'نمط الهيدر الشفاف للصفحة الرئيسية';
$string['homepagetransparentheaderdesc']  = "اجعل هيدر الصفحة الرئيسية شفافًا";

$string['frontpageheadercolortitle'] = 'اختيار لون نص الهيدر';
$string['frontpageheadercolordesc']  = "اختيار لون نص الهيدر";

$string['transparentheaderheader'] = 'نمط هيدر الصفحة الرئيسية';
$string['transparentheaderheaderdesc'] = 'تمكين / تعطيل نمط الهيدر الشفاف';

$string['hidehomepageelement'] = 'إخفاء عناصر الصفحة الرئيسية';
$string['hidehomepageelementdesc'] = 'إخفاء رأس المحتوى والملاحة الفرعية وقسم النشاط';

$string['hideheadercontenttitle'] = 'إخفاء رأس المحتوى';
$string['hideheadercontentdesc'] = 'إذا تم تمكينه، سيتم إزالة اسم الموقع والملاحة الثانوية لمودل من الصفحة الرئيسية';

$string['hideactivitysectiontitle'] = 'إخفاء قسم النشاط';
$string['hideactivitysectiondesc'] = 'إذا تم تمكينه، سيتم إخفاء قسم النشاط على الصفحة الرئيسية.';

$string['floataddblockbtnregionselectionmsg'] = 'سيتم إضافة كتل جديدة إلى منطقة "{$a}" المرئية حاليًا';

// settings page deprication design strings
$string['settingpage-dep-top-st1'] = 'إدخال طريقة أفضل لإنشاء وتخصيص الصفحات الرئيسية!';
$string['settingpage-dep-top-st2'] = 'نحن متحمسون لتقديم مُنشئ الصفحات Edwiser RemUI لإنشاء الصفحة الرئيسية مع مكتبة القوالب المُصممة حديثًا التي تتألف من أكثر من 30 قالب كتلة و 7 تخطيطات للصفحة الرئيسية';
$string['settingpage-dep-top-st3'] = '1. تحديث مُنشئ الصفحات Edwiser RemUI إلى الإصدار v4.2.0 وما فوق من <a href="https://edwiser.org/my-account/" target="_blank">هنا</a>';

$string['settingpagedepbottomst1'] = 'حدد مُنشئ الصفحات في القائمة المنسدلة أعلاه، وانتقل إلى الصفحة الرئيسية لإنشاء تصميم جديد للصفحة الرئيسية.';
$string['settingpagedepbottomst2'] = 'تعلم المزيد';
$string['settingpagedepbottomst3'] = 'أو';

$string['settingpagedepbottomsecondaryst1'] = 'الترحيل التلقائي لمحتوى مُنشئ الصفحات إلى مُنشئ الصفحات Edwiser.';
$string['settingpagedepbottomsecondaryst2'] = '<span class="para-semibold-1 m-0">ملاحظة:</span> يتطلب إصدار مُنشئ صفحة البداية Edwiser v4.2.0 وإصدار مُنشئ الصفحات Edwiser RemUI v4.1.3.';
$string['settingpagedepbottomsecondaryst3'] = 'ماذا سيحدث؟';
$string['settingpagedepbottomsecondaryst4'] = 'سيتم نقل رمز ومحتوى كل قسم من صفحة البداية الحالية إلى كتلة HTML مخصصة في مُنشئ الصفحات Edwiser RemUI. سيبقى تصميم ومحتوى الصفحة كما هو، وستتمكن من تحريره بسهولة بطريقة "بدون كود" باستخدام مُنشئ الصفحات Edwiser RemUI.</strong>';
$string['settingpagedepbottomsecondaryst5'] = '<span class="para-semibold-1 m-0">ملاحظة:</span> هذا هو التحديث النهائي بشأن مُنشئ صفحة البداية. لقد تم دمجه الآن في مُنشئ الصفحات Edwiser.';


$string['upgradeherelinktext'] = 'الترقية هنا';

$string['addnewpage'] = "إضافة صفحة جديدة";

$string['edwiserfeedback'] = "ملاحظات Edwiser";
$string['edwiserhelp'] = "مساعدة Moodle";
$string['edwisersupport'] = "دعم Edwiser";


// Course page new settings and improvement stirings
$string['courseinfocontrolhead'] = "التحكم في معلومات الدورة التدريبية";
$string['courseinfocontroldesc'] = "التحكم في رؤية المعلومات المتعلقة بالدورة التدريبية في جميع أنحاء الموقع";

$string['coursedatevisibilityhead'] = "إظهار 'التاريخ' في الدورة التدريبية";
$string['coursedatevisibilitydesc'] = "إظهار 'التاريخ' في الدورة التدريبية";

$string['hidedate'] = "عدم الإظهار";
$string['showstartdate'] = "إظهار تاريخ البدء";
$string['showupdatedate'] = "إظهار 'تم التحديث في' تاريخ";
$string['showstartwhenend'] = "إظهار تاريخ البدء عندما يتم تعيين تاريخ الانتهاء";

$string['enrolleduserscountvisibilityhead'] = "إظهار معلومات 'الطلاب المسجلين'";
$string['enrolleduserscountvisibilitydesc'] = "تعطيل لإخفاء معلومات 'الطلاب المسجلين'";

$string['lessonsvisiblityoncoursecardhead'] = "إظهار معلومات 'الدروس'";
$string['lessonsvisiblityoncoursecarddesc'] = "تعطيل لإخفاء معلومات 'الدروس'";

$string['coursecardsettingshead'] = "بطاقة الدورة";
$string['coursecardsettingsdesc'] = "إعدادات ذات صلة ببطاقة الدورة";

$string['headeroverlayopacityhead'] = "تغيير شفافية التراكب";
$string['headeroverlayopacitydesc'] = "القيمة الافتراضية مضبوطة بالفعل على '100'. لضبط الشفافية، يرجى إدخال قيمة بين 0 و 100";

$string['showless'] = 'عرض أقل';
$string['showmore'] = 'عرض أكثر';

$string['coursestarted'] = "بدأت";
$string['courseupdated'] = "تم التحديث";

$string['coursecardlessonssingletext'] = 'درس';
$string['coursecardsenrolledetxt'] = 'الطلاب المسجلين';

$string['showenrolledtexthead'] = 'إظهار عنوان "الطلاب المسجلين"';
$string['showenrolledtextdesc'] = '';


$string['showenrolledtextinputhead'] = '';
$string['showenrolledtextinputdesc'] = 'إعادة تسمية عنوان "الطلاب المسجلين".<br><strong>يُوصى بأقصى 8 أحرف</strong>';
$string['showenrolledtextinputdefaulttext'] = 'الطلاب المسجلين';

$string['showlessontexthead'] = 'إظهار عنوان "الدروس"';
$string['showlessontextdesc'] = '';


$string['showlessontextinputhead'] = '';
$string['showlessontextinputdesc'] = 'إعادة تسمية عنوان "الدروس".<br><strong>يُوصى بأقصى 8 أحرف</strong>';
$string['showlessontextinputdefaulttext'] = 'الدروس';

$string['editcoursetitle'] = 'تحرير عنوان الدورة';
$string['changecategory'] = 'تغيير الفئة';
$string['editreviewapproval'] = 'تحرير موافقة المراجعة';
$string['addchangevideo'] = 'إضافة / تغيير الفيديو';
$string['novideomessage'] = 'لا يوجد فيديو.<br>انقر على الرابط أعلاه لإضافة فيديو.';
$string['changecourseimage'] = 'تغيير صورة الدورة';
$string['changebtntextandlink'] = 'أضف رابط تسجيل مخصص وسعر';
$string['edit'] = 'تحرير';
$string['viewalltext'] = 'عرض الكل';
$string['addremuicustomfield'] = 'إضافة حقل مخصص RemUI';
$string['editremuicustomfield'] = 'تحرير حقل مخصص RemUI';
$string['howtoaddcustomfield'] = 'كيفية \'إضافة وتحرير\' حقول RemUI المخصصة؟';
$string['changebtntext'] = 'تغيير نص الزر';
$string['addlink'] = 'إضافة رابط';
$string['save'] = 'حفظ';
$string['cancel'] = 'إلغاء';
$string['updateenrollmentmethods'] = 'تحديث <span class="text-lowercase">{$a}</span> الطرق';
$string['hideenrollmentoptions'] = 'إخفاء خيارات <span class="text-lowercase">{$a}</span>';
$string['showenrollmentoptions'] = 'عرض خيارات <span class="text-lowercase">{$a}</span>';
$string['editcoursetext'] = 'تحرير نص الدورة';
$string['editcoursecontent'] = 'تحرير محتوى الدورة';
$string['manageinstructors'] = 'إدارة المدربين';
$string['message'] = 'رسالة';
$string['email'] = 'البريد الإلكتروني:';
$string['editcoursessectionsettings'] = 'تحرير إعدادات أقسام الدورات';
$string['sectionishiddenmessage'] = 'هذا القسم مخفي.<br>لجعله مرئيًا، انقر فوق الرابط أعلاه \'عرض خيارات التسجيل\'';
$string['noreviewmessage'] = 'حاليًا، لا توجد مراجعة.<br> للتحقق من المراجعات \'المعلقة للموافقة\'، انقر على الرابط ‘تحرير موافقة المراجعة’';
$string['backtothecourse'] = 'العودة إلى الدورة';
$string['viewcourseenrollmentpage'] = 'عرض صفحة الدورة <span class="text-lowercase">{$a}</span>';
$string['unenroll'] = 'إلغاء التسجيل';
$string['toactivateenrollmenttext'] = 'لتفعيل رابط صفحة التسجيل الخاصة بك ';
$string['showhidefreelabel'] = 'عرض/إخفاء ملصق \'مجانًا\'';
$string['norelatedcoursemessage'] = 'تم إخفاء قسم \'الدورات المتعلقة\'.<br>لجعله مرئيًا، انقر فوق الرابط أعلاه \'تحرير إعدادات أقسام الدورات\'';
$string['nolatestcoursemessage'] = 'تم إخفاء قسم \'أحدث الدورات\'.<br>لجعله مرئيًا، انقر فوق الرابط أعلاه \'تحرير إعدادات أقسام الدورات\'';
$string['showhidefreelabel'] = 'عرض/إخفاء ملصق \'مجانًا\'';
$string['editpricing'] = 'تحرير التسعير';
$string['nocontentmessage'] = 'لا يوجد محتوى في هذا القسم.<br>لإضافة محتوى، انقر فوق الرابط أعلاه \'تحرير نص الدورة\'';
$string['noinstructormessage'] = 'لا يوجد مدرب مسجل في هذه الدورة.<br>لإضافة مدرب، انقر فوق الرابط أعلاه \'إدارة المدربين\'';
$string['noinstructor'] = 'لا مدرب';

//Dark mode settings strings
$string['darkmodetitilestring'] = 'الوضع الداكن';
$string['lightmodetitlestring'] = 'الوضع الفاتح';
$string['darkmodesettingshead'] = 'إعدادات الوضع الداكن';
$string['darkmodesettingsheaddesc'] = 'تحكم في وضع موقعك الإلكتروني الفاتح والداكن';
$string['enabledarkmode'] = 'تمكين وظيفة الوضع الداكن';
$string['enabledarkmodedesc'] = '';
$string['dmoption_disable'] = 'تعطيل';
$string['dmoption_allowonallpages'] = 'السماح على جميع الصفحات';
$string['dmoption_excludepages'] = 'السماح على جميع الصفحات باستثناء هذه الصفحات';
$string['dmoption_includepages'] = 'السماح فقط على هذه الصفحات';
$string['darkmodeincludepages'] = 'التضمين فقط على هذه الصفحات';
$string['darkmodeincludepagesdesc']  = '<div><strong>لإدارة الوضع الداكن على صفحات معينة، أضف ببساطة رابط الصفحة.</strong>
<pre>مثال:
    لتضمين/استبعاد الوضع الداكن على صفحة دورة معينة (مثل الدورة بالمعرف 2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>لإدارة الوضع الداكن على مجموعة من الصفحات</strong>
<pre>مثال:
    لتضمين/استبعاد الوضع الداكن على جميع صفحات الدورة
    <moodlesite.com>/course/view.php%
</pre>
لمزيد من التفاصيل <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">انقر هنا</a>.</div>';

$string['darkmodeexcludepages'] = 'استثناء الصفحات';
$string['darkmodeexcludepagesdesc']  = '<div><strong>لإدارة الوضع الداكن على صفحات معينة، أضف ببساطة رابط الصفحة.</strong>
<pre>مثال:
    لتضمين/استبعاد الوضع الداكن على صفحة دورة معينة (مثل الدورة بالمعرف 2)
    <MoodleSite.com>/course/view.php?id=2
</pre>
<strong>لإدارة الوضع الداكن على مجموعة من الصفحات</strong>
<pre>مثال:
    لتضمين/استبعاد الوضع الداكن على جميع صفحات الدورة
    <moodlesite.com>/course/view.php%
</pre>
لمزيد من التفاصيل <a href="https://edwiser.org/documentation/edwiser-remui/dark-mode/" target="_blank">انقر هنا</a>.</div>';

$string['customizerdarkmodewarning'] = "يرجى ملاحظة أن التغييرات التي يتم إجراؤها في Visual Personalizer ستُطبق على 'الوضع الفاتح' من الموقع وستنعكس تلقائيًا في 'الوضع الداكن' أيضًا.";
$string['customizerdarkmodedonotshowbtntext'] = 'لا تظهر مرة أخرى';
$string['customizerdarkmodeok'] = 'موافق';
$string['previewswitchon'] = 'تشغيل';
$string['previewswitchoff'] = 'إيقاف';
$string['darkmodepreview'] =  'معاينة الوضع الداكن';
$string['darkmodecustomizernote']='<li>في "المُضبِّط البصري"، ستتم جميع التغييرات في "الوضع الفاتح" من الموقع، وستنعكس تلقائيًا في "الوضع الداكن".</li>
<li>سيتم تعطيل إعدادات المُضبِّط البصري أثناء المعاينة في الوضع الداكن.</li>';
$string["switchtodm"] = "الوضع الداكن";
$string["switchtolm"] = "الوضع الفاتح";
$string["disabledmwarning"] = "لتمكين المُضبِّط البصري، قم بإيقاف معاينة الوضع الداكن.";


$string["here"] = "هنا";
$string["clickhere"] = "انقر هنا";
$string["settingpagedepbottomsecondaryst2b"] = '<a href="https://edwiser.org/my-account/" target="_blank" >انقر هنا</a> لتنزيل وتحديث الإضافات إلى أحدث إصدار.';
$string['settingpage-dep-top-st4'] = '1. قم بتنزيل وتثبيت مُنشئ صفحات Edwiser RemUI إلى الإصدار v4.2.0 وما فوق من <a href="https://edwiser.org/my-account/" target="_blank">هنا</a>';
$string['viewcoursetitle'] = 'عرض الدورة';
$string['okay'] = 'حسنًا!';
$string['forcefulmigrate'] = 'هجرة قسرية';

$string['moodleblocks'] = 'كتل Moodle';

$string['citytown'] = 'المدينة/البلدة';
$string['searchtext'] = 'بحث في النص';
$string['enablesiteloader'] = "تفعيل/تعطيل صورة التحميل";
$string['enablesiteloaderdesc'] = "لتعطيل صورة التحميل المتحركة (GIF) على الموقع، قم بإلغاء تحديد المربع المسمى \"تفعيل/تعطيل صورة التحميل\". لتفعيلها، ببساطة قم بتحديد المربع.";
$string['aria:courseimage'] = 'صورة الدورة';

$string['addcustomprice'] = 'أضف سعرًا مخصصًا';
$string['enablepricingsettingstext'] = 'تفعيل السعر الافتراضي سيزيل "السعر المخصص ورابط التسجيل المخصص".';
$string['enabledefaultpricing'] = 'تفعيل السعر الافتراضي';
$string["dashboardstatsupdate"] = "تحديث إحصائيات RemUI";

$string["filters"] = "الفلاتر";
$string["applyfilters"] = "تطبيق الفلاتر";
$string["clear"] = "مسح";
$string["level"] = "المستوى";
$string["ratings"] = "التقييمات";
$string["free"] = "مجاني";
$string["paid"] = "مدفوع";
$string["rating4"] = "4 وما فوق";
$string["rating3"] = "3 وما فوق";
$string["newest"] = "الأحدث";
$string["oldest"] = "الأقدم";
$string["highrating"] = "تقييم عالي";
$string["lowrating"] = "تقييم منخفض";
$string["date"] = "التاريخ";
$string["alphabetical"] = "أبجدي";
$string["showcourseperpage"] = "عرض الدورة لكل صفحة";
$string["close"] = "إغلاق";
$string["row2"] = "عرض:2 صف";
$string["row3"] = "عرض:3 صفوف";
$string["row4"] = "عرض:4 صفوف";
$string["row5"] = "عرض: 5 صفوف";
$string["row6"] = "عرض: 6 صفوف";

$string["filteremptymsg"] = "ملاحظة: لعرض الفلاتر، أضف خصائص الفلترة مثل المستويات، السعر، التقييمات، واللغات إلى الدورة.";

$string['sectionaddmax'] = 'لقد وصلت إلى الحد الأقصى لعدد الأقسام المسموح به للدورة...';
$string['prevsubsectionbuttontext'] = 'القسم الفرعي السابق';
$string['nextsubsectionbuttontext'] = 'القسم الفرعي التالي';